/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
#include <sys/types.h>

typedef struct FrameBufInfo *		FrameBufInfo;
typedef struct FrameBufColormapEntry *	FrameBufColormapEntry;
typedef struct FrameBufTimedImage *	FrameBufTimedImage;
typedef struct FrameBufCallback *       FrameBufCallback;

struct FrameBufColormapEntry {
    unsigned	index;
    unsigned	red;
    unsigned	green;
    unsigned	blue;
    unsigned    maxi; /* maximum index */
};

struct FrameBufInfo {
    unsigned	stride;		/* distances to go for one line */
    unsigned	width;		/* framebuffer width in pixels */
    unsigned	height;		/* framebuffer height in pixels */
    unsigned    depth;          /* framebuffer depth */
    void *	fbmem;		/* frame buffer memory */
    u_long	vsyncPeriod;	/* vertical sync period in usec */
};

struct FrameBufTimedImage {
    u_long	showtime;	/* vsync tick at which to display image */
    unsigned	owner;		/* don't touch---implementation detail */
    char	data[0];	/* really: width*height pixels */
};

struct FrameBufCallback {
  void    (*func)(AnyType arg1, AnyType arg2);
  AnyType arg1;
  AnyType arg2;
  FrameBufCallback next;
};

int DeviceInitBuffer(FrameBufInfo fb);
int DeviceSetResolution(int res);
int DeviceColorMapWrite(FrameBufColormapEntry color);
int DeviceColorMapRead(FrameBufColormapEntry color);
int DeviceFGIndex();
#if 0
int DeviceRegCallback(FrameBufCallback fcb);
#endif
