/*
 * Copyright (c) 1997 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * no, I haven't heard of libpcap....
 */
#include <oskit/c/stdio.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/param.h>		/* for BSD */
#include <sys/socket.h>
#include <net/bpf.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <fcntl.h>
#include "native.h"

/* old FreeBSD */
#if BSD == 199306
#define CMD \
    "netstat -I %s | fgrep Link | awk '{print substr($3,7)}' | sed 's/\\./ /g'"
#elif BSD == 199506
/* FreeBSD 2.2.5 stable */
#define CMD \
    "netstat -I %s | fgrep Link | awk '{print $4}' | sed 's/\\./ /g'"
#else
#error Define CMD!
#endif

/*
 * install a bpf excluding IEEE 802.3 packets
 */
void exclude_ieee802_3(int dev)
{
	struct bpf_insn insns[] = {
		/* copy halfword at absolute offset 12 in accummulator */
		BPF_STMT(BPF_LD+BPF_H+BPF_ABS, 12),
		/* if greater or equal to 1500, advance 1, else 2 instr */ 
		BPF_JUMP(BPF_JMP+BPF_JGE+BPF_K, 1500, 0, 1),
		/* accept packet */
		BPF_STMT(BPF_RET+BPF_K, (u_int)-1),
		/* reject packet */
		BPF_STMT(BPF_RET+BPF_K, 0),
	};

	struct bpf_program pr = { sizeof(insns)/sizeof(insns[0]), insns } ;
	int    err;

	err = NATIVEOS(ioctl)(dev, BIOCSETF, &pr);
	if (err == -1)
		perror("BIOCSETF"), exit(-1);
}

int
open_eth(char *ifname, char *myaddr, unsigned int *buflen, int no_ieee802_3)
{
	struct ifreq ifr;
	struct timeval zero = {0, 0};
	int dev, i, rc; 
	int on = 1;
#if 0
	FILE *p;
#endif
	char *bp, buf[1024];
	char *device = "/dev/bpf1"; 	/* leave /dev/bpf0 for tcpdump */
	int mypid = - NATIVEOS(getpid)();

	dev = NATIVEOS(open)(device, O_RDWR);
	if (dev == -1)
		perror(device), exit(0);

	rc = NATIVEOS(ioctl)(dev, BIOCGBLEN, buflen);
	if (rc == -1)
		perror("BIOCGBLEN"), exit(0);

	/* printf("buflen set to %d\n", *buflen); */

	strcpy(ifr.ifr_name, ifname);
	rc = NATIVEOS(ioctl)(dev, BIOCSETIF, &ifr);
	if (rc == -1)
		perror("BIOCSETIF"), exit(0);

	/* BIOCIMMEDIATE (u_int)
	     Enable  or  disable ``immediate mode'', based on the truth 
	     value of the argument.  When immediate mode  is  enabled, 
	     reads return immediately upon packet reception.  Otherwise, 
	     a read will  block until either the kernel buffer becomes 
	     full or a timeout occurs.  This  is  useful  for  programs
	     like  rarpd(8c),  which must respond to messages in real 
	     time.  The default for  a  new  file  is off.
	*/
	/* I definitely need this because else bpf_wakeup wouldn't be called */
	rc = NATIVEOS(ioctl)(dev, BIOCIMMEDIATE, &on);
	if (rc == -1)
		perror("BIOCIMMEDIATE"), exit(0);

	/* flush buffers, reset statistic counters */
	rc = NATIVEOS(ioctl)(dev, BIOCFLUSH, 0);
	if (rc == -1)
		perror("BIOCFLUSH"), exit(0);

#if 0
	/* I don't need this since the bd_rtout is set to -1 by O_ASYNC,
	 * preventing BPF_SLEEP from getting called and bd_rtout from
	 * getting used
	 */
	rc = NATIVEOS(ioctl)(dev, BIOCSRTIMEOUT, 0);
	if (rc == -1)
		perror("BIOCSRTIMEOUT"), exit(0);
#endif

	if (no_ieee802_3)
		exclude_ieee802_3(dev);

	rc = NATIVEOS(ioctl)(dev, BIOCPROMISC, 0);
	if (rc == -1)
		perror("BIOCPROMISC"), exit(0);

	rc = NATIVEOS(ioctl)(dev, BIOCGETIF, &ifr);
	if (rc == -1)
		perror("BIOCGETIF"), exit(0);
	/* printf("connected to interface `%s'\n", ifr.ifr_name); */
#if 0
	sprintf(buf, CMD, ifname);
	if (!(p = NATIVEOS(popen)(buf, "r")))
		perror(buf), exit(0);

	for (i = 0; i < 6; i++) {
		int x;
		fscanf(p, "%x", &x);
		myaddr[i] = x;
	}
	NATIVEOS(pclose)(p);
#else
	if ((bp = (char *) getenv("ETHERADDR")) == NULL) {
		printf("open_eth: ETHERADDR not set\n");
		NATIVEOS(_exit)(1);
	}
	{
		int x0, x1, x2, x3, x4, x5;
		
		sscanf(bp, "%x:%x:%x:%x:%x:%x", &x0, &x1, &x2, &x3, &x4, &x5);
		       
		myaddr[0] = x0;
		myaddr[1] = x1;
		myaddr[2] = x2;
		myaddr[3] = x3;
		myaddr[4] = x4;
		myaddr[5] = x5;
	}
#endif

	/* set fd to async mode */
	rc = NATIVEOS(fcntl)(dev, F_SETFL, O_ASYNC | O_NONBLOCK);
	if (rc == -1)
		perror("fcntl"), exit(0);

	rc = NATIVEOS(ioctl)(dev, TIOCSPGRP, &mypid);
	if (rc == -1)
		perror("TIOCSPGRP"), exit(0);

	return dev;
}

/*
 * Set a file descriptor to non-blocking, async notify I/O. This is
 * here cause this file is compiled with /usr/include ahead of oskit
 * include. The calls to fcntl below need the right headers, and I
 * don't want to have any more files compiled this way.
 */
void
set_async_fd(int fd)
{
	int	rc;
	int     mypid = NATIVEOS(getpid)();
	
	rc = NATIVEOS(fcntl)(fd, F_SETFL, O_ASYNC | O_NONBLOCK);
	if (rc == -1)
		perror("set_async_fd: F_SETFL"), exit(0);

	rc = NATIVEOS(fcntl)(fd, F_SETOWN, mypid);
	if (rc == -1)
		perror("set_async_fd: F_SETOWN"), exit(0);
}

void
unset_async_fd(int fd)
{
	int	rc;
	
	rc = NATIVEOS(fcntl)(fd, F_SETFL, 0);
	if (rc == -1)
		perror("set_async_fd: F_SETFL"), exit(0);
}
