/*
 * Copyright (c) 1997 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
#include <stdlib.h>
#include <oskit/lmm.h>
#include "native.h"

lmm_t malloc_lmm = LMM_INITIALIZER;

#define MAX_HEAP	(16 * 1024 * 1024)
#define MIN_INCR	(16*1024)

void * NATIVEOS(sbrk)(int size);

int morecore(size_t size)
{
	void *mem;
	static int init = 0;

	if (!init) {
		static struct lmm_region reg;	/* must be static !!! */
		oskit_size_t  maxsize = MAX_HEAP;

		lmm_add_region(&malloc_lmm, &reg, NATIVEOS(sbrk)(0), maxsize, 0, 0);
		init = 1;
	}

	/*
	 * Always allocate multiples of MIN_INCR bytes.
	 */
	size = (size + MIN_INCR - 1) & ~(MIN_INCR - 1);

	/*
	 * Extend the heap.
	 */
	mem = NATIVEOS(sbrk)(size);
	if (mem == (void*)-1) {
		/* fail hard, don't call printf! */
		NATIVEOS(write)(1, "sbrk failed\n", 13);
		NATIVEOS(_exit)(-1);
	}

	/*
	 * Add the new chunk to the free pool.
	 * If the new chunk is contiguous with the last one,
	 * lmm_add_free will merge the two chunks if possible.
	 */
	mem_lock();
	lmm_add_free(&malloc_lmm, mem, size);
	mem_unlock();

	return 1;
}

