/*
 * From: /usr/include/sys/signal.h
 */
#define SIGHUP  1       /* hangup */
#define SIGINT  2       /* interrupt */
#define SIGQUIT 3       /* quit */
#define SIGILL  4       /* illegal instruction (not reset when caught) */
#ifndef _POSIX_SOURCE
#define SIGTRAP 5       /* trace trap (not reset when caught) */
#endif
#define SIGABRT 6       /* abort() */
#ifndef _POSIX_SOURCE
#define SIGIOT  SIGABRT /* compatibility */
#define SIGEMT  7       /* EMT instruction */
#endif
#define SIGFPE  8       /* floating point exception */
#define SIGKILL 9       /* kill (cannot be caught or ignored) */
#ifndef _POSIX_SOURCE
#define SIGBUS  10      /* bus error */
#endif 
#define SIGSEGV 11      /* segmentation violation */
#ifndef _POSIX_SOURCE 
#define SIGSYS  12      /* non-existent system call invoked */
#endif
#define SIGPIPE 13      /* write on a pipe with no one to read it */ 
#define SIGALRM 14      /* alarm clock */
#define SIGTERM 15      /* software termination signal from kill */
#ifndef _POSIX_SOURCE 
#define SIGURG  16      /* urgent condition on IO channel */
#endif
#define SIGSTOP 17      /* sendable stop signal not from tty */
#define SIGTSTP 18      /* stop signal from tty */
#define SIGCONT 19      /* continue a stopped process */
#define SIGCHLD 20      /* to parent on child stop or exit */
#define SIGTTIN 21      /* to readers pgrp upon background tty read */
#define SIGTTOU 22      /* like TTIN for output if (tp->t_local&LTOSTOP) */
#ifndef _POSIX_SOURCE
#define SIGIO   23      /* input/output possible signal */
#define SIGXCPU 24      /* exceeded CPU time limit */
#define SIGXFSZ 25      /* exceeded file size limit */
#define SIGVTALRM 26    /* virtual time alarm */
#define SIGPROF 27      /* profiling time alarm */
#define SIGWINCH 28     /* window size changes */
#define SIGINFO 29      /* information request */ 
#endif 
#define SIGUSR1 30      /* user defined signal 1 */
#define SIGUSR2 31      /* user defined signal 2 */
/*
 * end of excerpt from sys/signal.h
 */

#include "support.h"

/*
 * defined by libkern
 */

int phys_mem_max;
int phys_mem_va;
int base_stack_start;

/* 
 * The C library will call this function to say where we should deliver
 * signals.  The C library expects us to deliver all signals to that
 * address.  Some signals we cannot deliver in a straightforward way,
 * so include only a few that are essential for now.
 */
typedef void (*deliver_func_t)(int, int, struct sigcontext *);

void oskit_sendsig_init(deliver_func_t f) 
{
	set_signal_handler(SIGSEGV, f);
	set_signal_handler(SIGBUS, f);
	set_signal_handler(SIGFPE, f);
	/* more ??? */
}
