/*
 * Copyright (c) 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Replaces timestuff.c from liboskit_fs.a.
 */

#include <oskit/fs/fs.h>
#include <oskit/time.h>

#include <sys/time.h>
#include <stdlib.h>
#include <unistd.h>

void
fs_delay(oskit_u32_t usec)
{
	usleep(usec);
}

oskit_error_t
fs_gettime(oskit_timespec_t *tsp)
{
	int err;
	struct timeval tv;

	err = gettimeofday(&tv, NULL);
	if (err)
		return OSKIT_EIO;	/* whatever, should never happen */
	tsp->tv_sec = tv.tv_sec;
	tsp->tv_nsec = tv.tv_usec * 1e+3;
	return 0;
}
