/*
 * Copyright (c) 1996, 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * sigprocmask interface for accessing the per-pthread signal mask.
 *
 * Note that pthread_kill is not implemented (implementable) yet.
 */

#include <threads/pthread_internal.h>

int
pthread_sigmask(int how, const sigset_t *set, sigset_t *oset)
{
	pthread_thread_t	*pthread = CURPTHREAD();
	int			p, err = 0;

	p = splpreempt();

	if (oset)
		*oset = pthread->sigmask;

	if (set) {
		switch (how) {
		case SIG_BLOCK:
			pthread->sigmask |= *set;
			break;
		case SIG_UNBLOCK:
			pthread->sigmask &= ~*set;
			break;
		case SIG_SETMASK:
			pthread->sigmask = *set;
			break;
		default:
			err = EINVAL;
		}
	}

	splx(p);
	return err;
}

int
pthread_kill()
{
	return ENOSYS;
}
