/*
 * Copyright (c) 1996, 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * Join with another thread. This is supposed to be a cancelation point,
 * but thats not working right yet because of a race with cancel I do not
 * know how to fix.
 */
#include <threads/pthread_internal.h>

int
pthread_join(pthread_t tid, void **status)
{
	pthread_thread_t	*joinee, *joiner;
	int			p;

	if (tid < 0 || tid >= THREADS_MAX_THREAD ||
	    tidtothread(tid) == NULL_THREADPTR)
		return EINVAL;

	/*
	 * join must be called with cancelation DEFERRED.
	 */
	pthread_testcancel();

	joinee = tidtothread(tid);
	joiner = CURPTHREAD();

	p = splhigh();
	pthread_lock(&(joinee->lock));
	
	if (joinee->flags & THREAD_DETACHED) {
		pthread_unlock(&(joinee->lock));
		splx(p);
		return EINVAL;
	}

	if (joinee->flags & THREAD_EXITED)
		pthread_unlock(&(joinee->lock));
	else {
		pthread_lock(&joiner->lock);

		/*
		 * Note interaction with pthread_cancel. This works cause
		 * both locks are needed to terminate the join. 
		 */
		joiner->joining_with = joinee;
		joiner->flags       |= THREAD_JOINWAIT;
		joinee->joining_me   = joiner;
		pthread_unlock(&joinee->lock);
		pthread_sched_reschedule(RESCHED_BLOCK, &joiner->lock);
	}

	pthread_testcancel();

	if (status)
		*status = (void *) joinee->exitval;

	pthread_detach(tid);

	return 0;
}
