/*
 * Copyright (c) 1996, 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * Destroy a thread.
 */
#include <threads/pthread_internal.h>
#include <threads/pthread_ipc.h>

/*
 * Internal routine. 
 */
void
pthread_destroy_internal(pthread_thread_t *pthread)
{
	pthread_t	tid = pthread->tid;
	int		p;

	p = splpreempt();

	/*
	 * The main thread is mostly statically allocated, so just
	 * release the tid but leave everything else alone.
	 */
	if (pthread == &threads_mainthread) {
		threads_tidtothread[tid] = 0;
		splx(p);
		return;
	}

	/* machine dependent destroy */
	thread_destroy(pthread);
	
	/*
	 * Callout for memory deallocator. 
	 */
	if (! (pthread->flags & THREAD_USERSTACK))
		threads_deallocator(pthread->pstk);

#ifdef	CPU_INHERIT
	if (pthread->scheduler) {
		schedmsg_t	msg;

		msg.type = MSG_SCHED_EXITED;
		msg.tid  = pthread->tid;
		pthread_sched_message_send(pthread->scheduler, &msg);
	}
#endif
	oskit_timer_release(pthread->condtimer);
	oskit_timer_release(pthread->sleeptimer);
	
	threads_deallocator(pthread);
	
	/*
	 * Release the TID.
	 */
	threads_tidtothread[tid] = 0;
	splx(p);
}
