/*
 * Copyright (c) 1996, 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <threads/pthread_internal.h>

static int	threads_osenv_initialized = 0;

#ifdef THREADS_DEBUG
int
intscheck(void)
{
	if (!threads_osenv_initialized)
		return -1;

	if ((intsenabled() && !machine_intr_enabled()) ||
	    (!intsenabled() && machine_intr_enabled())) {
		panic("intscheck %d %d",
		      intsenabled(), machine_intr_enabled());
	}
	return 0;
}
#endif

/*
 * Enable/disable interrupts.
 */
inline void
osenv_intr_enable()
{
	spllow();
}

inline void
osenv_intr_disable()
{
	splhigh();
}

/*
 * Return the current interrupt enable flag.
 */
inline int
osenv_intr_enabled()
{
	intscheck();
	return intsenabled();
}

/*
 * Called when an interrupt handler is entered or left, to allow interrupt
 * state to made consistent. Nothing to do in base oskit.
 */
inline void
osenv_intr_enter_function(unsigned irq)
{
	if (INTSTATE & SPLHIGH)
		panic("osenv_intr_enter %d", INTSBLOCKED);

	INTSTATE |= SPLHIGH;
}

inline void
osenv_intr_leave_function(unsigned irq)
{
	INTSTATE &= ~SPLHIGH;
}

/*
 * Init the osenv intr module.
 */
void
pthread_init_osenv_intr(void)
{
	osenv_intr_enter = osenv_intr_enter_function;
	osenv_intr_leave = osenv_intr_leave_function;

	if (machine_intr_enabled())
		INTSTATE = 0;
	else
		INTSTATE = SPLHIGH;

	threads_osenv_initialized = 1;
}
