/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <oskit/fs/fs.h>
#include <oskit/c/stdio.h>
#include <oskit/c/stdlib.h>
#include <oskit/c/errno.h>
#include <oskit/c/string.h>
#include <threads/pthread_internal.h>

/*
 * Dumb hack. The netbsd code should be fixed instead, so I'm not gonna get
 * fancy about this. 
 */
struct fs_sleeper {
	void		  *chan;
	osenv_sleeprec_t  sleeprec;
} fs_sleepers[THREADS_MAX_THREAD];

void
fs_wakeup(void *chan)
{
	int		i, s;

	s = splhigh();
	for (i = 0; i < THREADS_MAX_THREAD; i++)
		if (fs_sleepers[i].chan == chan) {
			osenv_wakeup(&fs_sleepers[i].sleeprec,
				     OSENV_SLEEP_WAKEUP);
		}
	splx(s);
}

oskit_error_t
fs_tsleep(void *chan, oskit_u32_t pri, char *wmesg, oskit_u32_t timo)
{
	pthread_thread_t	*pthread = CURPTHREAD();
	int			status;

	fs_sleepers[pthread->tid].chan = chan;
	osenv_sleep_init(&fs_sleepers[pthread->tid].sleeprec);

	status = osenv_sleep(&fs_sleepers[pthread->tid].sleeprec);

	fs_sleepers[pthread->tid].chan = 0;
	
	return status;
}

void
fs_master_lock(void)
{
	osenv_process_lock();
}

void
fs_master_unlock(void)
{
	osenv_process_unlock();
}

void
pthread_init_fs_sleep()
{
}
