/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * start_fs_native_bmod.c
 *
 * start up bmod in native mode, copying in from OSKITROOT.
 */
#include <oskit/dev/error.h>
#include <oskit/fs/dir.h>
#include <oskit/fs/bmodfs.h>

#include <oskit/c/stdio.h>
#include <oskit/c/string.h>
#include <oskit/c/assert.h>

void
start_fs_native_bmod()
{
	oskit_dir_t	*root = oskit_unix_bmod_init();
	char		*fsname;
	char		buf[BUFSIZ], *bp = buf;

	/*
	 * Populate the bmodfs if OSKITROOT is set. The format is a colon
	 * separated list of directories to be copied in.
	 */
        fsname = (char *)getenv("OSKITROOT");
	
        if (fsname) {	
		printf("OSKITROOT=%s\n", fsname);
	
		while (*fsname) {
			while (*fsname && *fsname != ':')
				*bp++ = *fsname++;
			*bp = '\0';

			oskit_unix_bmod_copydir(root, buf);

			if (*fsname == ':')
				fsname++;
			bp = buf;
		}
	}

	/* 
	 * Must not wrap it because the wrapper won't work because
	 * they don't use the soa wrapper if file::open returns null;
	 * also, the bmod fs should be protected anyway by its own lock.
	 */
	fs_init(root);
}
