/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <unistd.h>
#include <oskit/dev/dev.h>
#include "fd.h"

int
write(int fd, const void *buf, size_t size)
{
	oskit_u32_t	retval;
	oskit_error_t	rc;
#ifdef  THREAD_SAFE
	int		enabled;

	/*
	 * Sigh. Don't have a good solution for protecting against
	 * printf out of interrupt handlers.
	 */
	if (fd == STDOUT_FILENO) {
		if ((enabled = osenv_intr_enabled()))
			osenv_intr_disable();
	}
#endif
	FD_CHECK_STREAM(fd);
	FD_ACCESS_LOCK(fd, FD_WRITE);

	rc = oskit_stream_write(fd_array[fd].stream, buf, size, &retval);
	
	FD_ACCESS_UNLOCK(fd, FD_WRITE);

#ifdef  THREAD_SAFE
	if (fd == STDOUT_FILENO) {
		if (enabled)
			osenv_intr_enable();
	}
#endif
	if (rc) {
		errno = rc;
		return -1;
	}
	return retval;
}

