/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <oskit/fs/file.h>
#include <oskit/fs/dir.h>
#include "fs.h"

oskit_error_t
fs_unmount(const char *path)
{
	oskit_file_t *f;
	oskit_iunknown_t *iu;
	struct fs_mountpoint **mpp, *mp;
	oskit_error_t rc;

	/* Lookup the mounted node */
	rc = fs_lookup(path, &f);
	if (rc)
		return rc;
	oskit_file_query(f, &oskit_iunknown_iid, (void**)&iu);
	oskit_file_release(f);

	/* Find its mountpoint node */
	for (mpp = &fs_mountpoints; ; mpp = &mp->next) {
		mp = *mpp;
		if (mp == NULL) {
			oskit_iunknown_release(iu);
			return OSKIT_EINVAL;
		}
		if (iu == mp->subtree_iu) {
			oskit_iunknown_release(iu);
			break;
		}
	}

	/* Remove and free the node */
	oskit_file_release(mp->subtree);
	oskit_iunknown_release(mp->subtree_iu);
	oskit_dir_release(mp->mountover);
	oskit_iunknown_release(mp->mountover_iu);
	*mpp = mp->next;
	free(mp);

	return 0;
}

