/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include "fs.h"

/*
 * look up the dir a file is in, return pointer to last component
 * in filename
 */
oskit_error_t
fs_lookup_dir(const char **name, oskit_dir_t **dirret)
{
	/*
	 * basically, we strip off the last component and look up what's left
	 */
	oskit_error_t	rc;
	oskit_file_t	*f = 0;
	char		*n; 
	char		*comp;

	n = strrchr(*name, '/');
	if (!n) {
		oskit_dir_addref(*dirret = fs_cwd);
		return 0;
	}
	n++;

	comp = alloca(n - *name + 1);
	strncpy(comp, *name, n - *name);
	comp[n - *name] = '\0';
	*name = n;

	rc = fs_lookup(comp, &f);
	if (rc)
		return rc;

	/* 
	 * see if it's a directory
	 */
	rc = oskit_file_query(f, &oskit_dir_iid, (void **)dirret);
	oskit_file_release(f);
	if (rc)
		rc = OSKIT_ENOTDIR;
	return rc;
}

