/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <unistd.h>
#include "fs.h"

/*
 * chroot - change root directory so we can't get back
 */
int
chroot(const char *path)
{
	oskit_file_t *f;
	oskit_error_t rc;

	rc = fs_lookup(path, &f);
	if (!rc) {
		oskit_dir_t *d;
		rc = oskit_file_query(f, &oskit_dir_iid, (void **)&d);
		oskit_file_release(f);
		if (!rc) {
			oskit_dir_t *rooted;
			rc = oskit_dir_reparent(d, NULL, &rooted);
			oskit_dir_release(d);
			if (!rc) {
				if (fs_root) /* XXX locking? */
					oskit_dir_release(fs_root);
				fs_root = rooted;
			}
		}
		else if (rc == OSKIT_E_NOINTERFACE)
			rc = OSKIT_ENOTDIR;
	}
	return rc ? (errno = rc), -1 : 0;
}
