/*
 * @COPYRIGHT@
 *
 * Scout Version 1.0
 *
 * Copyright 1998 Arizona Board of Regents, on behalf of
 *         The University of Arizona
 *         All Rights Reserved
 *
 *
 *                        Copyright (c) 1987 Bellcore
 *                            All Rights Reserved
 *       Permission is granted to copy or use this program, EXCEPT that it
 *       may not be sold for profit, the copyright notice must be reproduced
 *       on copies, and credit should be given to Bellcore where it is due.
 *       BELLCORE MAKES NO WARRANTY AND ACCEPTS NO LIABILITY FOR THIS PROGRAM.
 *
 * @COPYRIGHT@
 *
 */
/*
  wimpi.h

  An include file containing the major structures used by wimpi.  Many
  of these structures are modified versions of structures previously
  found in mgr_i.h
  */

#ifndef WIMPI_H
#define WIMPI_H

typedef struct wimpiSession 	*wimpiSession;
typedef struct wimpiToplevelWindow 	*wimpiToplevelWindow;
typedef struct wimpiWindow 	*wimpiWindow;
typedef void (*wfunction)(wimpiSession);
typedef void (**wfunction_array)(wimpiSession);

#define MOUSE_FREE 0
#define MOUSE_IN_MENU 1

#include <bitblit.h>
#include <defs.h>
#include <font.h>
#include <font_subs.h>
#include <mouse.h>
#include <winmap.h>

#include <oskit/wimpi_event.h>
#include <oskit/wimpi_interface.h>


/*
  WIMPi input routine stuff.

  Defines two masks to tell the input routine what input it
  wants.
  Defines wimpiInputEvent structure when is passed by pointer
  to the wimpiInputRoutine.  The wimpiInputRoutine should
  return the mask of the event it is returning.
  */

#define IMASK_MOUSE 1
#define IMASK_KEY   2

typedef enum {
  KEY_INPUT,MOUSE_INPUT
} wimpiInputEventType;

typedef struct {
  unsigned char c;
} wimpiInputKbdEvent;

typedef struct {
  char but_state;
  int dx,dy;
} wimpiInputMouseEvent;

struct wimpiInputEvent {
  wimpiInputEventType type;
  union {
    wimpiInputKbdEvent kbdEvent;
    wimpiInputMouseEvent mouseEvent;
  } event;
};

typedef struct wimpiInputEvent wimpiInputEvent;
  
typedef int (*wimpiInputRoutine)(int mask,wimpiInputEvent *event);


/*
  wimpiSession

  Taken from MGRRouter.  Exists once per session.
  */
struct wimpiSession {
  BITMAP *screen;        /* display screen */
  
  u_long      now;            /* time in usec */
  u_long      vsync_period;   /* vertical sync period in usec */
  wimpiToplevelWindow    display_list;   /* power of 2 to make modulo cheap */
    
  /* Global variables in original MGR source */
  
  /* Mouse stuff */
  BITMAP *m_rop;	        /* current mouse bit map */
  BITMAP *mouse_save;		/* where to keep what cursor's on */
  int mouse_on;
  int mouse, mousex, mousey;	/* mouse fd, x-coord, y-coord */
  int button_state;	        /* state of the mouse buttons */
/*  Semaphore ev_sem; */
  struct ms_event ms_ev;
  int mouse_state;
  
  /* Windows */
  int next_window;		/* next available window count (???) */
  int next_winId;             /* next window ID */
  WINDOW *active;		/* window connected to keyboard */
  WINDOW *last_active;	/* previous window connected to keyboard */
  WINDOW *root_win;		/* Top window of window hierarchy */
  
  /* Menus */
  char **full_menu;
  char **main_menu;
  char **active_menu;
  char **quit_menu;
  wfunction_array full_functions;
  wfunction_array main_functions;
  wfunction_array active_functions;
  
  unsigned char color_map[COLORMAP_SIZE];
  
  /* Fonts and bitmaps */ 
  struct font *font; 
/*  char *fontlist[MAXFONT];   */
  BITMAP *def_pattern;
  BITMAP *mouse_arrow;
  BITMAP *mouse_box;
  BITMAP *mouse_bull;
  BITMAP *mouse_cross;
  BITMAP *mouse_cup;
  BITMAP *mouse_cut;

  wimpiEventHandler handle_event;
  wimpiInputRoutine input_routine;
};

/*
  wimpiToplevelWindow

  Taken from MGRStage exists one per window/multi-window.
  */
struct wimpiToplevelWindow {
    /* stage private state: */
/*    struct WinMgrIface mgr;
    struct AioIface bot;*/
  wimpiToplevelWindow next_stage;

  /*
    A wimpiWindow referring to the root.
    */
  wimpiWindow root;
  
  /*
    A pointer to the session, so that we don't need a session paramter
    on everything.
    */
  wimpiSession session;
  
  /* Most paths have only one window, pointed to by 'win'.  The map is 
   * only used if multiple windows are created for the path.
   */
  int num_windows;
  winmap* window_map;
  WINDOW *win;
  
  /* Status of any modifier keys */
  unsigned int mod_key_state;
  
  /* timed image */

#if 0
  struct ringbuf { 
    Thread                  blocked_thread; /* thread waiting for image */
    unsigned                rd;             /* reader index */
    unsigned                wr;             /* writer index */
    unsigned                size;           /* size of array */
    WinMgrTimedImage *      img;    /* array of pointers to timed images */
    struct PathQueue        q;
  } rb;
#endif

  void *data;
};

/*
  wimpiWindow

  A structure to replace the wimpiToplevelWindow w, Window winId pairs that
  are passed to several functions.
  */
struct wimpiWindow {
  wimpiToplevelWindow w;
  Window winId;
};

extern int MGRDebug;

wimpiSession wimpi_initialize(void);
void wimpi_main_loop(wimpiSession session);
wimpiToplevelWindow wimpi_create_toplevel(wimpiSession session, bool multi,
			      int width, int height,
			      int x, int y,
			      char* title,
			      bool mapped,
			      void* data);
void wimpi_destroy_toplevel(wimpiToplevelWindow w);
void wimpi_kbd_input(wimpiSession session, unsigned char c);
long wimpi_mouse_input(wimpiSession s,char but_state,int dx,int dy);
wimpiEventHandler wimpi_set_event_handler(wimpiSession session,
					  wimpiEventHandler proc);
wimpiInputRoutine wimpi_set_input_routine(wimpiSession session,
					  wimpiInputRoutine proc);

#endif

