/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * this implements a simple boot module file system - just call
 * oskit_bmod_init() and obtain a oskit_dir_t at your convenience
 */
#include <oskit/fs/dir.h>

#ifndef _BMODFS_H_
#define _BMODFS_H_

/* initialize bmods and return handle to root dir */
oskit_dir_t	*oskit_bmod_init();

/* override these functions for proper locking */
void oskit_bmod_lock();
void oskit_bmod_unlock();

/*
 * This function replaces a bmod file's contents with the given data pointer.
 * `file' must be a file in a bmod filesystem, and not a directory.
 * `size' gives the new size of the file, `allocsize' the total amount writable
 * from `data'.  If `inhibit_resize' is TRUE, normal attempts to change
 * the size of the file hereafter will fail with OSKIT_EPERM; only another
 * call to this function can change it.  If `can_sfree' is TRUE,
 * `sfree(data, allocsize);' is called if the file grows beyond `allocsize';
 * otherwise, the original data pointer is just leaked.
 */
oskit_error_t oskit_bmod_file_set_contents(oskit_file_t *file,
					   void *data, oskit_off_t size,
					   oskit_off_t allocsize,
					   oskit_bool_t can_sfree,
					   oskit_bool_t inhibit_resize);


#endif /* _BMODFS_H_ */

