/*
 * Copyright (c) 1997,1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#ifndef _OSKIT_AVC_AVCOMCALLBACK_H
#define _OSKIT_AVC_AVCOMCALLBACK_H 1

#include <oskit/com.h>
#include <flask/security.h>

/*
 * COM callback interface from an access vector cache to an object manager.
 * IID 4aa7df8a-7c74-11cf-b500-08000953adc2
 *
 * Notify an object manager of changes in the access vector cache.
 */
struct oskit_avcomcallback {
        struct oskit_avcomcallback_ops *ops;
};
typedef struct oskit_avcomcallback oskit_avcomcallback_t;

#define OSKIT_AVCOMCALLBACK_RESET      1
#define OSKIT_AVCOMCALLBACK_REVOKE     2
#define OSKIT_AVCOMCALLBACK_TRY_REMOVE 4

struct oskit_avcomcallback_ops {

	/*** COM-specified IUnknown interface operations ***/
	OSKIT_COMDECL	(*query)(oskit_avcomcallback_t *s,
				 const struct oskit_guid *iid,
				 void **out_ihandle);
	OSKIT_COMDECL_U	(*addref)(oskit_avcomcallback_t *s);
	OSKIT_COMDECL_U	(*release)(oskit_avcomcallback_t *s);

	/*** Operations specific to the oskit_avcomcallback interface ***/

	OSKIT_COMDECL	(*callback)(oskit_avcomcallback_t *a,
				    oskit_u32_t etype,
				    security_class_t sclass,
                                    security_id_t ssid,
                                    security_class_t tclass,
                                    security_id_t tsid,
                                    access_vector_t permissions,
                                    access_vector_t *out_retained);
};


#define oskit_avcomcallback_query(a,iid,out_ihandle) ((a)->ops->query((a),(iid),(out_ihandle)))
#define oskit_avcomcallback_addref(a) ((a)->ops->addref((a)))
#define oskit_avcomcallback_release(a) ((a)->ops->release((a)))
#define oskit_avcomcallback_callback(a,t,sc,ss,tc,ts,p,r) ((a)->ops->callback((a),(t),(sc),(ss),(tc),(ts),(p),(r)))

/* GUID for oskit_avcomcallback interface */
extern const struct oskit_guid oskit_avcomcallback_iid;
#define OSKIT_AVCOMCALLBACK_IID OSKIT_GUID(0x4aa7df8a, 0x7c74, 0x11cf, \
				0xb5, 0x00, 0x08, 0x00, 0x09, 0x53, 0xad, 0xc2)

#endif
