/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Linux port management.
 */

#ifndef OSKIT
#define OSKIT
#endif

#include <oskit/dev/dev.h>

#include <linux/ioport.h>
#include <linux/sched.h>

int
check_region(unsigned port, unsigned size)
{
	struct task_struct *cur = current;
	int avail;

	avail = osenv_io_avail(port, size);

	current = cur;
	return avail ? 0 : -EBUSY;
}

void
request_region(unsigned port, unsigned size, const char *name)
{
	struct task_struct *cur = current;

	osenv_io_alloc(port, size);

	current = cur;
}

void
release_region(unsigned port, unsigned size)
{
	struct task_struct *cur = current;

	osenv_io_free(port, size);

	current = cur;
}
