/*
 * Copyright (c) 1997, 1998 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Global symbol definitions to be included in all Linux dev code.
 * These defines add FDEV_LINUX_ prefixes to global Linux symbols
 * to ensure namespace cleanliness and prevent linking conflicts.
 * The Linux drivers themselves and the Linux glue code
 * should still continue to use the unprefixed names.
 */
/*
 * This was generated via:
 *

i486-linux-nm liboskit_linux_dev.a | grep ' [TDRC] ' | egrep -vi ' (oskit_|fdev_)' | awk '{ printf "#define "$3" FDEV_LINUX_"$3"\n" }' | sort > ! ~/oskit/linux/dev/global.h

 *
 * Note that if the .a file is a.out then you will need to remove leading
 * underscores.
 */
#ifndef _LINUX_DEV_GLOBAL_H_
#define _LINUX_DEV_GLOBAL_H_

#define AM53C974_abort FDEV_LINUX_AM53C974_abort
#define AM53C974_command FDEV_LINUX_AM53C974_command
#define AM53C974_detect FDEV_LINUX_AM53C974_detect
#define AM53C974_info FDEV_LINUX_AM53C974_info
#define AM53C974_queue_command FDEV_LINUX_AM53C974_queue_command
#define AM53C974_release FDEV_LINUX_AM53C974_release
#define AM53C974_reset FDEV_LINUX_AM53C974_reset
#define AM53C974_setup FDEV_LINUX_AM53C974_setup
#define A_NCR53c7xx_msg_abort_used FDEV_LINUX_A_NCR53c7xx_msg_abort_used
#define A_NCR53c7xx_msg_reject_used FDEV_LINUX_A_NCR53c7xx_msg_reject_used
#define A_NCR53c7xx_sink_used FDEV_LINUX_A_NCR53c7xx_sink_used
#define A_NCR53c7xx_zero_used FDEV_LINUX_A_NCR53c7xx_zero_used
#define A_NOP_insn_used FDEV_LINUX_A_NOP_insn_used
#define A_addr_reconnect_dsa_head_used FDEV_LINUX_A_addr_reconnect_dsa_head_used
#define A_addr_scratch_used FDEV_LINUX_A_addr_scratch_used
#define A_addr_temp_used FDEV_LINUX_A_addr_temp_used
#define A_dmode_memory_to_memory_used FDEV_LINUX_A_dmode_memory_to_memory_used
#define A_dmode_memory_to_ncr_used FDEV_LINUX_A_dmode_memory_to_ncr_used
#define A_dmode_ncr_to_memory_used FDEV_LINUX_A_dmode_ncr_to_memory_used
#define A_dsa_check_reselect_used FDEV_LINUX_A_dsa_check_reselect_used
#define A_dsa_cmdout_used FDEV_LINUX_A_dsa_cmdout_used
#define A_dsa_cmnd_used FDEV_LINUX_A_dsa_cmnd_used
#define A_dsa_datain_used FDEV_LINUX_A_dsa_datain_used
#define A_dsa_dataout_used FDEV_LINUX_A_dsa_dataout_used
#define A_dsa_end_used FDEV_LINUX_A_dsa_end_used
#define A_dsa_fields_start_used FDEV_LINUX_A_dsa_fields_start_used
#define A_dsa_msgin_used FDEV_LINUX_A_dsa_msgin_used
#define A_dsa_msgout_other_used FDEV_LINUX_A_dsa_msgout_other_used
#define A_dsa_msgout_used FDEV_LINUX_A_dsa_msgout_used
#define A_dsa_next_used FDEV_LINUX_A_dsa_next_used
#define A_dsa_restore_pointers_used FDEV_LINUX_A_dsa_restore_pointers_used
#define A_dsa_save_data_pointer_used FDEV_LINUX_A_dsa_save_data_pointer_used
#define A_dsa_select_used FDEV_LINUX_A_dsa_select_used
#define A_dsa_status_used FDEV_LINUX_A_dsa_status_used
#define A_dsa_temp_addr_array_value_used FDEV_LINUX_A_dsa_temp_addr_array_value_used
#define A_dsa_temp_addr_dsa_value_used FDEV_LINUX_A_dsa_temp_addr_dsa_value_used
#define A_dsa_temp_addr_new_value_used FDEV_LINUX_A_dsa_temp_addr_new_value_used
#define A_dsa_temp_addr_next_used FDEV_LINUX_A_dsa_temp_addr_next_used
#define A_dsa_temp_addr_residual_used FDEV_LINUX_A_dsa_temp_addr_residual_used
#define A_dsa_temp_addr_saved_pointer_used FDEV_LINUX_A_dsa_temp_addr_saved_pointer_used
#define A_dsa_temp_addr_saved_residual_used FDEV_LINUX_A_dsa_temp_addr_saved_residual_used
#define A_dsa_temp_lun_used FDEV_LINUX_A_dsa_temp_lun_used
#define A_dsa_temp_next_used FDEV_LINUX_A_dsa_temp_next_used
#define A_dsa_temp_sync_used FDEV_LINUX_A_dsa_temp_sync_used
#define A_dsa_temp_target_used FDEV_LINUX_A_dsa_temp_target_used
#define A_int_debug_break_used FDEV_LINUX_A_int_debug_break_used
#define A_int_debug_panic_used FDEV_LINUX_A_int_debug_panic_used
#define A_int_err_check_condition_used FDEV_LINUX_A_int_err_check_condition_used
#define A_int_err_no_phase_used FDEV_LINUX_A_int_err_no_phase_used
#define A_int_err_selected_used FDEV_LINUX_A_int_err_selected_used
#define A_int_err_unexpected_phase_used FDEV_LINUX_A_int_err_unexpected_phase_used
#define A_int_err_unexpected_reselect_used FDEV_LINUX_A_int_err_unexpected_reselect_used
#define A_int_msg_1_used FDEV_LINUX_A_int_msg_1_used
#define A_int_msg_sdtr_used FDEV_LINUX_A_int_msg_sdtr_used
#define A_int_msg_wdtr_used FDEV_LINUX_A_int_msg_wdtr_used
#define A_int_norm_aborted_used FDEV_LINUX_A_int_norm_aborted_used
#define A_int_norm_command_complete_used FDEV_LINUX_A_int_norm_command_complete_used
#define A_int_norm_disconnected_used FDEV_LINUX_A_int_norm_disconnected_used
#define A_int_norm_reselect_complete_used FDEV_LINUX_A_int_norm_reselect_complete_used
#define A_int_norm_reset_used FDEV_LINUX_A_int_norm_reset_used
#define A_int_norm_select_complete_used FDEV_LINUX_A_int_norm_select_complete_used
#define A_int_test_1_used FDEV_LINUX_A_int_test_1_used
#define A_int_test_2_used FDEV_LINUX_A_int_test_2_used
#define A_int_test_3_used FDEV_LINUX_A_int_test_3_used
#define A_msg_buf_used FDEV_LINUX_A_msg_buf_used
#define A_reconnect_dsa_head_used FDEV_LINUX_A_reconnect_dsa_head_used
#define A_reselected_identify_used FDEV_LINUX_A_reselected_identify_used
#define A_reselected_tag_used FDEV_LINUX_A_reselected_tag_used
#define A_schedule_used FDEV_LINUX_A_schedule_used
#define A_test_dest_used FDEV_LINUX_A_test_dest_used
#define A_test_src_used FDEV_LINUX_A_test_src_used
#define AscAbortSRB FDEV_LINUX_AscAbortSRB
#define AscAckInterrupt FDEV_LINUX_AscAckInterrupt
#define AscAllocFreeQueue FDEV_LINUX_AscAllocFreeQueue
#define AscAllocMultipleFreeQueue FDEV_LINUX_AscAllocMultipleFreeQueue
#define AscCalSDTRData FDEV_LINUX_AscCalSDTRData
#define AscCleanUpBusyQueue FDEV_LINUX_AscCleanUpBusyQueue
#define AscCleanUpDiscQueue FDEV_LINUX_AscCleanUpDiscQueue
#define AscCompareString FDEV_LINUX_AscCompareString
#define AscDisableInterrupt FDEV_LINUX_AscDisableInterrupt
#define AscEnableInterrupt FDEV_LINUX_AscEnableInterrupt
#define AscEnableIsaDma FDEV_LINUX_AscEnableIsaDma
#define AscExeScsiQueue FDEV_LINUX_AscExeScsiQueue
#define AscFindSignature FDEV_LINUX_AscFindSignature
#define AscGetChipBiosAddress FDEV_LINUX_AscGetChipBiosAddress
#define AscGetChipBusType FDEV_LINUX_AscGetChipBusType
#define AscGetChipIRQ FDEV_LINUX_AscGetChipIRQ
#define AscGetChipScsiCtrl FDEV_LINUX_AscGetChipScsiCtrl
#define AscGetChipVersion FDEV_LINUX_AscGetChipVersion
#define AscGetEEPConfig FDEV_LINUX_AscGetEEPConfig
#define AscGetEisaChipCfg FDEV_LINUX_AscGetEisaChipCfg
#define AscGetEisaProductID FDEV_LINUX_AscGetEisaProductID
#define AscGetIsaDmaChannel FDEV_LINUX_AscGetIsaDmaChannel
#define AscGetIsaDmaSpeed FDEV_LINUX_AscGetIsaDmaSpeed
#define AscGetMaxDmaCount FDEV_LINUX_AscGetMaxDmaCount
#define AscGetNumOfFreeQueue FDEV_LINUX_AscGetNumOfFreeQueue
#define AscGetOnePhyAddr FDEV_LINUX_AscGetOnePhyAddr
#define AscGetSynPeriodIndex FDEV_LINUX_AscGetSynPeriodIndex
#define AscHostReqRiscHalt FDEV_LINUX_AscHostReqRiscHalt
#define AscISR FDEV_LINUX_AscISR
#define AscInitAsc1000Driver FDEV_LINUX_AscInitAsc1000Driver
#define AscInitAscDvcVar FDEV_LINUX_AscInitAscDvcVar
#define AscInitFromAscDvcVar FDEV_LINUX_AscInitFromAscDvcVar
#define AscInitFromEEP FDEV_LINUX_AscInitFromEEP
#define AscInitGetConfig FDEV_LINUX_AscInitGetConfig
#define AscInitLram FDEV_LINUX_AscInitLram
#define AscInitMicroCodeVar FDEV_LINUX_AscInitMicroCodeVar
#define AscInitPollBegin FDEV_LINUX_AscInitPollBegin
#define AscInitPollEnd FDEV_LINUX_AscInitPollEnd
#define AscInitPollIsrCallBack FDEV_LINUX_AscInitPollIsrCallBack
#define AscInitPollTarget FDEV_LINUX_AscInitPollTarget
#define AscInitQLinkVar FDEV_LINUX_AscInitQLinkVar
#define AscInitSetConfig FDEV_LINUX_AscInitSetConfig
#define AscInitWithoutEEP FDEV_LINUX_AscInitWithoutEEP
#define AscIsChipHalted FDEV_LINUX_AscIsChipHalted
#define AscIsrChipHalted FDEV_LINUX_AscIsrChipHalted
#define AscIsrQDone FDEV_LINUX_AscIsrQDone
#define AscLoadMicroCode FDEV_LINUX_AscLoadMicroCode
#define AscMemDWordCopyToLram FDEV_LINUX_AscMemDWordCopyToLram
#define AscMemSumLramWord FDEV_LINUX_AscMemSumLramWord
#define AscMemWordCopyFromLram FDEV_LINUX_AscMemWordCopyFromLram
#define AscMemWordCopyToLram FDEV_LINUX_AscMemWordCopyToLram
#define AscMemWordSetLram FDEV_LINUX_AscMemWordSetLram
#define AscMsgOutSDTR FDEV_LINUX_AscMsgOutSDTR
#define AscPollQDone FDEV_LINUX_AscPollQDone
#define AscPutReadyQueue FDEV_LINUX_AscPutReadyQueue
#define AscPutReadySgListQueue FDEV_LINUX_AscPutReadySgListQueue
#define AscReInitLram FDEV_LINUX_AscReInitLram
#define AscReadEEPWord FDEV_LINUX_AscReadEEPWord
#define AscReadLramByte FDEV_LINUX_AscReadLramByte
#define AscReadLramDWord FDEV_LINUX_AscReadLramDWord
#define AscReadLramWord FDEV_LINUX_AscReadLramWord
#define AscResetChipAndScsiBus FDEV_LINUX_AscResetChipAndScsiBus
#define AscResetDevice FDEV_LINUX_AscResetDevice
#define AscResetSB FDEV_LINUX_AscResetSB
#define AscRiscHaltedAbortSRB FDEV_LINUX_AscRiscHaltedAbortSRB
#define AscRiscHaltedAbortTIX FDEV_LINUX_AscRiscHaltedAbortTIX
#define AscScsiInquiry FDEV_LINUX_AscScsiInquiry
#define AscScsiReadCapacity FDEV_LINUX_AscScsiReadCapacity
#define AscScsiSetupCmdQ FDEV_LINUX_AscScsiSetupCmdQ
#define AscScsiStartStopUnit FDEV_LINUX_AscScsiStartStopUnit
#define AscScsiTestUnitReady FDEV_LINUX_AscScsiTestUnitReady
#define AscSearchIOPortAddr FDEV_LINUX_AscSearchIOPortAddr
#define AscSearchIOPortAddr11 FDEV_LINUX_AscSearchIOPortAddr11
#define AscSearchIOPortAddrEISA FDEV_LINUX_AscSearchIOPortAddrEISA
#define AscSendScsiQueue FDEV_LINUX_AscSendScsiQueue
#define AscSetBank FDEV_LINUX_AscSetBank
#define AscSetChipIH FDEV_LINUX_AscSetChipIH
#define AscSetChipIRQ FDEV_LINUX_AscSetChipIRQ
#define AscSetChipSDTR FDEV_LINUX_AscSetChipSDTR
#define AscSetChipScsiID FDEV_LINUX_AscSetChipScsiID
#define AscSetChipSynRegAtID FDEV_LINUX_AscSetChipSynRegAtID
#define AscSetEEPConfig FDEV_LINUX_AscSetEEPConfig
#define AscSetEEPConfigOnce FDEV_LINUX_AscSetEEPConfigOnce
#define AscSetISAPNPWaitForKey FDEV_LINUX_AscSetISAPNPWaitForKey
#define AscSetIsaDmaChannel FDEV_LINUX_AscSetIsaDmaChannel
#define AscSetIsaDmaSpeed FDEV_LINUX_AscSetIsaDmaSpeed
#define AscSetLibErrorCode FDEV_LINUX_AscSetLibErrorCode
#define AscSetRunChipSynRegAtID FDEV_LINUX_AscSetRunChipSynRegAtID
#define AscSgListToQueue FDEV_LINUX_AscSgListToQueue
#define AscStartChip FDEV_LINUX_AscStartChip
#define AscStartQueueExe FDEV_LINUX_AscStartQueueExe
#define AscStopChip FDEV_LINUX_AscStopChip
#define AscStopQueueExe FDEV_LINUX_AscStopQueueExe
#define AscTestExternalLram FDEV_LINUX_AscTestExternalLram
#define AscToggleIRQAct FDEV_LINUX_AscToggleIRQAct
#define AscWaitEEPRead FDEV_LINUX_AscWaitEEPRead
#define AscWaitEEPWrite FDEV_LINUX_AscWaitEEPWrite
#define AscWaitISRDone FDEV_LINUX_AscWaitISRDone
#define AscWaitTixISRDone FDEV_LINUX_AscWaitTixISRDone
#define AscWriteEEPCmdReg FDEV_LINUX_AscWriteEEPCmdReg
#define AscWriteEEPDataReg FDEV_LINUX_AscWriteEEPDataReg
#define AscWriteEEPWord FDEV_LINUX_AscWriteEEPWord
#define AscWriteLramByte FDEV_LINUX_AscWriteLramByte
#define AscWriteLramDWord FDEV_LINUX_AscWriteLramDWord
#define AscWriteLramWord FDEV_LINUX_AscWriteLramWord
#define BusLogic_AbortCommand FDEV_LINUX_BusLogic_AbortCommand
#define BusLogic_BIOSDiskParameters FDEV_LINUX_BusLogic_BIOSDiskParameters
#define BusLogic_DetectHostAdapter FDEV_LINUX_BusLogic_DetectHostAdapter
#define BusLogic_DriverInfo FDEV_LINUX_BusLogic_DriverInfo
#define BusLogic_QueueCommand FDEV_LINUX_BusLogic_QueueCommand
#define BusLogic_ReleaseHostAdapter FDEV_LINUX_BusLogic_ReleaseHostAdapter
#define BusLogic_ResetCommand FDEV_LINUX_BusLogic_ResetCommand
#define BusLogic_Setup FDEV_LINUX_BusLogic_Setup
#define DvcDelayNanoSecond FDEV_LINUX_DvcDelayNanoSecond
#define DvcDisplayString FDEV_LINUX_DvcDisplayString
#define DvcEnterCritical FDEV_LINUX_DvcEnterCritical
#define DvcGetPhyAddr FDEV_LINUX_DvcGetPhyAddr
#define DvcGetQinfo FDEV_LINUX_DvcGetQinfo
#define DvcGetSGList FDEV_LINUX_DvcGetSGList
#define DvcInPortWords FDEV_LINUX_DvcInPortWords
#define DvcLeaveCritical FDEV_LINUX_DvcLeaveCritical
#define DvcOutPortDWords FDEV_LINUX_DvcOutPortDWords
#define DvcOutPortWords FDEV_LINUX_DvcOutPortWords
#define DvcPutScsiQ FDEV_LINUX_DvcPutScsiQ
#define DvcReadPCIConfigByte FDEV_LINUX_DvcReadPCIConfigByte
#define DvcSleepMilliSecond FDEV_LINUX_DvcSleepMilliSecond
#define DvcWritePCIConfigByte FDEV_LINUX_DvcWritePCIConfigByte
#define EISA_bus FDEV_LINUX_EISA_bus
#define EXTERNAL_PATCHES FDEV_LINUX_EXTERNAL_PATCHES
#define EXTERNAL_PATCHES_LEN FDEV_LINUX_EXTERNAL_PATCHES_LEN
#define INSTRUCTIONS FDEV_LINUX_INSTRUCTIONS
#define IncStat FDEV_LINUX_IncStat
#define InitTestUnitReady FDEV_LINUX_InitTestUnitReady
#define LABELPATCHES FDEV_LINUX_LABELPATCHES
#define NCR53c406a_abort FDEV_LINUX_NCR53c406a_abort
#define NCR53c406a_biosparm FDEV_LINUX_NCR53c406a_biosparm
#define NCR53c406a_command FDEV_LINUX_NCR53c406a_command
#define NCR53c406a_detect FDEV_LINUX_NCR53c406a_detect
#define NCR53c406a_info FDEV_LINUX_NCR53c406a_info
#define NCR53c406a_queue FDEV_LINUX_NCR53c406a_queue
#define NCR53c406a_reset FDEV_LINUX_NCR53c406a_reset
#define NCR53c406a_setup FDEV_LINUX_NCR53c406a_setup
#define NCR53c7xx_abort FDEV_LINUX_NCR53c7xx_abort
#define NCR53c7xx_detect FDEV_LINUX_NCR53c7xx_detect
#define NCR53c7xx_queue_command FDEV_LINUX_NCR53c7xx_queue_command
#define NCR53c7xx_reset FDEV_LINUX_NCR53c7xx_reset
#define NS8390_init FDEV_LINUX_NS8390_init
#define PATCHES FDEV_LINUX_PATCHES
#define PollQueueDone FDEV_LINUX_PollQueueDone
#define PollScsiInquiry FDEV_LINUX_PollScsiInquiry
#define PollScsiReadCapacity FDEV_LINUX_PollScsiReadCapacity
#define PollScsiStartUnit FDEV_LINUX_PollScsiStartUnit
#define PollScsiTestUnitReady FDEV_LINUX_PollScsiTestUnitReady
#define SCRIPT FDEV_LINUX_SCRIPT
#define SCint FDEV_LINUX_SCint
#define SK_init FDEV_LINUX_SK_init
#define SK_print_dev FDEV_LINUX_SK_print_dev
#define SK_print_pos FDEV_LINUX_SK_print_pos
#define SK_print_ram FDEV_LINUX_SK_print_ram
#define SK_read_reg FDEV_LINUX_SK_read_reg
#define SK_reset_board FDEV_LINUX_SK_reset_board
#define SK_rom_addr FDEV_LINUX_SK_rom_addr
#define SK_rread_reg FDEV_LINUX_SK_rread_reg
#define SK_set_RAP FDEV_LINUX_SK_set_RAP
#define SK_write_reg FDEV_LINUX_SK_write_reg
#define _AscCopyLramScsiDoneQ FDEV_LINUX__AscCopyLramScsiDoneQ
#define _AscWaitQDone FDEV_LINUX__AscWaitQDone
#define __brelse FDEV_LINUX___brelse
#define _asc_def_iop_base FDEV_LINUX__asc_def_iop_base
#define _asc_wait_slow_device_ FDEV_LINUX__asc_wait_slow_device_
#define _isa_pnp_inited FDEV_LINUX__isa_pnp_inited
#define _mcode_buf FDEV_LINUX__mcode_buf
#define _mcode_chksum FDEV_LINUX__mcode_chksum
#define _mcode_size FDEV_LINUX__mcode_size
#define _syn_offset_one_disable_cmd FDEV_LINUX__syn_offset_one_disable_cmd
#define ac3200_probe FDEV_LINUX_ac3200_probe
#define add_blkdev_randomness FDEV_LINUX_add_blkdev_randomness
#define add_timer FDEV_LINUX_add_timer
#define addr_list FDEV_LINUX_addr_list
#define advansys_abort FDEV_LINUX_advansys_abort
#define advansys_biosparam FDEV_LINUX_advansys_biosparam
#define advansys_command FDEV_LINUX_advansys_command
#define advansys_command_done FDEV_LINUX_advansys_command_done
#define advansys_detect FDEV_LINUX_advansys_detect
#define advansys_info FDEV_LINUX_advansys_info
#define advansys_interrupt FDEV_LINUX_advansys_interrupt
#define advansys_proc_info FDEV_LINUX_advansys_proc_info
#define advansys_queuecommand FDEV_LINUX_advansys_queuecommand
#define advansys_release FDEV_LINUX_advansys_release
#define advansys_reset FDEV_LINUX_advansys_reset
#define advansys_select_queue_depths FDEV_LINUX_advansys_select_queue_depths
#define advansys_setup FDEV_LINUX_advansys_setup
#define aha152x_abort FDEV_LINUX_aha152x_abort
#define aha152x_biosparam FDEV_LINUX_aha152x_biosparam
#define aha152x_checksetup FDEV_LINUX_aha152x_checksetup
#define aha152x_command FDEV_LINUX_aha152x_command
#define aha152x_detect FDEV_LINUX_aha152x_detect
#define aha152x_done FDEV_LINUX_aha152x_done
#define aha152x_intr FDEV_LINUX_aha152x_intr
#define aha152x_proc_info FDEV_LINUX_aha152x_proc_info
#define aha152x_queue FDEV_LINUX_aha152x_queue
#define aha152x_reset FDEV_LINUX_aha152x_reset
#define aha152x_set_info FDEV_LINUX_aha152x_set_info
#define aha152x_setup FDEV_LINUX_aha152x_setup
#define aha152x_swintr FDEV_LINUX_aha152x_swintr
#define aha1542_abort FDEV_LINUX_aha1542_abort
#define aha1542_biosparam FDEV_LINUX_aha1542_biosparam
#define aha1542_command FDEV_LINUX_aha1542_command
#define aha1542_detect FDEV_LINUX_aha1542_detect
#define aha1542_queuecommand FDEV_LINUX_aha1542_queuecommand
#define aha1542_reset FDEV_LINUX_aha1542_reset
#define aha1542_setup FDEV_LINUX_aha1542_setup
#define aha1740_abort FDEV_LINUX_aha1740_abort
#define aha1740_biosparam FDEV_LINUX_aha1740_biosparam
#define aha1740_command FDEV_LINUX_aha1740_command
#define aha1740_detect FDEV_LINUX_aha1740_detect
#define aha1740_getconfig FDEV_LINUX_aha1740_getconfig
#define aha1740_intr_handle FDEV_LINUX_aha1740_intr_handle
#define aha1740_makecode FDEV_LINUX_aha1740_makecode
#define aha1740_queuecommand FDEV_LINUX_aha1740_queuecommand
#define aha1740_reset FDEV_LINUX_aha1740_reset
#define aha1740_test_port FDEV_LINUX_aha1740_test_port
#define aic7xxx_abort FDEV_LINUX_aic7xxx_abort
#define aic7xxx_biosparam FDEV_LINUX_aic7xxx_biosparam
#define aic7xxx_detect FDEV_LINUX_aic7xxx_detect
#define aic7xxx_info FDEV_LINUX_aic7xxx_info
#define aic7xxx_proc_info FDEV_LINUX_aic7xxx_proc_info
#define aic7xxx_queue FDEV_LINUX_aic7xxx_queue
#define aic7xxx_reset FDEV_LINUX_aic7xxx_reset
#define aic7xxx_set_info FDEV_LINUX_aic7xxx_set_info
#define aic7xxx_setup FDEV_LINUX_aic7xxx_setup
#define alloc_skb FDEV_LINUX_alloc_skb
#define allocate_device FDEV_LINUX_allocate_device
#define apricot_probe FDEV_LINUX_apricot_probe
#define asc_board_count FDEV_LINUX_asc_board_count
#define asc_bus FDEV_LINUX_asc_bus
#define asc_bus_name FDEV_LINUX_asc_bus_name
#define asc_dbglvl FDEV_LINUX_asc_dbglvl
#define asc_dequeue FDEV_LINUX_asc_dequeue
#define asc_dequeue_list FDEV_LINUX_asc_dequeue_list
#define asc_enqueue FDEV_LINUX_asc_enqueue
#define asc_execute_queue FDEV_LINUX_asc_execute_queue
#define asc_execute_scsi_cmnd FDEV_LINUX_asc_execute_scsi_cmnd
#define asc_get_cfg_byte FDEV_LINUX_asc_get_cfg_byte
#define asc_get_cfg_word FDEV_LINUX_asc_get_cfg_word
#define asc_get_pci_cfg FDEV_LINUX_asc_get_pci_cfg
#define asc_host FDEV_LINUX_asc_host
#define asc_init_dev FDEV_LINUX_asc_init_dev
#define asc_iopflag FDEV_LINUX_asc_iopflag
#define asc_ioport FDEV_LINUX_asc_ioport
#define asc_isqueued FDEV_LINUX_asc_isqueued
#define asc_isr_callback FDEV_LINUX_asc_isr_callback
#define asc_pci_find_dev FDEV_LINUX_asc_pci_find_dev
#define asc_proc_copy FDEV_LINUX_asc_proc_copy
#define asc_prt_board_devices FDEV_LINUX_asc_prt_board_devices
#define asc_prt_board_eeprom FDEV_LINUX_asc_prt_board_eeprom
#define asc_prt_board_info FDEV_LINUX_asc_prt_board_info
#define asc_prt_board_stats FDEV_LINUX_asc_prt_board_stats
#define asc_prt_driver_conf FDEV_LINUX_asc_prt_driver_conf
#define asc_prt_dvc_cfg FDEV_LINUX_asc_prt_dvc_cfg
#define asc_prt_dvc_var FDEV_LINUX_asc_prt_dvc_var
#define asc_prt_hex FDEV_LINUX_asc_prt_hex
#define asc_prt_line FDEV_LINUX_asc_prt_line
#define asc_prt_qdone_info FDEV_LINUX_asc_prt_qdone_info
#define asc_prt_scsi_cmnd FDEV_LINUX_asc_prt_scsi_cmnd
#define asc_prt_scsi_host FDEV_LINUX_asc_prt_scsi_host
#define asc_prt_scsi_q FDEV_LINUX_asc_prt_scsi_q
#define asc_put_cfg_byte FDEV_LINUX_asc_put_cfg_byte
#define asc_rmqueue FDEV_LINUX_asc_rmqueue
#define asc_scan_method FDEV_LINUX_asc_scan_method
#define asc_scsi_done_list FDEV_LINUX_asc_scsi_done_list
#define asc_scsi_q FDEV_LINUX_asc_scsi_q
#define asc_sg_head FDEV_LINUX_asc_sg_head
#define asc_srch_pci_dev FDEV_LINUX_asc_srch_pci_dev
#define at1700_probe FDEV_LINUX_at1700_probe
#define autoirq_report FDEV_LINUX_autoirq_report
#define autoirq_setup FDEV_LINUX_autoirq_setup
#define backlog_max FDEV_LINUX_backlog_max
#define base_tab FDEV_LINUX_base_tab
#define bh_active FDEV_LINUX_bh_active
#define bh_base FDEV_LINUX_bh_base
#define bh_mask FDEV_LINUX_bh_mask
#define bh_mask_count FDEV_LINUX_bh_mask_count
#define bios_tab FDEV_LINUX_bios_tab
#define blk_dev FDEV_LINUX_blk_dev
#define blk_dev_init FDEV_LINUX_blk_dev_init
#define blk_size FDEV_LINUX_blk_size
#define blkdevs FDEV_LINUX_blkdevs
#define blksize_size FDEV_LINUX_blksize_size
#define block_fsync FDEV_LINUX_block_fsync
#define block_read FDEV_LINUX_block_read
#define block_write FDEV_LINUX_block_write
#define boot FDEV_LINUX_boot
#define bread FDEV_LINUX_bread
#define bridge_mapping FDEV_LINUX_bridge_mapping
#define bridge_optimization FDEV_LINUX_bridge_optimization
#define calc_sync_xfer FDEV_LINUX_calc_sync_xfer
#define check_blink_state FDEV_LINUX_check_blink_state
#define check_disk_change FDEV_LINUX_check_disk_change
#define check_region FDEV_LINUX_check_region
#define check_setup_strings FDEV_LINUX_check_setup_strings
#define chr_dev_init FDEV_LINUX_chr_dev_init
#define cmd640_vlb FDEV_LINUX_cmd640_vlb
#define console_map_init FDEV_LINUX_console_map_init
#define de4x5_probe FDEV_LINUX_de4x5_probe
#define default_irqs FDEV_LINUX_default_irqs
#define del_timer FDEV_LINUX_del_timer
#define depca_probe FDEV_LINUX_depca_probe
#define dev_alloc_skb FDEV_LINUX_dev_alloc_skb
#define dev_base FDEV_LINUX_dev_base
#define dev_close FDEV_LINUX_dev_close
#define dev_get_info FDEV_LINUX_dev_get_info
#define dev_info FDEV_LINUX_dev_info
#define dev_kfree_skb FDEV_LINUX_dev_kfree_skb
#define device_setup FDEV_LINUX_device_setup
#define disable_irq FDEV_LINUX_disable_irq
#define disc_allowed_total FDEV_LINUX_disc_allowed_total
#define disc_taken_total FDEV_LINUX_disc_taken_total
#define disk_name FDEV_LINUX_disk_name
#define dispatch_scsi_info_ptr FDEV_LINUX_dispatch_scsi_info_ptr
#define dma_free_sectors FDEV_LINUX_dma_free_sectors
#define do_bottom_half FDEV_LINUX_do_bottom_half
#define do_gettimeofday FDEV_LINUX_do_gettimeofday
#define drive_info FDEV_LINUX_drive_info
#define dtc_abort FDEV_LINUX_dtc_abort
#define dtc_biosparam FDEV_LINUX_dtc_biosparam
#define dtc_detect FDEV_LINUX_dtc_detect
#define dtc_proc_info FDEV_LINUX_dtc_proc_info
#define dtc_queue_command FDEV_LINUX_dtc_queue_command
#define dtc_reset FDEV_LINUX_dtc_reset
#define dtc_setup FDEV_LINUX_dtc_setup
#define e2100_probe FDEV_LINUX_e2100_probe
#define e21_probe1 FDEV_LINUX_e21_probe1
#define eata2x_abort FDEV_LINUX_eata2x_abort
#define eata2x_detect FDEV_LINUX_eata2x_detect
#define eata2x_queuecommand FDEV_LINUX_eata2x_queuecommand
#define eata2x_release FDEV_LINUX_eata2x_release
#define eata2x_reset FDEV_LINUX_eata2x_reset
#define eata2x_setup FDEV_LINUX_eata2x_setup
#define eata_abort FDEV_LINUX_eata_abort
#define eata_detect FDEV_LINUX_eata_detect
#define eata_fake_int_handler FDEV_LINUX_eata_fake_int_handler
#define eata_int_handler FDEV_LINUX_eata_int_handler
#define eata_latency_in FDEV_LINUX_eata_latency_in
#define eata_latency_out FDEV_LINUX_eata_latency_out
#define eata_pio_abort FDEV_LINUX_eata_pio_abort
#define eata_pio_detect FDEV_LINUX_eata_pio_detect
#define eata_pio_int_handler FDEV_LINUX_eata_pio_int_handler
#define eata_pio_proc_info FDEV_LINUX_eata_pio_proc_info
#define eata_pio_queue FDEV_LINUX_eata_pio_queue
#define eata_pio_reset FDEV_LINUX_eata_pio_reset
#define eata_pio_send_command FDEV_LINUX_eata_pio_send_command
#define eata_pio_set_info FDEV_LINUX_eata_pio_set_info
#define eata_proc_info FDEV_LINUX_eata_proc_info
#define eata_queue FDEV_LINUX_eata_queue
#define eata_reset FDEV_LINUX_eata_reset
#define eata_scsi_done FDEV_LINUX_eata_scsi_done
#define eata_send_command FDEV_LINUX_eata_send_command
#define eata_send_immediate FDEV_LINUX_eata_send_immediate
#define eata_set_info FDEV_LINUX_eata_set_info
#define eepro_probe FDEV_LINUX_eepro_probe
#define ei_close FDEV_LINUX_ei_close
#define ei_debug FDEV_LINUX_ei_debug
#define ei_interrupt FDEV_LINUX_ei_interrupt
#define ei_open FDEV_LINUX_ei_open
#define el16_probe FDEV_LINUX_el16_probe
#define el1_probe FDEV_LINUX_el1_probe
#define el2_pio_probe FDEV_LINUX_el2_pio_probe
#define el2_probe FDEV_LINUX_el2_probe
#define el2_probe1 FDEV_LINUX_el2_probe1
#define el3_debug FDEV_LINUX_el3_debug
#define el3_probe FDEV_LINUX_el3_probe
#define elplus_probe FDEV_LINUX_elplus_probe
#define enable_board FDEV_LINUX_enable_board
#define enable_irq FDEV_LINUX_enable_irq
#define eth16i_probe FDEV_LINUX_eth16i_probe
#define ethdev_init FDEV_LINUX_ethdev_init
#define ether_config FDEV_LINUX_ether_config
#define ether_setup FDEV_LINUX_ether_setup
#define ewrk3_probe FDEV_LINUX_ewrk3_probe
#define express_probe FDEV_LINUX_express_probe
#define fdomain_16x0_abort FDEV_LINUX_fdomain_16x0_abort
#define fdomain_16x0_biosparam FDEV_LINUX_fdomain_16x0_biosparam
#define fdomain_16x0_command FDEV_LINUX_fdomain_16x0_command
#define fdomain_16x0_detect FDEV_LINUX_fdomain_16x0_detect
#define fdomain_16x0_info FDEV_LINUX_fdomain_16x0_info
#define fdomain_16x0_intr FDEV_LINUX_fdomain_16x0_intr
#define fdomain_16x0_proc_info FDEV_LINUX_fdomain_16x0_proc_info
#define fdomain_16x0_queue FDEV_LINUX_fdomain_16x0_queue
#define fdomain_16x0_reset FDEV_LINUX_fdomain_16x0_reset
#define fdomain_setup FDEV_LINUX_fdomain_setup
#define find_EISA FDEV_LINUX_find_EISA
#define find_ISA FDEV_LINUX_find_ISA
#define find_PCI FDEV_LINUX_find_PCI
#define find_pio_EISA FDEV_LINUX_find_pio_EISA
#define find_pio_ISA FDEV_LINUX_find_pio_ISA
#define find_pio_PCI FDEV_LINUX_find_pio_PCI
#define fmv18x_probe FDEV_LINUX_fmv18x_probe
#define free_dma FDEV_LINUX_free_dma
#define free_irq FDEV_LINUX_free_irq
#define gendisk_head FDEV_LINUX_gendisk_head
#define get_board_data FDEV_LINUX_get_board_data
#define get_conf_PIO FDEV_LINUX_get_conf_PIO
#define get_pci_list FDEV_LINUX_get_pci_list
#define get_pio_board_data FDEV_LINUX_get_pio_board_data
#define get_pio_conf_PIO FDEV_LINUX_get_pio_conf_PIO
#define getblk FDEV_LINUX_getblk
#define good_dma_drives FDEV_LINUX_good_dma_drives
#define hardsect_size FDEV_LINUX_hardsect_size
#define hardware_send_packet FDEV_LINUX_hardware_send_packet
#define hp100_priority_tx FDEV_LINUX_hp100_priority_tx
#define hp100_probe FDEV_LINUX_hp100_probe
#define hp100_rx_ratio FDEV_LINUX_hp100_rx_ratio
#define hp_plus_probe FDEV_LINUX_hp_plus_probe
#define hp_probe FDEV_LINUX_hp_probe
#define hp_probe1 FDEV_LINUX_hp_probe1
#define hpp_probe1 FDEV_LINUX_hpp_probe1
#define i596_debug FDEV_LINUX_i596_debug
#define ide_cdrom_check_media_change FDEV_LINUX_ide_cdrom_check_media_change
#define ide_cdrom_ioctl FDEV_LINUX_ide_cdrom_ioctl
#define ide_cdrom_open FDEV_LINUX_ide_cdrom_open
#define ide_cdrom_release FDEV_LINUX_ide_cdrom_release
#define ide_cdrom_setup FDEV_LINUX_ide_cdrom_setup
#define ide_do_drive_cmd FDEV_LINUX_ide_do_drive_cmd
#define ide_do_request FDEV_LINUX_ide_do_request
#define ide_do_reset FDEV_LINUX_ide_do_reset
#define ide_do_rw_cdrom FDEV_LINUX_ide_do_rw_cdrom
#define ide_dump_status FDEV_LINUX_ide_dump_status
#define ide_end_drive_cmd FDEV_LINUX_ide_end_drive_cmd
#define ide_end_request FDEV_LINUX_ide_end_request
#define ide_error FDEV_LINUX_ide_error
#define ide_fixstring FDEV_LINUX_ide_fixstring
#define ide_get_best_pio_mode FDEV_LINUX_ide_get_best_pio_mode
#define ide_hwifs FDEV_LINUX_ide_hwifs
#define ide_init FDEV_LINUX_ide_init
#define ide_init_drive_cmd FDEV_LINUX_ide_init_drive_cmd
#define ide_init_triton FDEV_LINUX_ide_init_triton
#define ide_input_data FDEV_LINUX_ide_input_data
#define ide_intr FDEV_LINUX_ide_intr
#define ide_multwrite FDEV_LINUX_ide_multwrite
#define ide_output_data FDEV_LINUX_ide_output_data
#define ide_pio_timings FDEV_LINUX_ide_pio_timings
#define ide_probe_for_cmd640x FDEV_LINUX_ide_probe_for_cmd640x
#define ide_scan_pio_blacklist FDEV_LINUX_ide_scan_pio_blacklist
#define ide_set_handler FDEV_LINUX_ide_set_handler
#define ide_setup FDEV_LINUX_ide_setup
#define ide_system_bus_speed FDEV_LINUX_ide_system_bus_speed
#define ide_wait_stat FDEV_LINUX_ide_wait_stat
#define ide_xlate_1024 FDEV_LINUX_ide_xlate_1024
#define immediate_bh FDEV_LINUX_immediate_bh
#define in2000_abort FDEV_LINUX_in2000_abort
#define in2000_biosparam FDEV_LINUX_in2000_biosparam
#define in2000_detect FDEV_LINUX_in2000_detect
#define in2000_execute FDEV_LINUX_in2000_execute
#define in2000_intr FDEV_LINUX_in2000_intr
#define in2000_proc_info FDEV_LINUX_in2000_proc_info
#define in2000_queuecommand FDEV_LINUX_in2000_queuecommand
#define in2000_reset FDEV_LINUX_in2000_reset
#define in2000_setup FDEV_LINUX_in2000_setup
#define in2000_strcat FDEV_LINUX_in2000_strcat
#define init_82586_mem FDEV_LINUX_init_82586_mem
#define init_board FDEV_LINUX_init_board
#define init_etherdev FDEV_LINUX_init_etherdev
#define init_rz1000 FDEV_LINUX_init_rz1000
#define init_setup FDEV_LINUX_init_setup
#define init_words FDEV_LINUX_init_words
#define int_tab FDEV_LINUX_int_tab
#define internal_cmnd FDEV_LINUX_internal_cmnd
#define interrupts_enabled FDEV_LINUX_interrupts_enabled
#define intr_count FDEV_LINUX_intr_count
#define irq2dev_map FDEV_LINUX_irq2dev_map
#define irq2host FDEV_LINUX_irq2host
#define irq2host FDEV_LINUX_irq2host
#define irqs_busy FDEV_LINUX_irqs_busy
#define is_read_only FDEV_LINUX_is_read_only
#define isp1020_abort FDEV_LINUX_isp1020_abort
#define isp1020_biosparam FDEV_LINUX_isp1020_biosparam
#define isp1020_detect FDEV_LINUX_isp1020_detect
#define isp1020_info FDEV_LINUX_isp1020_info
#define isp1020_queuecommand FDEV_LINUX_isp1020_queuecommand
#define isp1020_release FDEV_LINUX_isp1020_release
#define isp1020_reset FDEV_LINUX_isp1020_reset
#define kernel_scsi_ioctl FDEV_LINUX_kernel_scsi_ioctl
#define kfree_skb FDEV_LINUX_kfree_skb
#define kstat FDEV_LINUX_kstat
#define lance32_debug FDEV_LINUX_lance32_debug
#define lance32_probe1 FDEV_LINUX_lance32_probe1
#define lance_debug FDEV_LINUX_lance_debug
#define lance_init FDEV_LINUX_lance_init
#define lance_probe1 FDEV_LINUX_lance_probe1
#define last_cmnd FDEV_LINUX_last_cmnd
#define linux_intr_init FDEV_LINUX_linux_intr_init
#define linux_timer_intr FDEV_LINUX_linux_timer_intr
#define linux_to_oskit_error FDEV_LINUX_linux_to_oskit_error
#define ll_rw_block FDEV_LINUX_ll_rw_block
#define make_code FDEV_LINUX_make_code
#define max_scsi_hosts FDEV_LINUX_max_scsi_hosts
#define mbox_param FDEV_LINUX_mbox_param
#define my_done FDEV_LINUX_my_done
#define ncr53c70066_setup FDEV_LINUX_ncr53c70066_setup
#define ncr53c700_setup FDEV_LINUX_ncr53c700_setup
#define ncr53c710_setup FDEV_LINUX_ncr53c710_setup
#define ncr53c720_setup FDEV_LINUX_ncr53c720_setup
#define ncr53c810_setup FDEV_LINUX_ncr53c810_setup
#define ncr53c815_setup FDEV_LINUX_ncr53c815_setup
#define ncr53c820_setup FDEV_LINUX_ncr53c820_setup
#define ncr53c825_setup FDEV_LINUX_ncr53c825_setup
#define ncr53c8xx_abort FDEV_LINUX_ncr53c8xx_abort
#define ncr53c8xx_detect FDEV_LINUX_ncr53c8xx_detect
#define ncr53c8xx_proc_info FDEV_LINUX_ncr53c8xx_proc_info
#define ncr53c8xx_queue_command FDEV_LINUX_ncr53c8xx_queue_command
#define ncr53c8xx_reset FDEV_LINUX_ncr53c8xx_reset
#define ncr_abort_command FDEV_LINUX_ncr_abort_command
#define ncr_queue_command FDEV_LINUX_ncr_queue_command
#define ncr_reset_bus FDEV_LINUX_ncr_reset_bus
#define ne_probe FDEV_LINUX_ne_probe
#define need_isa_buffer FDEV_LINUX_need_isa_buffer
#define net_bh FDEV_LINUX_net_bh
#define net_debug_mode FDEV_LINUX_net_debug_mode
#define net_dev_init FDEV_LINUX_net_dev_init
#define netif_rx FDEV_LINUX_netif_rx
#define next_scsi_host FDEV_LINUX_next_scsi_host
#define ni52_probe FDEV_LINUX_ni52_probe
#define ni65_probe FDEV_LINUX_ni65_probe
#define overrides FDEV_LINUX_overrides
#define overrun_buf FDEV_LINUX_overrun_buf
#define pas16_abort FDEV_LINUX_pas16_abort
#define pas16_biosparam FDEV_LINUX_pas16_biosparam
#define pas16_detect FDEV_LINUX_pas16_detect
#define pas16_hw_detect FDEV_LINUX_pas16_hw_detect
#define pas16_offset FDEV_LINUX_pas16_offset
#define pas16_proc_info FDEV_LINUX_pas16_proc_info
#define pas16_queue_command FDEV_LINUX_pas16_queue_command
#define pas16_reset FDEV_LINUX_pas16_reset
#define pas16_setup FDEV_LINUX_pas16_setup
#define pci_devices FDEV_LINUX_pci_devices
#define pci_init FDEV_LINUX_pci_init
#define pci_lookup_dev FDEV_LINUX_pci_lookup_dev
#define pci_root FDEV_LINUX_pci_root
#define pci_scan_method FDEV_LINUX_pci_scan_method
#define pci_strclass FDEV_LINUX_pci_strclass
#define pci_strdev FDEV_LINUX_pci_strdev
#define pci_strvendor FDEV_LINUX_pci_strvendor
#define pcibios_find_class FDEV_LINUX_pcibios_find_class
#define pcibios_find_device FDEV_LINUX_pcibios_find_device
#define pcibios_fixup FDEV_LINUX_pcibios_fixup
#define pcibios_init FDEV_LINUX_pcibios_init
#define pcibios_present FDEV_LINUX_pcibios_present
#define pcibios_read_config_byte FDEV_LINUX_pcibios_read_config_byte
#define pcibios_read_config_dword FDEV_LINUX_pcibios_read_config_dword
#define pcibios_read_config_word FDEV_LINUX_pcibios_read_config_word
#define pcibios_strerror FDEV_LINUX_pcibios_strerror
#define pcibios_write_config_byte FDEV_LINUX_pcibios_write_config_byte
#define pcibios_write_config_dword FDEV_LINUX_pcibios_write_config_dword
#define pcibios_write_config_word FDEV_LINUX_pcibios_write_config_word
#define phys_to_virt FDEV_LINUX_phys_to_virt
#define pio_scsi_dev_types FDEV_LINUX_pio_scsi_dev_types
#define print_Scsi_Cmnd FDEV_LINUX_print_Scsi_Cmnd
#define print_command FDEV_LINUX_print_command
#define print_config FDEV_LINUX_print_config
#define print_driverbyte FDEV_LINUX_print_driverbyte
#define print_hostbyte FDEV_LINUX_print_hostbyte
#define print_info FDEV_LINUX_print_info
#define print_msg FDEV_LINUX_print_msg
#define print_pio_config FDEV_LINUX_print_pio_config
#define print_sense FDEV_LINUX_print_sense
#define print_status FDEV_LINUX_print_status
#define probe_irq_off FDEV_LINUX_probe_irq_off
#define probe_irq_on FDEV_LINUX_probe_irq_on
#define proc_net FDEV_LINUX_proc_net
#define proc_net_inode_operations FDEV_LINUX_proc_net_inode_operations
#define proc_register FDEV_LINUX_proc_register
#define proc_scsi FDEV_LINUX_proc_scsi
#define proc_scsi_NCR53c406a FDEV_LINUX_proc_scsi_NCR53c406a
#define proc_scsi_advansys FDEV_LINUX_proc_scsi_advansys
#define proc_scsi_aha152x FDEV_LINUX_proc_scsi_aha152x
#define proc_scsi_aha1542 FDEV_LINUX_proc_scsi_aha1542
#define proc_scsi_aha1740 FDEV_LINUX_proc_scsi_aha1740
#define proc_scsi_aic7xxx FDEV_LINUX_proc_scsi_aic7xxx
#define proc_scsi_am53c974 FDEV_LINUX_proc_scsi_am53c974
#define proc_scsi_dtc FDEV_LINUX_proc_scsi_dtc
#define proc_scsi_eata2x FDEV_LINUX_proc_scsi_eata2x
#define proc_scsi_eata_dma FDEV_LINUX_proc_scsi_eata_dma
#define proc_scsi_eata_pio FDEV_LINUX_proc_scsi_eata_pio
#define proc_scsi_fdomain FDEV_LINUX_proc_scsi_fdomain
#define proc_scsi_in2000 FDEV_LINUX_proc_scsi_in2000
#define proc_scsi_in2000 FDEV_LINUX_proc_scsi_in2000
#define proc_scsi_inode_operations FDEV_LINUX_proc_scsi_inode_operations
#define proc_scsi_ncr53c7xx FDEV_LINUX_proc_scsi_ncr53c7xx
#define proc_scsi_ncr53c8xx FDEV_LINUX_proc_scsi_ncr53c8xx
#define proc_scsi_pas16 FDEV_LINUX_proc_scsi_pas16
#define proc_scsi_qlogicfas FDEV_LINUX_proc_scsi_qlogicfas
#define proc_scsi_scsi_debug FDEV_LINUX_proc_scsi_scsi_debug
#define proc_scsi_seagate FDEV_LINUX_proc_scsi_seagate
#define proc_scsi_t128 FDEV_LINUX_proc_scsi_t128
#define proc_scsi_u14_34f FDEV_LINUX_proc_scsi_u14_34f
#define proc_scsi_ultrastor FDEV_LINUX_proc_scsi_ultrastor
#define proc_scsi_wd7000 FDEV_LINUX_proc_scsi_wd7000
#define proc_unregister FDEV_LINUX_proc_unregister
#define qlogicfas_abort FDEV_LINUX_qlogicfas_abort
#define qlogicfas_biosparam FDEV_LINUX_qlogicfas_biosparam
#define qlogicfas_command FDEV_LINUX_qlogicfas_command
#define qlogicfas_detect FDEV_LINUX_qlogicfas_detect
#define qlogicfas_info FDEV_LINUX_qlogicfas_info
#define qlogicfas_queuecommand FDEV_LINUX_qlogicfas_queuecommand
#define qlogicfas_reset FDEV_LINUX_qlogicfas_reset
#define rcs_version FDEV_LINUX_rcs_version
#define read_1_byte FDEV_LINUX_read_1_byte
#define read_3393 FDEV_LINUX_read_3393
#define read_3393_count FDEV_LINUX_read_3393_count
#define read_ahead FDEV_LINUX_read_ahead
#define register_HBA FDEV_LINUX_register_HBA
#define register_blkdev FDEV_LINUX_register_blkdev
#define register_netdev FDEV_LINUX_register_netdev
#define register_pio_HBA FDEV_LINUX_register_pio_HBA
#define register_symtab_from FDEV_LINUX_register_symtab_from
#define release_region FDEV_LINUX_release_region
#define request_dma FDEV_LINUX_request_dma
#define request_irq FDEV_LINUX_request_irq
#define request_queueable FDEV_LINUX_request_queueable
#define request_region FDEV_LINUX_request_region
#define reset_hardware FDEV_LINUX_reset_hardware
#define resetup_one_dev FDEV_LINUX_resetup_one_dev
#define revalidate_scsidisk FDEV_LINUX_revalidate_scsidisk
#define risc_code01 FDEV_LINUX_risc_code01
#define risc_code_addr01 FDEV_LINUX_risc_code_addr01
#define risc_code_length01 FDEV_LINUX_risc_code_length01
#define risc_code_version FDEV_LINUX_risc_code_version
#define round_period FDEV_LINUX_round_period
#define rscsi_disks FDEV_LINUX_rscsi_disks
#define rx_words FDEV_LINUX_rx_words
#define scsi_abort FDEV_LINUX_scsi_abort
#define scsi_build_commandblocks FDEV_LINUX_scsi_build_commandblocks
#define scsi_command_size FDEV_LINUX_scsi_command_size
#define scsi_debug_abort FDEV_LINUX_scsi_debug_abort
#define scsi_debug_biosparam FDEV_LINUX_scsi_debug_biosparam
#define scsi_debug_command FDEV_LINUX_scsi_debug_command
#define scsi_debug_detect FDEV_LINUX_scsi_debug_detect
#define scsi_debug_info FDEV_LINUX_scsi_debug_info
#define scsi_debug_proc_info FDEV_LINUX_scsi_debug_proc_info
#define scsi_debug_queuecommand FDEV_LINUX_scsi_debug_queuecommand
#define scsi_debug_reset FDEV_LINUX_scsi_debug_reset
#define scsi_dev_init FDEV_LINUX_scsi_dev_init
#define scsi_device_types FDEV_LINUX_scsi_device_types
#define scsi_devicelist FDEV_LINUX_scsi_devicelist
#define scsi_devices FDEV_LINUX_scsi_devices
#define scsi_do_cmd FDEV_LINUX_scsi_do_cmd
#define scsi_free FDEV_LINUX_scsi_free
#define scsi_hostlist FDEV_LINUX_scsi_hostlist
#define scsi_hosts FDEV_LINUX_scsi_hosts
#define scsi_init FDEV_LINUX_scsi_init
#define scsi_init_free FDEV_LINUX_scsi_init_free
#define scsi_init_malloc FDEV_LINUX_scsi_init_malloc
#define scsi_ioctl FDEV_LINUX_scsi_ioctl
#define scsi_irq_translate FDEV_LINUX_scsi_irq_translate
#define scsi_loadable_module_flag FDEV_LINUX_scsi_loadable_module_flag
#define scsi_luns_setup FDEV_LINUX_scsi_luns_setup
#define scsi_make_blocked_list FDEV_LINUX_scsi_make_blocked_list
#define scsi_malloc FDEV_LINUX_scsi_malloc
#define scsi_mark_bus_reset FDEV_LINUX_scsi_mark_bus_reset
#define scsi_mark_host_reset FDEV_LINUX_scsi_mark_host_reset
#define scsi_pid FDEV_LINUX_scsi_pid
#define scsi_register FDEV_LINUX_scsi_register
#define scsi_register_device FDEV_LINUX_scsi_register_device
#define scsi_register_module FDEV_LINUX_scsi_register_module
#define scsi_reset FDEV_LINUX_scsi_reset
#define scsi_symbol_table FDEV_LINUX_scsi_symbol_table
#define scsi_unregister FDEV_LINUX_scsi_unregister
#define scsi_unregister_module FDEV_LINUX_scsi_unregister_module
#define scsicam_bios_param FDEV_LINUX_scsicam_bios_param
#define sd FDEV_LINUX_sd
#define sd_ioctl FDEV_LINUX_sd_ioctl
#define sd_template FDEV_LINUX_sd_template
#define seagate_st0x_abort FDEV_LINUX_seagate_st0x_abort
#define seagate_st0x_biosparam FDEV_LINUX_seagate_st0x_biosparam
#define seagate_st0x_command FDEV_LINUX_seagate_st0x_command
#define seagate_st0x_detect FDEV_LINUX_seagate_st0x_detect
#define seagate_st0x_info FDEV_LINUX_seagate_st0x_info
#define seagate_st0x_proc_info FDEV_LINUX_seagate_st0x_proc_info
#define seagate_st0x_queue_command FDEV_LINUX_seagate_st0x_queue_command
#define seagate_st0x_reset FDEV_LINUX_seagate_st0x_reset
#define seeq8005_init FDEV_LINUX_seeq8005_init
#define seeq8005_probe FDEV_LINUX_seeq8005_probe
#define set_device_ro FDEV_LINUX_set_device_ro
#define show_dma FDEV_LINUX_show_dma
#define signatures FDEV_LINUX_signatures
#define skb_put FDEV_LINUX_skb_put
#define skb_reserve FDEV_LINUX_skb_reserve
#define smc_init FDEV_LINUX_smc_init
#define st0x_setup FDEV_LINUX_st0x_setup
#define start_code FDEV_LINUX_start_code
#define swap_statistics FDEV_LINUX_swap_statistics
#define swapfarbuf4 FDEV_LINUX_swapfarbuf4
#define t128_abort FDEV_LINUX_t128_abort
#define t128_biosparam FDEV_LINUX_t128_biosparam
#define t128_detect FDEV_LINUX_t128_detect
#define t128_proc_info FDEV_LINUX_t128_proc_info
#define t128_queue_command FDEV_LINUX_t128_queue_command
#define t128_reset FDEV_LINUX_t128_reset
#define t128_setup FDEV_LINUX_t128_setup
#define tc59x_probe FDEV_LINUX_tc59x_probe
#define timer_active FDEV_LINUX_timer_active
#define timer_bh FDEV_LINUX_timer_bh
#define timer_table FDEV_LINUX_timer_table
#define tmc8xx_setup FDEV_LINUX_tmc8xx_setup
#define tq_immediate FDEV_LINUX_tq_immediate
#define tq_timer FDEV_LINUX_tq_timer
#define tqueue_bh FDEV_LINUX_tqueue_bh
#define transfer_bytes FDEV_LINUX_transfer_bytes
#define transfer_pio FDEV_LINUX_transfer_pio
#define tulip_hwinit FDEV_LINUX_tulip_hwinit
#define tulip_probe FDEV_LINUX_tulip_probe
#define u14_34f_abort FDEV_LINUX_u14_34f_abort
#define u14_34f_biosparam FDEV_LINUX_u14_34f_biosparam
#define u14_34f_detect FDEV_LINUX_u14_34f_detect
#define u14_34f_queuecommand FDEV_LINUX_u14_34f_queuecommand
#define u14_34f_release FDEV_LINUX_u14_34f_release
#define u14_34f_reset FDEV_LINUX_u14_34f_reset
#define u14_34f_setup FDEV_LINUX_u14_34f_setup
#define ultra_probe FDEV_LINUX_ultra_probe
#define ultra_probe1 FDEV_LINUX_ultra_probe1
#define ultrastor_abort FDEV_LINUX_ultrastor_abort
#define ultrastor_biosparam FDEV_LINUX_ultrastor_biosparam
#define ultrastor_bus_reset FDEV_LINUX_ultrastor_bus_reset
#define ultrastor_detect FDEV_LINUX_ultrastor_detect
#define ultrastor_info FDEV_LINUX_ultrastor_info
#define ultrastor_queuecommand FDEV_LINUX_ultrastor_queuecommand
#define ultrastor_reset FDEV_LINUX_ultrastor_reset
#define unregister_blkdev FDEV_LINUX_unregister_blkdev
#define unregister_netdev FDEV_LINUX_unregister_netdev
#define virt_to_phys FDEV_LINUX_virt_to_phys
#define vortex_debug FDEV_LINUX_vortex_debug
#define wait_for_buffer FDEV_LINUX_wait_for_buffer
#define wait_for_request FDEV_LINUX_wait_for_request
#define wd7000_abort FDEV_LINUX_wd7000_abort
#define wd7000_biosparam FDEV_LINUX_wd7000_biosparam
#define wd7000_command FDEV_LINUX_wd7000_command
#define wd7000_detect FDEV_LINUX_wd7000_detect
#define wd7000_diagnostics FDEV_LINUX_wd7000_diagnostics
#define wd7000_init FDEV_LINUX_wd7000_init
#define wd7000_intr_handle FDEV_LINUX_wd7000_intr_handle
#define wd7000_queuecommand FDEV_LINUX_wd7000_queuecommand
#define wd7000_reset FDEV_LINUX_wd7000_reset
#define wd7000_revision FDEV_LINUX_wd7000_revision
#define wd7000_setup FDEV_LINUX_wd7000_setup
#define wd_probe FDEV_LINUX_wd_probe
#define wd_probe1 FDEV_LINUX_wd_probe1
#define write_3393 FDEV_LINUX_write_3393
#define write_3393_cmd FDEV_LINUX_write_3393_cmd
#define write_3393_count FDEV_LINUX_write_3393_count
#define znet_probe FDEV_LINUX_znet_probe


#endif /* _LINUX_DEV_GLOBAL_H_ */
