/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Glue Libraries, which are free
 * software, also known as "open source;" you can redistribute them and/or
 * modify them under the terms of the GNU General Public License (GPL),
 * version 2, as published by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Simple DMA management.
 */

#ifndef OSKIT
#define OSKIT
#endif

#include <oskit/dev/dev.h>
#include <oskit/x86/pc/dev.h>

#include <linux/errno.h>
#include <linux/sched.h>
#include <asm/dma.h>

/*
 * Allocate a DMA channel.
 */
int
request_dma(unsigned int drq, const char *name)
{
	struct task_struct *cur = current;
	int chan;

	chan = osenv_isadma_alloc(drq);

	current = cur;
	return chan;
}

/*
 * Free a DMA channel.
 */
void
free_dma(unsigned int drq)
{
	struct task_struct *cur = current;

	osenv_isadma_free(drq);

	current = cur;
}
