/*
 * Copyright (c) 1996-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include "malloc.h"

void *memalignf(size_t alignment, size_t size, unsigned flags)
{
	unsigned shift;
	size_t *chunk;

	/* Find the alignment shift in bits.  XXX use proc_ops.h  */
	for (shift = 0; (1 << shift) < alignment; shift++);

	/*
	 * Allocate a chunk of LMM memory with the specified alignment shift
	 * and an offset such that the memory block we return will be aligned
	 * after we add our size field to the beginning of it.
	 */
	size += sizeof(size_t);
	mem_lock();
	while (!(chunk = lmm_alloc_aligned(&malloc_lmm, size, flags, shift,
					   (1 << shift) - sizeof(size_t))))
	{
		mem_unlock();
		if (!morecore(size * 2))
			return 0;
		mem_lock();
	}
	mem_unlock();

	*chunk = size;
	return chunk+1;
}


