/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * default implementation of bmod_lock() and bmod_unlock()
 */

#include <stdlib.h>
#include <oskit/fs/bmodfs.h>
#include <oskit/com/services.h>
#include <oskit/com/lock_mgr.h>
#include <oskit/com/lock.h>

static oskit_lock_t	*bmodlock;

void oskit_bmod_lock()
{
	if (!bmodlock)
		return;
	
	oskit_lock_lock(bmodlock);
}

void oskit_bmod_unlock()
{
	if (!bmodlock)
		return;
	
	oskit_lock_unlock(bmodlock);
}

/*
 * Query the registry for the lock_mgr. If its null, then no memory locking
 * is needed. Otherwise create a lock.
 */
void oskit_bmod_lock_init()
{
	oskit_lock_mgr_t	*lock_mgr;
	
	if (oskit_lookup_first(&oskit_lock_mgr_iid, (void *) &lock_mgr))
		panic("oskit_bmod_lock_init: lookup_first");

	if (!lock_mgr)
		return;

	if (oskit_lock_mgr_allocate_lock(lock_mgr, &bmodlock))
		panic("oskit_bmod_lock_init: oskit_lock_mgr_allocate_lock");
}
