/*
 * Copyright (c) 1996, 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * Routines to initialize the freebsd_net code.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <vm/vm.h>		/* this is our faked one */
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/domain.h>
#include <sys/sockio.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include "net/netisr.h"
#include "net/if.h"
#include "net/route.h"
#include "netinet/in.h"
#include "netinet/if_ether.h"
#include "netinet/in_systm.h"
#include "netinet/ip.h"
#include "netinet/ip_var.h"

#include <oskit/net/socket.h>
#include "bsdnet_net_io.h"

#include "glue.h"

/* this is what NETISR_SET(NETISR_ARP, arpintr); does */
struct netisrtab mn_arp = { NETISR_ARP, arpintr };
struct netisrtab mn_ip = { NETISR_IP, ipintr };

struct faked_linker_set {
	int	ls_length;
	caddr_t	ls_items[200]; 
} netisr_set = { 2, 
	{ (caddr_t)&mn_arp, 
	  (caddr_t)&mn_ip, 
	  (caddr_t)0 }
};

extern struct domain routedomain;
extern struct domain inetdomain;

/* comes from DOMAIN_SET(route); */
struct faked_linker_set2 {
	int	ls_length;
	caddr_t	ls_items[200]; 
} domain_set = { 2, 
	{ (caddr_t)&routedomain, 
	  (caddr_t)&inetdomain, 
	  (caddr_t)0 }
};

/* array of software interrupts */
void    (*netisrs[32]) (void);
static void setup_netisrs(struct linker_set *);

/*
 * initialize the TCP/IP stack
 *
 * assume clock and other stuff is already initialized
 */
oskit_error_t 
oskit_freebsd_net_init(oskit_socket_factory_t **f)
{
	struct proc p;

	OSKIT_FREEBSD_CREATE_CURPROC(p)
	oskit_freebsd_init();

        /*
         * Quickly wire in netisrs.
         */
        setup_netisrs((struct linker_set *)&netisr_set);

        /* Initialize mbuf's and protocols. */

	/* we used to call mbinit here, but this is no longer necessary
	 * since external mbufs are simply oskit_bufios
	 */
        ifinit();
        domaininit();
	OSKIT_FREEBSD_DESTROY_CURPROC(p)

	/*
	 * register our socket factory
	 */
	*f = &oskit_freebsd_net_socket_factory;
	return 0;
}

/* ---------------------------------------------------------------------- */
static void
setup_netisrs(struct linker_set *ls)
{
        int i;
        const struct netisrtab *nit;

        for(i = 0; ls->ls_items[i]; i++) {
                nit = (const struct netisrtab *)ls->ls_items[i];
                netisrs[nit->nit_num] = nit->nit_isr;
        }
}

