/*
 * Copyright (c) 1994-1995, 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <string.h>

#include "malloc.h"

/* XX could be made smarter, so it doesn't always copy to a new block.  */
void *realloc(void *buf, oskit_size_t new_size)
{
	oskit_size_t *op;
	oskit_size_t old_size;
	oskit_size_t *np;

	if (buf == 0)
		return malloc(new_size);

	op = (oskit_size_t*)buf;
	old_size = *--op;

	new_size += sizeof(oskit_size_t);
	mem_lock();
	while (!(np = lmm_alloc(&malloc_lmm, new_size, 0)))
	{
		mem_unlock();
		if (!morecore(new_size))
			return 0;
		mem_lock();
	}

	memcpy(np, op, old_size < new_size ? old_size : new_size);

	lmm_free(&malloc_lmm, op, old_size);
	mem_unlock();
	
	*np++ = new_size;
	return np;
}

