#!/bin/sh -
#
# Copyright (c) 1997,1999 The University of Utah and the Flux Group.
# All rights reserved.
# 
# Contributed by the Computer Security Research division,
# INFOSEC Research and Technology Office, NSA.
# 
# This file is part of the Flux OSKit.  The OSKit is free software, also known
# as "open source;" you can redistribute it and/or modify it under the terms
# of the GNU General Public License (GPL), version 2, as published by the Free
# Software Foundation (FSF).  To explore alternate licensing terms, contact
# the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
# 
# The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
# received a copy of the GPL along with the OSKit; see the file COPYING.  If
# not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
#

# FLASK

set -e

awk=$1
prefix_file=$2
suffix_file=$3
shift 3

# output file
middle_file="security.middle" 
output_file="security.h"
debug_file="class_to_string.h"

cat $* | $awk "
BEGIN	{
		outfile = \"$middle_file\"
		debugfile = \"$debug_file\"
		"'
		nextstate = "CLASS";

		printf("/*\n * Security object class definitions\n */\n") > outfile;

		printf("#if FLASK\n\n") > debugfile;
		printf("/*\n * Security object class definitions\n */\n") > debugfile;
		printf("static char *class_to_string[] =\n{\n") > debugfile;
		printf("    \"null\",\n") > debugfile;
	}
/^[ \t]*#/	{ 
			next;
		}
$1 == "CLASS"	{ 
			if (nextstate != "CLASS")
			{
				printf("Parse error:  Unexpected class definition on line %d\n", NR);
				next;	
			}

			if ($2 in class_found)
			{
				printf("Duplicate class definition for %s on line %d.\n", $2, NR);
				next;
			}	
			class_found[$2] = 1;

			class_value++;

			printf("#define SECCLASS_%s", toupper($2)) > outfile;
			for (i = 0; i < 40 - length($2); i++) 
				printf(" ") > outfile; 
			printf("%d\n", class_value) > outfile; 

			printf("    \"%s\",\n", $2) > debugfile;
		}
END	{
		if (nextstate != "CLASS")
			printf("Parse error:  Unexpected end of file\n");

		printf("};\n\n") > debugfile;
		printf("#endif FLASK\n") > debugfile;
	}'

rm -f $output_file
cat $prefix_file $middle_file $suffix_file > $output_file
rm -f $middle_file

# FLASK
