/*
 * Copyright (c) 1997,1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#ifndef _OSKIT__COM_SFS_H_
#define _OSKIT__COM_SFS_H_

#include <oskit/io/absio.h>
#include <oskit/fs/filesystem.h>
#include <oskit/fs/file.h>
#include <oskit/fs/dir.h>
#include <oskit/fs/openfile.h>
#include <oskit/fs/fs.h>
#include <oskit/avc/avc.h>
#include <oskit/comsid.h>
#include <oskit/fs/filepsid.h>
#include <oskit/fs/file_secure.h>
#include <oskit/fs/dir_secure.h>
#include "sfs_hashtab.h"


struct sfilesystem
{
    oskit_filesystem_t	fsi;	/* COM filesystem interface */
    oskit_comsid_t	sidi;	/* COM sid interface */
    unsigned		count;	/* reference count */
    security_id_t	sid;	/* fs security identifier */
    oskit_dir_t		*root;	/* underlying root directory */
    oskit_filepsid_t	*psid;	/* underlying persistent SID storage */
    oskit_avc_t		*avc;	/* access vector cache */
    hashtab_t 		ino2sf;	/* ino -> sfiledir */
    oskit_filesystem_t   *fs;	/* underlying file system */
};


struct sfiledir
{
    oskit_file_t filei;		/* COM file/dir interface */
    oskit_absio_t absioi;	/* COM absolute I/O interface */
    oskit_comsid_t sidi;	/* COM sid interface */
    oskit_file_secure_t sfilei;	/* Flask extensions to oskit_file */
    oskit_dir_secure_t sdiri;	/* Flask extensions to oskit_dir */
    unsigned count;		/* reference count */
    security_id_t sid;		/* security identifier */
    struct sfilesystem *sfs;	/* containing file system */
    oskit_file_t *mountedhere;	/* file mounted here; null if none */
    oskit_file_t *file;		/* underlying file interface */    
    oskit_absio_t *absio;	/* underlying absio interface */
    oskit_bool_t virtual;	/* virtual directory; use logical parent */
    oskit_dir_t *parent;	/* logical parent; null if a root directory */
    oskit_bool_t symlink;	/* is a symbolic link */
};


struct sopenfile
{
    oskit_openfile_t ofilei;	/* COM open file interface */
    oskit_absio_t absioi;	/* COM absolute I/O interface */
    oskit_comsid_t sidi;	/* COM sid interface */ 
    unsigned count;		/* reference count */
    oskit_oflags_t flags;	/* open flags */	
    oskit_bool_t isdir;		/* is the associated file a dir? */
    security_id_t sid;		/* security identifier */
    struct sfiledir *sfile;	/* associated file */
    oskit_openfile_t *ofile;	/* underlying open file object */
    oskit_absio_t *absio;	/* underlying absio interface */
};

#define sfilesystem_create oskit_com_sfs_sfilesystem_create
#define sfiledir_create oskit_com_sfs_sfiledir_create
#define sopenfile_create oskit_com_sfs_sopenfile_create

oskit_error_t sfilesystem_create(oskit_dir_t *root, 
				security_id_t sid,
				oskit_filepsid_t *psid,
				oskit_avc_t *avc,
				struct sfilesystem **out_sfs);

oskit_error_t sfiledir_create(struct sfilesystem *sfs,
			     oskit_file_t *file,
			     struct sfiledir **out_sfiledir);	

oskit_error_t sopenfile_create(struct sfiledir *sfile, 
			      oskit_openfile_t *ofile,
			      oskit_oflags_t flags,
			      oskit_bool_t isdir,
			      security_id_t sid,
			      struct sopenfile **out_sofile);    


#endif _OSKIT__COM_SFS_H_

