/* Modified from FreeBSD 2.1 sys/i386/boot/netboot */
/***********************************************************************

Remote Procedure Call Support Routines

Author: Martin Renters
  Date: Oct/1994

***********************************************************************/

#ifndef __RPC_H_INCLUDED__
#define __RPC_H_INCLUDED__

#include "ip.h"
#include "udp.h"

struct rpc_t {
	struct iphdr	ip;
	struct udphdr	udp;
	union {
		char data[1400];
		struct {
			long id;
			long type;
			long rstatus;
			long verifier;
			long v2;
			long astatus;
			long data[1];
		} reply;
	} u;
};

#define SUNRPC		111

#define RPC_SOCKET	620			/* Arbitrary */

#define PROG_PORTMAP	100000
#define PROG_NFS	100003
#define PROG_MOUNT	100005

#define MSG_CALL	0
#define MSG_REPLY	1

#define PORTMAP_LOOKUP	3

#define MOUNT_ADDENTRY	1
#define NFS_LOOKUP	4
#define NFS_READ	6

#define NFS_FHSIZE	32

#define NFSERR_PERM	1
#define NFSERR_NOENT	2
#define NFSERR_ACCES	13

extern int rpc_id;

void rpc_init(void);
int rpc_lookup(int addr, int prog, int ver);
int nfs_mount(int server, int port, char *path, char *fh);
int nfs_lookup(int server, int port, char *fh, char *path, char *file_fh);
int nfs_read(int server, int port, char *fh, int offset, int len, char *buffer);
char *rpc_strerror(struct rpc_t *rpc);
char *nfs_strerror(int err);

#endif /* __RPC_H_INCLUDED__ */
