/* Modified from FreeBSD 2.1 sys/i386/boot/netboot */
/***********************************************************************

Remote Procedure Call Support Routines

Author: Martin Renters
  Date: Oct/1994

***********************************************************************/

#include <oskit/c/arpa/inet.h>
#include <oskit/c/string.h>
#include <oskit/c/stdio.h>

#include "netboot.h"
#include "driver.h"
#include "ether.h"
#include "udp.h"
#include "await.h"
#include "timer.h"

#include "rpc.h"

int rpc_id;

void
rpc_init()
{
	rpc_id = currticks();
}

/***************************************************************************

RPC_LOOKUP:  Lookup RPC Port numbers

***************************************************************************/
int
rpc_lookup(int addr, int prog, int ver)
{
	struct rpc_t buf, *rpc;
	char *rpcptr;
	int retries = MAX_RPC_RETRIES;
	rpcptr = netsprintf(buf.u.data,"%L%L%L%L%L%L%L%L%L%L%L%L%L%L",
		rpc_id, MSG_CALL, 2, PROG_PORTMAP, 2, PORTMAP_LOOKUP,
		0, 0, 0, 0, prog, ver, IP_UDP, 0);
	while(retries--) {
		udp_transmit(arptable[addr].ipaddr, RPC_SOCKET,
			SUNRPC, rpcptr - (char *)&buf, &buf);
		if (await_reply(AWAIT_RPC, rpc_id, NULL)) {
			rpc = (struct rpc_t *)&packet[ETHER_HDR_SIZE];
			if (rpc->u.reply.rstatus == rpc->u.reply.verifier ==
				rpc->u.reply.astatus == 0)
				return(ntohl(rpc->u.reply.data[0]));
			else {
				printf("%s\n", rpc_strerror(rpc));
				return(-1);
			}
		}
	}
	return(-1);
}

/***************************************************************************

NFS_MOUNT:  Mount an NFS Filesystem

***************************************************************************/
int
nfs_mount(int server, int port, char *path, char *fh)
{
	struct	rpc_t buf, *rpc;
	char	*rpcptr;
	int retries = MAX_RPC_RETRIES;
	rpcptr = netsprintf(buf.u.data,"%L%L%L%L%L%L%L%L%L%S%L%L%L%L%L%L%L%S",
		rpc_id, MSG_CALL, 2, PROG_MOUNT, 1, MOUNT_ADDENTRY,
		1, hostnamelen + 28,0,hostname,0,0,2,0,0,0,0,
		path);
	while(retries--) {
		udp_transmit(arptable[server].ipaddr, RPC_SOCKET,
			port, rpcptr - (char *)&buf, &buf);
		if (await_reply(AWAIT_RPC, rpc_id, NULL)) {
			rpc = (struct rpc_t *)&packet[ETHER_HDR_SIZE];
			if (rpc->u.reply.rstatus || rpc->u.reply.verifier ||
				rpc->u.reply.astatus || rpc->u.reply.data[0]) {
				printf("%s\n", rpc_strerror(rpc));
				return(-(ntohl(rpc->u.reply.data[0])));
			} else {
				memcpy(fh, &rpc->u.reply.data[1], 32);
				return(0);
			}
		}
	}
	return(-1);
}


/***************************************************************************

NFS_LOOKUP:  Lookup Pathname

***************************************************************************/
int
nfs_lookup(int server, int port, char *fh, char *path, char *file_fh)
{
	struct	rpc_t buf, *rpc;
	char	*rpcptr;
	int retries = MAX_RPC_RETRIES;
	rpcptr = netsprintf(buf.u.data,"%L%L%L%L%L%L%L%L%L%S%L%L%L%L%L%L%L%M%S",
		rpc_id, MSG_CALL, 2, PROG_NFS, 2, NFS_LOOKUP,
		1, hostnamelen + 28,0,hostname,0,0,2,0,0,0,0,
		32, fh, path);
	while(retries--) {
		udp_transmit(arptable[server].ipaddr, RPC_SOCKET,
			port, rpcptr - (char *)&buf, &buf);
		if (await_reply(AWAIT_RPC, rpc_id, NULL)) {
			rpc = (struct rpc_t *)&packet[ETHER_HDR_SIZE];
			if (rpc->u.reply.rstatus || rpc->u.reply.verifier ||
				rpc->u.reply.astatus || rpc->u.reply.data[0]) {
				printf("%s\n", rpc_strerror(rpc));
				return(-(ntohl(rpc->u.reply.data[0])));
			} else {
				memcpy(file_fh, &rpc->u.reply.data[1], 32);
				return(0);
			}
		}
	}
	return(-1);
}

/***************************************************************************

NFS_READ:  Read File

***************************************************************************/
int
nfs_read(int server, int port, char *fh, int offset, int len, char *buffer)
{
	struct	rpc_t buf, *rpc;
	char	*rpcptr;
	int	retries = MAX_RPC_RETRIES;
	int	rlen;
	rpcptr = netsprintf(buf.u.data,
		"%L%L%L%L%L%L%L%L%L%S%L%L%L%L%L%L%L%M%L%L%L",
		rpc_id, MSG_CALL, 2, PROG_NFS, 2, NFS_READ,
		1, hostnamelen + 28,0,hostname,0,0,2,0,0,0,0,
		32, fh, offset, len, 0);
	while(retries--) {
		udp_transmit(arptable[server].ipaddr, RPC_SOCKET,
			port, rpcptr - (char *)&buf, &buf);
		if (await_reply(AWAIT_RPC, rpc_id, NULL)) {
			rpc = (struct rpc_t *)&packet[ETHER_HDR_SIZE];
			if (rpc->u.reply.rstatus || rpc->u.reply.verifier ||
				rpc->u.reply.astatus || rpc->u.reply.data[0]) {
				printf("%s\n", rpc_strerror(rpc));
				return(-(ntohl(rpc->u.reply.data[0])));
			} else {
				rlen = ntohl(rpc->u.reply.data[18]);
				if (len < rlen) rlen = len;
				if (len > rlen) netprintf("short read\r\n");
				memcpy(buffer, &rpc->u.reply.data[19], rlen);
				return(rlen);
			}
		}
	}
	return(-1);
}

char *
rpc_strerror(struct rpc_t *rpc)
{
	static char buf[64];

	sprintf(buf, "RPC Error: (%d,%d,%d)",
		ntohl(rpc->u.reply.rstatus),
		ntohl(rpc->u.reply.verifier),
		ntohl(rpc->u.reply.astatus));
	return buf;
}

char *
nfs_strerror(int err)
{
	static char buf[64];

	switch (-err) {
	case NFSERR_PERM:	return "Not owner";
	case NFSERR_NOENT:	return "No such file or directory";
	case NFSERR_ACCES:	return "Permission denied";
	default:
		sprintf(buf, "Unknown NFS error %d", -err);
		return buf;
	}
}
