/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* Modified from FreeBSD 2.1 sys/i386/boot/netboot */
/**************************************************************************
NETBOOT -  BOOTP/TFTP Bootstrap Program

Author: Martin Renters
  Date: Dec/93

**************************************************************************/

#include <oskit/c/arpa/inet.h>		/* ntohs */
#include <oskit/c/string.h>		/* memcpy */

#include "driver.h"			/* eth_poll */
#include "ether.h"			/* arprequest */
#include "ip.h"				/* iphdr */
#include "udp.h"			/* udphdr */
#include "rpc.h"			/* rpc_t */
#include "netboot.h"			/* TIMEOUT */
#include "timer.h"			/* currticks */

#include "await.h"			/* AWAIT_foo */

/**************************************************************************
AWAIT_REPLY - Wait until we get a response for our request
XXX fix me so I call protocol-specific handlers like rpc_handler.
**************************************************************************/
int
await_reply(int type, int ival, void *ptrv)
{
	char *ptr = ptrv;
	unsigned long time;
	struct	iphdr *ip;
	struct	udphdr *udp;
	struct	arprequest *arpreply;
	struct	rpc_t *rpc;

	int	protohdrlen = ETHER_HDR_SIZE + sizeof(struct iphdr) +
				sizeof(struct udphdr);
	time = currticks() + TIMEOUT;
	while(time > currticks()) {
/*		pollkbd();*/
		if (eth_poll()) {	/* We have something! */
					/* Check for ARP - No IP hdr */
			if ((type == AWAIT_ARP) &&
			   (packetlen >= ETHER_HDR_SIZE +
				sizeof(struct arprequest)) &&
			   (((packet[12] << 8) | packet[13]) == ETHERTYPE_ARP)) {
				arpreply = (struct arprequest *)
					&packet[ETHER_HDR_SIZE];
				if ((arpreply->opcode == ntohs(ARPOP_REPLY))
				    && memcmp(arpreply->sipaddr, ptr, 4) == 0) {
					memcpy(arptable[ival].node,
						arpreply->shwaddr,
						ETHER_ADDR_SIZE);
					return(1);
				}
				continue;
			}

					/* Anything else has IP header */
			if ((packetlen < protohdrlen) ||
			   (((packet[12] << 8) | packet[13]) != ETHERTYPE_IP))
				continue;
			ip = (struct iphdr *)&packet[ETHER_HDR_SIZE];
			if ((ip->verhdrlen != 0x45) ||
				ipchksum(ip, sizeof(struct iphdr)) ||
				(ip->protocol != IP_UDP)) continue;
			udp = (struct udphdr *)&packet[ETHER_HDR_SIZE +
				sizeof(struct iphdr)];

					/* TFTP ? */
			if ((type == AWAIT_TFTP) &&
				(ntohs(udp->dest) == ival)) return(1);

					/* RPC */
			rpc = (struct rpc_t *)&packet[ETHER_HDR_SIZE];
			if ((type == AWAIT_RPC) &&
			   (ntohs(udp->dest) == RPC_SOCKET) &&
			   (ntohl(rpc->u.reply.id) == ival) &&
			   (ntohl(rpc->u.reply.type) == MSG_REPLY)) {
				rpc_id++;
				return(1);
			}
		}
	}
	return(0);
}

