/*
 * Copyright (c) 1995,1997-1998 University of Utah and the Flux Group.
 * 
 * This file is part of the OSKit Linux Boot Loader, which is free software,
 * also known as "open source;" you can redistribute it and/or modify it under
 * the terms of the GNU General Public License (GPL), version 2, as published
 * by the Free Software Foundation (FSF).
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

#include <linux/config.h>
#include <oskit/x86/asm.h>

#define SETUPSECS	4			/* nr of setup-sectors */
#define SYSSIZE		DEF_SYSSIZE

/* ROOT_DEV & SWAP_DEV are now written by "build". */
#define ROOT_DEV 0
#define SWAP_DEV 0
#ifndef SVGA_MODE
#define SVGA_MODE ASK_VGA
#endif
#ifndef RAMDISK
#define RAMDISK 0
#endif
#ifndef CONFIG_ROOT_RDONLY
#define CONFIG_ROOT_RDONLY 0
#endif

	.text
	.code16
	.globl	EXT(_start)
LEXT(_start)
	/* XXX at least we could print a message...  */
	jmp	EXT(_start)


	.org 497
setup_sects:
	.byte SETUPSECS
root_flags:
	.word CONFIG_ROOT_RDONLY
syssize:
	.word SYSSIZE
swap_dev:
	.word SWAP_DEV
ram_size:
	.word RAMDISK
vid_mode:
	.word SVGA_MODE
root_dev:
	.word ROOT_DEV
boot_flag:
	.word 0xAA55
