/*
 * Copyright (c) 1996, 1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Define console routines so we can use printf.
 *
 * We could probably get away with using the console code from libkern's
 * base_console.c if we consed up an argv/argc from our boothowto and
 * called base_console_init with them.
 */

#include <oskit/x86/pc/com_cons.h>
#include <oskit/x86/pc/direct_cons.h>
#include <oskit/x86/pc/base_console.h>

#include <oskit/tty.h>
#include <oskit/c/termios.h>

#include "reboot.h"
#include "boottype.h"

/*
 * Define this if you want the boot adaptor to always use the serial
 * line for the console,
 * regardless of what the RB_SERIAL flag (if any) is set to.
 */
#undef BA_FORCE_SERIAL

static int serial = 0;			/* Use serial console or not. */
static int com_cons_port = 1;

static void
putchar_init()
{
	/*
	 * Check the BSD-style RB_SERIAL flag if we're booting from
	 * BSD bootblocks.
	 */
#ifdef BA_FORCE_SERIAL
	serial = 1;
#else
	serial = (boottype == BOOTTYPE_OLDBSD || boottype == BOOTTYPE_NEWBSD)
		 && (boothowto & BSD_RB_SERIAL);
#endif

	if (serial) {
		if (boothowto & BSD_RB_FASTCONSOLE) {
			base_cooked_termios.c_ispeed = B115200;
			base_cooked_termios.c_ospeed = B115200;
		}
		com_cons_init(com_cons_port, &base_cooked_termios);
	}
}

int
console_putchar(int c)
{
	static int inited = 0;

	if (! inited) {
		putchar_init();
		inited = 1;
	}

	serial ? com_cons_putchar(com_cons_port, c) : direct_cons_putchar(c);

	return c;
}

/*
 * This is more efficient for console output, and allows similar treatment
 * in usermode where character based output is really bad.
 */
int
console_putbytes(const char *s, int len)
{
	while (len) {
		console_putchar(*s++);
		len--;
	}
	return 0;
}
