	Page	58,132
	Title	INPUT.ASM	Input Routines
;******************************************************************************
;
;   Name:	INPUT.ASM	Input Routines
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the input routines
;	used by the Apple emulator.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Input_Data		; Input data routine
;
;  External Declarations
;
	Extrn	Clear_Keyboard:Near	; Clear keyboard routine     (KEYBOARD)
	Extrn	Flush_Keyboard:Near	; Flush keyboard routine     (KEYBOARD)
	Extrn	Get_Key:Near		; Get keyboard code routine  (KEYBOARD)
	Extrn	Cursor_Off:Near 	; Turn cursor off routine	  (TTY)
	Extrn	Cursor_On:Near		; Turn cursor on routine	  (TTY)
	Extrn	Write_TTY:Near		; Write TTY routine		  (TTY)
	Extrn	Set_Cursor:Near 	; Set cursor position routine	  (TTY)
	Extrn	Set_Type:Near		; Set cursor type routine	  (TTY)
	Extrn	Get_Position:Near	; Get current position routine	  (TTY)
	Extrn	System_Flag:Byte	; Apple emulator system flag byte(DATA)
	Extrn	Video_Flag:Byte 	; Video system flag byte	 (DATA)
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	Subttl	Input_Data	Input Data Routine
	Page	+
;******************************************************************************
;
;	Input_Data(Count, Buffer)
;
;		Save the required registers
;		Call routine to turn the cursor on
;		While there is more user input and room in the buffer
;			Call routine to get current position
;			Call routine to set cursor to current position
;			Call routine to get input key from user
;			If this is a backspace key
;				If not already at the start
;					Call routine to echo the user input key
;					Restore the input count value
;					Decrement the buffer pointer
;				Endif
;			Else
;				Call routine to echo the user input key
;				Store the character in the input buffer
;				If this is a carriage return (End of input)
;					Exit the input loop
;				Else
;					Decrement the input counter
;				Endif
;			Endif
;		EndWhile
;		Calculate the actual input count
;		Call routine to turn the cursor off
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		CX    - Maximum number of characters to input (Including CR)
;		ES:DI - Pointer to keyboard data buffer
;
;	Registers on Exit:
;
;		AX    - Actual number of input characters (Not including CR)
;		FL    - ZR set if no input data
;
;******************************************************************************
		Even			; Force procedure to even address
Input_Data	Proc	Near		; Input data procedure
	Save	bx,cx,dx,di		; Save the required registers
	dec	cx			; Decrement to account for terminator
	mov	dx,cx			; Save the original input size
	call	Cursor_On		; Call routine to turn cursor on
Input_Loop:
	call	Get_Position		; Call routine to get current position
	call	Set_Cursor		; Call routine to set cursor position
	call	Get_Key 		; Call routine to get keyboard input
	cmp	al,BS			; Check for backspace character
	jne	Input_Check		; Jump if NOT a backspace character
Input_Backup:
	cmp	cx,dx			; Check for at start of input
	je	Input_Loop		; Jump if already at the start
	mov	al,BS			; Get a backspace character
	call	Write_TTY		; Call routine to print the character
	inc	cx			; Restore the input count value
	dec	di			; Restore the buffer pointer
	jmp	Short Input_Loop	; Go keep getting user input
Input_Check:
	call	Write_TTY		; Call routine to echo the character
	stosb				; Store this byte in input buffer
	cmp	al,CR			; Check for end of user input
	je	Input_Calculate 	; Jump if end of user input
	loop	Input_Loop		; Loop getting the user input
	jmp	Short Input_Backup	; Backup up the input one character
Input_Calculate:
	mov	ax,dx			; Get the original input size
	sub	ax,cx			; Calculate the actual input length
Input_Exit:
	Call	Cursor_Off		; Call routine to turn cursor off
	Restore bx,cx,dx,di		; Restore the required registers
	ret				; Return to the caller
Input_Data	Endp			; End of the Input_Data procedure
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Input module
