/*	show.c	1.2	86/10/07 */

#include <stdio.h>
#include <sys/file.h>
#include <suntool/tool_hs.h>

struct	gfxsubwindow {
	int	gfx_windowfd;
	int	gfx_flags;
#define	GFX_RESTART	0x01
#define	GFX_DAMAGED	0x02
	int	gfx_reps;
	struct	pixwin *gfx_pixwin;
	struct	rect gfx_rect;
	caddr_t	gfx_takeoverdata;
};

extern	struct gfxsubwindow *gfxsw_init();
struct gfxsubwindow *picwin;

#define PIXWIDTH	512
#define PIXHEIGHT	480

main(argc,argv) int argc; char *argv[];
{
    int fd,image_count;
    char *image_file;
    struct rasterfile header;
    unsigned char colormap[3][256];
    int dx, dy;

    struct pixrect *source_pixrect;

    if (argc < 2) {
        printf(" ... requires an image file as an argument\n");
        exit(1);
    }

    if ((picwin = gfxsw_init(0,argv)) == (struct gfxsubwindow *) 0)
	exit(1);

    while( 1)
	    for (image_count=1; image_count<argc; image_count++) {
		if (strcmp(argv[image_count], "-r") == 0)
			continue;
		if (picwin->gfx_flags&GFX_DAMAGED) {
			gfxsw_handlesigwinch(picwin);
			pw_write( picwin->gfx_pixwin,0,0,1280,1280,
				PIX_SRC,0,0,0);
		}
		if (picwin->gfx_flags&GFX_RESTART) {
			picwin->gfx_flags &= ~GFX_RESTART;
			continue;
		}
		image_file = argv[image_count];
		fd = open(image_file,O_RDONLY | O_NDELAY,0644);
		read( fd, &header, sizeof(struct rasterfile));
    		source_pixrect = mem_create(header.ras_width,
			header.ras_height, header.ras_depth);
		read(fd,colormap,256*3);
		colormap[0][254] = 255; colormap[0][255] = 0;
		colormap[1][254] = 255; colormap[1][255] = 0;
		colormap[2][254] = 255; colormap[2][255] = 0;
		read(fd, mpr_d(source_pixrect)->md_image,
			header.ras_width * header.ras_height);
		pw_setcmsname(picwin->gfx_pixwin, "molecules");
		pw_putcolormap(picwin->gfx_pixwin, 0,256,
			colormap[0],colormap[1],colormap[2]);
		dx = (picwin->gfx_rect.r_width - header.ras_width) / 2;
		dy = (picwin->gfx_rect.r_height - header.ras_height) / 2;
		pw_write(picwin->gfx_pixwin, dx, dy, header.ras_width,
			header.ras_height, PIX_SRC, source_pixrect,0,0);
		if (source_pixrect) pr_destroy( source_pixrect);
		close(fd);
		sleep( 5);
	    }
}
