#ifndef lint
static	char sccsid[] = "@(#)rotobj.c 1.2 86/10/07 Copyr 1986 Sun Micro";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/* 
 * this program uses the (as yet) undocumented command level interface
 * for the graphics procesor ... the user is currently advised against 
 * using the command interface until he has documentation. 
 */

#include <pixrect/pixrect_hs.h>
#include <pixrect/memreg.h>
#include <pixrect/cg2reg.h>
#include <sunwindow/window_hs.h>
#include <suntool/gfxsw.h>
#include <math.h>
#include <stdio.h>
#include <pixrect/gp1cmds.h>
#include <sys/file.h>
#include <sys/signal.h>
#include <sys/ioctl.h>
#include <sun/gpio.h>

static unsigned char rmap1[2], gmap1[2], bmap1[2];
static unsigned char rmap2[2], gmap2[2], bmap2[2];
static caddr_t gp1_shmem;
static struct pixrect;
static struct gfxsubwindow *gfx;
static int nvecs;
static char minordev;

int gp1_rop();
int sigxcpu_catcher();

struct gp1_attr
        {
        short attrchg;
        int attrcnt, clpcnt;
        int clipid;
        int org_x, org_y;
        int statblkindx;
        short fbindx;
        float xscale, xoffset, yscale, yoffset;
        short op, color, pixplanes;
	};
  
static struct gp1_attr gp1_attr;

struct point 
	{
	float x;
	float y;
	float z;
	float w;
	};

static struct point veclist[8400];

typedef float matrix_3d[4][4];
matrix_3d mtxidentity = {
        1.0,            0.0,            0.0,            0.0,
        0.0,            1.0,            0.0,            0.0,
        0.0,            0.0,            1.0,            0.0,
        0.0,            0.0,            0.0,            1.0};
matrix_3d mtxperspective = {
        1.0,            0.0,            0.0,            0.0,
        0.0,            1.0,            0.0,            0.0,
        0.0,            0.0,            -0.416,        -0.4,
        0.0,            0.0,            156.0,          160.0};
matrix_3d mtxx, mtxy, mtxz;

main(argc,argv)
int argc;
char **argv;

	{
	int j;
	int cplns = 0x3f;
	char *filename;
	int planesmask;
	int pathlength;

	if (argc == 1)  
		{
		fprintf(stderr, "format: rotobj datafile\n");
		exit(1);
		}
	filename = argv[1];
	if (!getenv("WINDOW_ME")) {
		printf("this demo only runs in gp windows\n");
		exit(1);;
	}
	makemaps();
	gfx = gfxsw_init(0,0);
	if(gfx->gfx_pixwin->pw_pixrect->pr_ops->pro_rop != gp1_rop) {
		printf("this demo only runs in gp windows\n");
		exit(1);
	}
	pw_setcmsname(gfx->gfx_pixwin, "\0");
	ioctl( gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd,GP1IO_GET_TRUMINORDEV, &minordev);
	signal(SIGXCPU, SIG_IGN); /* do nothing in this case */
	gp1_attr.statblkindx = gp1_stblk_alloc(gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	gp1_shmem = gp1_d(gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti)->gp_shmem;
	nvecs = readvecs(filename);
	pw_putcolormap(gfx->gfx_pixwin, 0, 4, rmap1, gmap1, bmap1);
	while((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word & 0x80)
		;
	while(!((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word & 0x80))
		;
	pw_writebackground(gfx->gfx_pixwin, 0, 0, 
		gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.x,
		gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.y,
		PIX_SRC);

	initialize_matrices();
Restart:
	planesmask = 0x03;
	pw_putattributes(gfx->gfx_pixwin, &planesmask);

	set_matrix(mtxperspective, 1);
	set_matrix(mtxidentity, 2);
	while (1) {

	    randomize_path();
	    set_matrix(mtxx, 3);
	    set_matrix(mtxy, 4);
	    set_matrix(mtxz, 5);
	    set_rot_matrix();
	    pathlength = 30 + (random()>>10)%40;
	    for (j = 0; j < pathlength; j++) {
		gp1vecs(mtxy, veclist, nvecs, 3, cplns);
	        if(gp1_pw_unlock(gfx->gfx_pixwin))
			goto Restart;
		}
	    }
	}

makemaps() /* make the colormaps */
{
	rmap1[0] = 0;
	gmap1[0] = 0;
	bmap1[0] = 0;
	rmap1[1] = 255;
	gmap1[1] = 0;
	bmap1[1] = 0;
	rmap1[2] = 0;
	gmap1[2] = 0;
	bmap1[2] = 0;
	rmap1[3] = 255;
	gmap1[3] = 0;
	bmap1[3] = 0;

	rmap2[0] = 0;
	gmap2[0] = 0;
	bmap2[0] = 0;
	rmap2[1] = 0;
	gmap2[1] = 0;
	bmap2[1] = 0;
	rmap2[2] = 255;
	gmap2[2] = 0;
	bmap2[2] = 0;
	rmap2[3] = 255;
	gmap2[3] = 0;
	bmap2[3] = 0;
}

readvecs(filename)
char *filename;
	{
	int i, fd;

	if ( (fd = open(filename, O_RDONLY, 0)) == -1) {
		fprintf(stderr, "cannot open data file.\n");
		exit(1);
	}

	i = read(fd, veclist, 16*8400);
	return(i/32);
	}

gp1vecs(matptr, veclist, n, color, cplns)
register matrix_3d *matptr;
register struct point *veclist;
register int n;
int color, cplns;
	{
	register int m;
	unsigned int bitvec;
	register int offset, roomleft;
	register short *shmptr;
	int planesmask;

	planesmask = flipplanes();
	pw_putattributes(gfx->gfx_pixwin, &planesmask);
        gp1_pw_lock(gfx->gfx_pixwin, &gfx->gfx_rect);
	pw_writebackground(gfx->gfx_pixwin, 0, 0, 
		gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.x,
		gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.y,
		PIX_SRC);
	while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
		;
	shmptr = &((short *) gp1_shmem)[offset];
	*shmptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*shmptr++ = GP1_SETCOLOR | color;
	*shmptr++ = GP1_SETFBINDX | 0;
	*shmptr++ = GP1_SETROP;
	*shmptr++ = PIX_SRC;
	*shmptr++ = GP1_SETPIXPLANES | planesmask;
	*shmptr++ = GP1_SETCLIPPLANES | (cplns & 0x3F);
	*shmptr++ = (8 << 8) | 0;
	*shmptr++ = GP1_MATMUL_3D;
	*shmptr++ = 2;
	*shmptr++ = 3;
	*shmptr++ = 2;
	*shmptr++ = GP1_MATMUL_3D;
	*shmptr++ = 2;
	*shmptr++ = 1;
	*shmptr++ = 0;
	*shmptr++ = GP1_EOCL;
	gp1_post(gp1_shmem, offset, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	offset += 17;
	roomleft = 512-17;
	for(;;)
		{
		m = (roomleft - 6) / 12;
		if ((n -= m) < 0)
			m += n;
		*shmptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
		*shmptr++ = GP1_XFVEC_3D;
		*shmptr++ = m;
		while (--m >= 0)
			{
			*((float *) shmptr)++ = *((float *) veclist)++;
			*((float *) shmptr)++ = *((float *) veclist)++;
			*((float *) shmptr)++ = *((float *) veclist)++;
			((float *) veclist)++;
			*((float *) shmptr)++ = *((float *) veclist)++;
			*((float *) shmptr)++ = *((float *) veclist)++;
			*((float *) shmptr)++ = *((float *) veclist)++;
			((float *) veclist)++;
			}
		*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
		*((unsigned int *)shmptr) = bitvec;
		gp1_post(gp1_shmem, offset, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
		if (n > 0)
			{
			while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
				;
			shmptr = &((short *) gp1_shmem)[offset];
			roomleft = 512;
			continue;
			}
		break;
		}
	}

flipplanes() {
	static int flip = 0;
	int plane1 = 1;
	int plane2 = 2;

	flip = 1 - flip;
	if (flip) {
		pw_putcolormap(gfx->gfx_pixwin,0,4,rmap2,gmap2,bmap2);
		while((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word & 0x80)
			;
		while(!((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word & 0x80))
			;
		return(plane1);
	}
	else {
		pw_putcolormap(gfx->gfx_pixwin,0,4,rmap1,gmap1,bmap1);
		while((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word & 0x80)
			;
		while(!((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word & 0x80))
			;
		return(plane2);
	}
}

gp1_pw_lock(pw, r)
struct pixwin *pw;
struct rect *r;
{
	pw_lock(pw, r);
	if (pw->pw_clipdata->pwcd_clipid == gp1_attr.clipid)
		return(0);
	return(gp1_pw_updclplst(pw));
}

gp1_pw_unlock(pw)
struct pixwin *pw;
{
	int retcode;

	retcode = 0;
	pw_unlock(pw);
	if (gfx->gfx_flags & GFX_DAMAGED) {
		gfxsw_handlesigwinch(gfx);
		retcode = 1;
		}
	if (gfx->gfx_flags & GFX_RESTART) {
		gfx->gfx_flags &= ~GFX_RESTART;
		retcode = 1;
		}
	return (retcode);
}
		
gp1_pw_updclplst(pw)
struct pixwin *pw;
{
	unsigned int bitvec;
	short offset, *gp1_addr;
	register short *bufptr, *nptr;
	struct gp1pr *dmd;
	int retcode, x, y, nrect, scalevalue;
	struct pixwin_prlist *prl;

	gp1_attr.clipid = pw->pw_clipdata->pwcd_clipid;
	retcode = 0;
	dmd = gp1_d(pw->pw_pixrect);
	gp1_addr = (short *)dmd->gp_shmem;
	while ((offset = gp1_alloc(gp1_addr, 1, &bitvec, minordev, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0);
	bufptr = &gp1_addr[offset];

	dmd = gp1_d(pw->pw_clipdata->pwcd_prmulti);
	scalevalue = (int)((pw->pw_clipdata->pwcd_prmulti->pr_size.x)/2.0);
	if ( scalevalue > (int)((pw->pw_clipdata->pwcd_prmulti->pr_size.y)/2.0) )
		scalevalue = (int)((pw->pw_clipdata->pwcd_prmulti->pr_size.y)/2.0);
	*bufptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*bufptr++ = GP1_SETVWP_3D;
	*((float *) bufptr)++ = scalevalue;
	*((float *) bufptr)++ = 
		dmd->cgpr_offset.x+(pw->pw_clipdata->pwcd_prmulti->pr_size.x)/2;
	*((float *) bufptr)++ = scalevalue;
	*((float *) bufptr)++ = 
		dmd->cgpr_offset.y+(pw->pw_clipdata->pwcd_prmulti->pr_size.y)/2;
	*((float *) bufptr)++ = 0;
	*((float *) bufptr)++ = 0;

	*bufptr++ = GP1_SETCLPLST;
	nptr = bufptr++;

	if (pw->pw_clipdata->pwcd_state == PWCD_NULL)
		{
		*nptr = 1;
		*bufptr++ = 0;
		*bufptr++ = 0;
		*bufptr++ = 0;
		*bufptr++ = 0;
		}
	else {
		nrect = 0;
		dmd = gp1_d(pw->pw_clipdata->pwcd_prmulti);
		x = dmd->cgpr_offset.x;
		y = dmd->cgpr_offset.y;
		if (x != gp1_attr.org_x | y != gp1_attr.org_x)
			{
			gp1_attr.org_x = x;
			gp1_attr.org_y = y;
			retcode = 1;
			}
		for (prl = pw->pw_clipdata->pwcd_prl; prl; prl = prl->prl_next)
			{
			dmd = gp1_d(prl->prl_pixrect);
			*bufptr++ = dmd->cgpr_offset.x;
			*bufptr++ = dmd->cgpr_offset.y;
			*bufptr++ = prl->prl_pixrect->pr_size.x;
			*bufptr++ = prl->prl_pixrect->pr_size.y;
			if (++nrect == 60)
				break;
			}
			*nptr = nrect;
		}
	*bufptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)bufptr) = bitvec;
	gp1_post(gp1_addr, offset, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	return(retcode);
}
sigxcpu_catcher() {
	/* do nothing ... continue to run */
}

int gp1_stblk_alloc(fd)
int fd;
        {
        int i;
 
        if( ioctl(fd, GP1IO_GET_STATIC_BLOCK, &i) )
                return (-1);
        else
                return(i);
        }
 
set_matrix(matptr, n)
	register matrix_3d *matptr;
	register int n;
{
	register int m;
	unsigned int bitvec;
	register int offset;
	register short *shmptr;

	while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
		;
	shmptr = &((short *) gp1_shmem)[offset];
	*shmptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*shmptr++ = GP1_SET_MATRIX_3D | n;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)shmptr) = bitvec;
	gp1_post(gp1_shmem, offset, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
} /* end of set_matrix() */

randomize_path()
{
	double x, y, z;
	double pi = 3.14159265358;
	float sinx, cosx, siny, cosy, sinz, cosz; 
	double l;

	x = (-50 + (random()>>10)%100)/50.0;
	y = (-50 + (random()>>10)%100)/50.0;
	z = (-50 + (random()>>10)%100)/50.0;

	l = sqrt(x*x + y*y + z*z);

	x = x/l * pi / 15.0;
	y = y/l * pi / 15.0;
	z = z/l * pi / 15.0;

	sinx = sin(x);
	cosx = cos(x);
	siny = sin(y);
	cosy = cos(y);
	sinz = sin(z);
	cosz = cos(z);

	mtxx[1][1] = cosx;
	mtxx[2][2] = cosx;
	mtxx[1][2] = sinx;
	mtxx[2][1] = -sinx;

	mtxy[0][0] = cosy;
	mtxy[2][2] = cosy;
	mtxy[0][2] = -siny;
	mtxy[2][0] = siny;

	mtxz[0][0] = cosz;
	mtxz[1][1] = cosz;
	mtxz[0][1] = sinz;
	mtxz[1][0] = -sinz;

} /* end of randomize_path() */


initialize_matrices()
{
	int i, j;

	for (i=0; i<4; i++) {
		for (j=0; j<4; j++) {
			if (i==j) {
				mtxx[i][j] = 1.0;
				mtxy[i][j] = 1.0;
				mtxz[i][j] = 1.0;
			} else {
				mtxx[i][j] = 0.0;
				mtxy[i][j] = 0.0;
				mtxz[i][j] = 0.0;
			}
		}
	}

	srandom(getpid());
				
} /* end of initialize_matrices() */

set_rot_matrix()
{
	register int m;
	unsigned int bitvec;
	register int offset;
	register short *shmptr;

	while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
		;
	shmptr = &((short *) gp1_shmem)[offset];
	*shmptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*shmptr++ = GP1_MATMUL_3D;
	*shmptr++ = 3;
	*shmptr++ = 4;
	*shmptr++ = 3;
	*shmptr++ = GP1_MATMUL_3D;
	*shmptr++ = 3;
	*shmptr++ = 5;
	*shmptr++ = 3;
	*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)shmptr) = bitvec;
	gp1_post(gp1_shmem, offset, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
} /* end of set_rot_matrix() */
