/*	@(#)flight_dat.h 1.2 86/10/07 SMI	*/

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

struct point b5southwall[] = { {0.0,0.0,100.0,0.},{0.0,30.0,100.0,1.0},
	{120.0,30.0,100.0,1.0}, {120.0, 0.0, 100.0, 1.0}};
struct point b5eastwall[] =     { {120.0,0.0,100.0,1.0},{120.0,30.0,100.0,1.0},
	{120.0, 30.0, -80.0, 1.0}, {120.0, 0.0, -80.0, 1.0}};
struct point b5northwall[] =    { {120.0,0.0,-80.0,1.0},{120.0,30.0,-80.0,1.0},
	{60.0,30.0,-80.0,1.0}, {60.0,0.0,-80.0,1.0}};
struct point b5westpondwall[] = { {60.0,0.0,-80.0,1.0}, {60.0,30.0,-80.0,1.0},
	{60.0,30.0,40.0,1.0}, {60.0,0.0,40.0,1.0}};
struct point b5northpondwall[] = { {22.5,0.0,40.0,1.0}, {60.0,30.0,40.0,1.0},
	{0.0,30.0,40.0,1.0}, {0.0,0.0,40.0,1.0}};
struct point b5piecewall[] = { {60.0,30.0,40.0,1.0}, {22.5,0.0,40.0,1.0},
	{60.0,0.0,40.0,1.0}};
struct point b5pwvecs[] = { {60.0,30.0,40.0,1.0}, {60.0,0.0,40.0,1.0},
	{22.5,0.0,40.0,1.0}, {60.0,0.0,40.0,1.0}};
struct point b5npwvecs[] = { {22.5,0.0,40.0,1.0}, {0.0,0.0,40.0,1.0},
	{0.0,30.0,40.0,1.0}, {0.0,0.0,40.0,1.0}};
struct point b5westwall[] = { {0.0,0.0,40.0,1.0}, {0.0,30.0,40.0,1.0},
	{0.0,30.0,100.0,1.0}, {0.0,0.0,100.0,1.0}};
struct point b5southroof[] = { {-5.0,26.0,105.0,1.0}, {20.0,46.0,80.0,1.0},
	{100.0,46.0,80.0,1.0}, {125.0,26.0,105.0,1.0}};
struct point b5eastroof[] = { {125.0,26.0,105.0,1.0}, {100.0,46.0,80.0,1.0},
	{100.0,46.0,-60.0,1.0}, {125.0,26.0,-85.0,1.0}};
struct point b5northroof[] = { {125.0,26.0,-85.0,1.0}, {100.0,46.0,-60.0,1.0},
	{80.0,46.0,-60.0,1.0}, {55.0,26.0,-85.0,1.0}};
struct point b5westpondroof[] = { {55.0,26.0,-85.0,1.0}, {80.0,46.0,-60.0,1.0},
	{80.0,46.0,60.0,1.0}, {55.0,26.0,35.0,1.0}};
struct point b5northpondroof[] = { {55.0,26.0,35.0,1.0}, {80.0,46.0,60.0,1.0},
	{20.0,46.0,60.0,1.0}, {-5.0,26.0,35.0,1.0}};
struct point b5westroof[] = { {-5.0,26.0,35.0,1.0}, {20.0,46.0,60.0,1.0},
	{20.0,46.0,80.0,1.0}, {-5.0,26.0,105.0,1.0}};
struct point b5toproof[] = { {20.0,46.0,80.0,1.0}, {100.0,46.0,80.0,1.0},
	{100.0,46.0,-60.0,1.0}, {80.0,46.0,-60.0,1.0}, {80.0,46.0,60.0,1.0},
	{20.0,46.0,60.0,1.0}};

struct point b1northwall[] = { {-10.0,0.0,-100.0,1.0}, {-10.0,30.0,-100.0,1.0},
	{-130.0,30.0,-100.0,1.0}, {-130.0, 0.0, -100.0, 1.0}};
struct point b1westwall[] =  { {-130.0,0.0,-100.0,1.0},{-130.0,30.0,-100.0,1.0},
	{-130.0, 30.0, 80.0, 1.0}, {-130.0, 0.0, 80.0, 1.0}};
struct point b1southwall[] = { {-130.0,0.0,80.0,1.0},{-130.0,30.0,80.0,1.0},
	{-70.0,30.0,80.0,1.0}, {-70.0,0.0,80.0,1.0}};
struct point b1eastpondwall[] = { {-70.0,0.0,80.0,1.0}, {-70.0,30.0,80.0,1.0},
	{-70.0,30.0,-40.0,1.0}, {-70.0,0.0,-40.0,1.0}};
struct point b1southpondwall[] = { {-32.5,0.0,-40.0,1.0},{-70.0,30.0,-40.0,1.0},
	{-10.0,30.0,-40.0,1.0}, {-10.0,0.0,-40.0,1.0}};
struct point b1piecewall[] = { {-70.0,0.0,-40.0,1.0}, {-70.0,30.0,-40.0,1.0},
	{-32.5,0.0,-40.0,1.0}};
struct point b1pwvecs[] = { {-70.0,30.0,-40.0,1.0},{-70.0,0.0,-40.0,1.0},
	{-32.5,0.0,-40.0,1.0}, {-70.0,0.0,-40.0,1.0}};
struct point b1spwvecs[] = { {-10.0,30.0,-40.0,1.0},{-10.0,0.0,-40.0,1.0},
	{-32.5,0.0,-40.0,1.0}, {-10.0,0.0,-40.0,1.0}};
struct point b1eastwall[] = { {-10.0,0.0,-40.0,1.0}, {-10.0,30.0,-40.0,1.0},
	{-10.0,30.0,-100.0,1.0}, {-10.0,0.0,-100.0,1.0}};
struct point b1northroof[] = { {-5.0,26.0,-105.0,1.0}, {-30.0,46.0,-80.0,1.0},
	{-110.0,46.0,-80.0,1.0}, {-135.0,26.0,-105.0,1.0}};
struct point b1westroof[] = { {-135.0,26.0,-105.0,1.0}, {-110.0,46.0,-80.0,1.0},
	{-110.0,46.0,60.0,1.0}, {-135.0,26.0,85.0,1.0}};
struct point b1southroof[] = { {-135.0,26.0,85.0,1.0}, {-110.0,46.0,60.0,1.0},
	{-90.0,46.0,60.0,1.0}, {-65.0,26.0,85.0,1.0}};
struct point b1eastpondroof[] = { {-65.0,26.0,85.0,1.0}, {-90.0,46.0,60.0,1.0},
	{-90.0,46.0,-60.0,1.0}, {-65.0,26.0,-35.0,1.0}};
struct point b1southpondroof[] = {{-65.0,26.0,-35.0,1.0},{-90.0,46.0,-60.0,1.0},
	{-30.0,46.0,-60.0,1.0}, {-5.0,26.0,-35.0,1.0}};
struct point b1eastroof[] = { {-5.0,26.0,-35.0,1.0}, {-30.0,46.0,-60.0,1.0},
	{-30.0,46.0,-80.0,1.0}, {-5.0,26.0,-105.0,1.0}};
struct point b1toproof[] = { {-30.0,46.0,-80.0,1.0}, {-30.0,46.0,-60.0,1.0},
	{-90.0,46.0,-60.0,1.0}, {-90.0,46.0,60.0,1.0}, {-110.0,46.0,60.0,1.0},
	{-110.0,46.0,-80.0,1.0}};

struct point pond1[] = { {-2.0,0.0,-7.0,1.0}, {15.0,0.0,-20.0,1.0},
	{20.0,0.0,-35.0,1.0}, {25.0,0.0,-44.0,1.0}, {32.0,0.0,-45.0,1.0},
	{30.0,0.0,-50.0,1.0}, {33.0,0.0,-57.0,1.0}, {40.0,0.0,-60.0,1.0},
	{47.0,0.0,-57.0,1.0}, {50.0,0.0,-50.0,1.0}, {47.0,0.0,-43.0,1.0},
	{40.0,0.0,-40.0,1.0}, {35.0,0.0,-42.0,1.0}, {35.0,0.0,-34.0,1.0},
	{30.0,0.0,-25.0,1.0}, {20.0,0.0,-20.0,1.0}, {20.0,0.0,-15.0,1.0},
	{25.0,0.0,-10.0,1.0}, {30.0,0.0,-10.0,1.0}, {35.0,0.0,-5.0,1.0},
	{35.0,0.0,0.0,1.0}, {40.0,0.0,0.0,1.0}, {47.0,0.0,3.0,1.0},
	{50.0,0.0,10.0,1.0}, {47.0,0.0,17.0,1.0}, {40.0,0.0,20.0,1.0},
	{33.0,0.0,17.0,1.0}, {30.0,0.0,10.0,1.0}, {30.0,0.0,5.0,1.0},
	{25.0,0.0,5.0,1.0}, {20.0,0.0,0.0,1.0}, {20.0,0.0,-5.0,1.0},
	{15.0,0.0,-10.0,1.0}, {2.0,0.0,-3.0,1.0}};
struct point pond2[] = { {-3.0,0.0,2.0,1.0}, {-10.0,0.0,15.0,1.0},
	{-25.0,0.0,30.0,1.0}, {-40.0,0.0,37.0,1.0}, {-40.0,0.0,45.0,1.0},
	{-42.0,0.0,53.0,1.0}, {-50.0,0.0,55.0,1.0}, {-58.0,0.0,53.0,1.0},
	{-60.0,0.0,45.0,1.0}, {-58.0,0.0,37.0,1.0}, {-50.0,0.0,35.0,1.0},
	{-42.0,0.0,35.0,1.0}, {-40.0,0.0,30.0,1.0}, {-40.0,0.0,20.0,1.0},
	{-30.0,0.0,10.0,1.0}, {-40.0,0.0,10.0,1.0}, {-45.0,0.0,5.0,1.0},
	{-45.0,0.0,-2.0,1.0}, {-50.0,0.0,0.0,1.0}, {-57.0,0.0,-3.0,1.0},
	{-60.0,0.0,-10.0,1.0}, {-57.0,0.0,-17.0,1.0}, {-50.0,0.0,-20.0,1.0},
	{-43.0,0.0,-17.0,1.0}, {-40.0,0.0,-10.0,1.0}, {-42.0,0.0,-5.0,1.0},
	{-35.0,0.0,-5.0,1.0}, {-30.0,0.0,0.0,1.0}, {-30.0,0.0,5.0,1.0},
	{-25.0,0.0,7.0,1.0}, {-7.0,0.0,-2.0,1.0}};
struct point walk1[] = { {60.0,0.0,35.0,1.0}, {50.0,0.0,35.0,1.0},
	{30.0,0.0,30.0,1.0}, {20.0,0.0,25.0,1.0}, {9.0,0.0,14.0,1.0},
	{2.0,0.0,17.0,1.0}, {-12.0,0.0,35.0,1.0}, {-22.0,0.0,55.0,1.0},
	{-25.0,0.0,80.0,1.0}, {-25.0,0.0,110.0,1.0}, {-30.0,0.0,110.0,1.0},
	{-30.0,0.0,80.0,1.0}, {-27.0,0.0,55.0,1.0}, {-18.0,0.0,35.0,1.0},
	{-2.0,0.0,14.0,1.0}, {3.0,0.0,6.0,1.0}, {1.0,0.0,4.0,1.0},
	{4.0,0.0,1.0,1.0}, {20.0,0.0,19.0,1.0}, {30.0,0.0,25.0,1.0},
	{50.0,0.0,30.0,1.0}, {60.0,0.0,30.0,1.0}};
struct point walk2[] = { {30.0,0.0,-110.0,1.0}, {30.0,0.0,-80.0,1.0},
	{25.0,0.0,-55.0,1.0}, {12.0,0.0,-34.0,1.0}, {-3.0,0.0,-20.0,1.0},
	{-8.0,0.0,-11.0,1.0}, {-6.0,0.0,-9.0,1.0}, {-9.0,0.0,-6.0,1.0},
	{-20.0,0.0,-15.0,1.0}, {-40.0,0.0,-25.0,1.0}, {-60.0,0.0,-30.0,1.0},
	{-70.0,0.0,-30.0,1.0}, {-70.0,0.0,-35.0,1.0}, {-60.0,0.0,-35.0,1.0},
	{-40.0,0.0,-30.0,1.0}, {-20.0,0.0,-21.0,1.0}, {-16.0,0.0,-18.0,1.0},
	{-10.0,0.0,-20.0,1.0}, {6.0,0.0,-34.0,1.0}, {20.0,0.0,-55.0,1.0},
	{25.0,0.0,-80.0,1.0}, {25.0,0.0,-110.0,1.0}};
struct point bridge[] = { {0.0,0.0,5.0,1.0}, {-10.0,0.0,-5.0,1.0},
	{-5.0,0.0,-10.0,1.0}, {5.0,0.0,0.0,1.0}};
struct point sfbay[] = { {-3000.0,0.0,6800.0,1.0}, {-5000.0,0.0,4000.0,1.0},
	{-5200.0,0.0,3200.0,1.0}, {-4800.0,0.0,1200.0,1.0},
	{-5200.0,0.0,1200.0,1.0}, {-6200.0,0.0,-2000.0,1.0},
	{-5600.0,0.0,-4000.0,1.0}, {-5600.0,0.0,-6800.0,1.0},
	{-4000.0,0.0,-7200.0,1.0}, {-3600.0,0.0,-5400.0,1.0},
	{-3800.0,0.0,-3800.0,1.0}, {-2200.0,0.0,-2600.0,1.0},
	{-600.0,0.0,-1200.0,1.0}, {0.0,0.0,-200.0,1.0},
	{800.0,0.0,-200.0,1.0}, {400.0,0.0,-1000.0,1.0},
	{-200.0,0.0,-1200.0,1.0}, {-800.0,0.0,-4200.0,1.0},
	{-2200.0,0.0,-6200.0,1.0}, {-3000.0,0.0,-6600.0,1.0},
	{-2600.0,0.0,-8600.0,1.0}, {-4200.0,0.0,-10000.0,1.0},
	{-3200.0,0.0,-10400.0,1.0}, {-2200.0,0.0,-11200.0,1.0},
	{5600.0,0.0,-11200.0,1.0}, {5600.0,0.0,6800.0,1.0}};
struct point marin[] = { {-5000.0,0.0,-11200.0,1.0}, {-4400.0,0.0,-10600.0,1.0},
	{-5000.0,0.0,-10200.0,1.0}, {-5000.0,0.0,-9400.0,1.0},
	{-4400.0,0.0,-8400.0,1.0}, {-4800.0,0.0,-8200.0,1.0},
	{-5400.0,0.0,-8600.0,1.0}, {-5000.0,0.0,-7600.0,1.0},
	{-5800.0,0.0,-7600.0,1.0}, {-7400.0,0.0,-9200.0,1.0},
	{-8200.0,0.0,-11200.0,1.0}};
struct point boat[] = { {-980.0,0.0,-2800.0,1.0}, {-1020.0,0.0,-2800.0,1.0},
	{-1050.0,5.0,-2800.0,1.0}, {-960.0,5.0,-2800.0,1.0}};
struct point mast[] = { {-1007.0,5.0,-2800.0,1.0}, {-1005.0,55.0,-2800.0,1.0},
	{-1003.0,5.0,-2800.0,1.0}};
struct point jib[] = { {-1045.0,7.0,-2800.0,1.0}, {-1007.0,50.0,-2800.0,1.0},
	{-1010.0,7.0,-2800.0,1.0}};
struct point sail[] = { {-1000.0,7.0,-2800.0,1.0}, {-1003.0,53.0,-2800.0,1.0},
	{-965.0,7.0,-2800.0,1.0}};
struct point parking[] = { {-160.0,0.0,120.0,1.0}, {-160.0,0.0,-120.0,1.0},
	{150.0,0.0,-120.0,1.0}, {150.0,0.0,120.0,1.0},
	{-150.0,0.0,110.0,1.0}, {-150.0,0.0,-110.0,1.0},
	{140.0,0.0,-110.0,1.0}, {140.0,0.0,110.0,1.0}
	};

#define	TOPCOL		1 | (1<<3)	/* colors */
#define	WOODCOL		1 | (1<<3)
#define	GRASSCOL	2 | (2<<3)
#define	PONDCOL		3 | (3<<3)
#define	SAILCOL		4 | (4<<3)
#define	PARKCOL		5 | (5<<3)
#define	WALLCOL		6 | (6<<3)
#define	ROOFCOL		7 | (7<<3)
#define	WALKCOL		7 | (7<<3)
#define	BOATCOL		7 | (7<<3)

short nb1tr[] = {6}; short nb5tr[] = {6}; /* boundary counts for polys */
short nsfbay[] = {26}; short nmarin[] = {11};
short npond1[] = {34}; short npond2[] = {31};
short nwalk1[] = {22}; short nwalk2[] = {22};
short nquad[] ={4}; short ntri[] ={3}; 
short npark[] = {4,4};

struct poly polylist[] = {
	{TOPCOL,1,nb1tr,b1toproof}, {TOPCOL,1,nb1tr,b5toproof},
	{GRASSCOL,1,nsfbay,sfbay},{GRASSCOL,1,nmarin,marin},
	{PONDCOL,1,npond1,pond1}, {PONDCOL,1,npond2,pond2},
	{WALKCOL,1,nwalk1,walk1}, {WALKCOL,1,nwalk2,walk2},
	{WOODCOL,1,nquad,bridge}, {PARKCOL,2,npark,parking},
	{BOATCOL,1,nquad,boat}, {WOODCOL,1,ntri,mast},
	{SAILCOL,1,ntri,jib}, {SAILCOL,1,ntri,sail},
	{ROOFCOL,1,nquad,b5southroof},     {ROOFCOL,1,nquad,b5eastroof},
	{ROOFCOL,1,nquad,b1westroof},      {ROOFCOL,1,nquad,b1northroof},
	{WALLCOL,1,nquad,b5southwall},     {WALLCOL,1,nquad,b5eastwall},
	{WALLCOL,1,nquad,b1westwall},      {WALLCOL,1,nquad,b1northwall},
	{ROOFCOL,1,nquad,b5westpondroof},  {ROOFCOL,1,nquad,b5northroof},
	{WALLCOL,1,nquad,b5westpondwall},  {WALLCOL,1,nquad,b5northwall},
	{WALLCOL,1,ntri,b5piecewall},      {ROOFCOL,1,nquad,b1eastpondroof},
	{ROOFCOL,1,nquad,b1southroof},     {WALLCOL,1,nquad,b1eastpondwall},
	{WALLCOL,1,nquad,b1southwall},     {WALLCOL,1,ntri,b1piecewall},
	{ROOFCOL,1,nquad,b5northpondroof}, {ROOFCOL,1,nquad,b5westroof},
	{WALLCOL,1,nquad,b5northpondwall}, {WALLCOL,1,nquad,b5westwall},
	{ROOFCOL,1,nquad,b1southpondroof}, {ROOFCOL,1,nquad,b1eastroof},
	{WALLCOL,1,nquad,b1southpondwall}, {WALLCOL,1,nquad,b1eastwall}
	};

/* fix the split wall so vectors fit well */
struct poly b5pwfix = {WALLCOL,1,nquad,b5pwvecs};	/* face 14 */
struct poly b5npwfix = {WALLCOL,1,nquad,b5npwvecs};	/* face 22 */
struct poly b1pwfix = {WALLCOL,1,nquad,b1pwvecs};	/* face 19 */
struct poly b1spwfix = {WALLCOL,1,nquad,b1spwvecs};	/* face 26 */
/* Here are the windows */

struct face faces[] = {
	{0,2},  {2,12},  {14,1},  {15,1}, {16,1}, {17,1}, {18,1}, {19,1},
	{20,1}, {21,1}, {22,1}, {23,1}, {24,1}, {25,1}, {26,1}, {27,1},
	{28,1}, {29,1}, {30,1}, {31,1}, {32,1}, {33,1}, {34,1}, {35,1},
	{36,1}, {37,1}, {38,1}, {39,1}
	};

struct bspnode bsptree[] = {
	{0, {0.0, 1.0, 0.0,-46.0} ,0,&bsptree[1]},	/* rooftops */
	{1, {0.0, 1.0, 0.0,  0.0} ,&bsptree[2],0},	/* ground */
	{2, {0.0, 5.0, 4.0,-550.0} ,0,&bsptree[3]},	/* b5sr */
	{3, {4.0, 5.0, 0.0,-630.0} ,0,&bsptree[4]},	/* b5er */
	{4, {-4.0, 5.0, 0.0,-670.0} ,0,&bsptree[5]},	/* b1wr */
	{5, {0.0, 5.0, -4.0,-550.0} ,0,&bsptree[6]},	/* b1nr */
	{6, {0.0, 0.0, 1.0,-100.0} ,0,&bsptree[7]},	/* b5sw */
	{7, {1.0, 0.0, 0.0,-120.0} ,0,&bsptree[8]},	/* b5ew */
	{8, {-1.0, 0.0, 0.0,-130.0} ,0,&bsptree[9]},	/* b1ww */
	{9, {0.0, 0.0, -1.0,-100.0} ,0,&bsptree[10]},	/* b1nw */
	{10, {-4.0, 5.0, 0.0,90.0} ,&bsptree[15],&bsptree[11]},	/* b5wpr */
	{11, {0.0, 5.0, -4.0,-470.0} ,0,&bsptree[12]},	/* b5nr */
	{12, {-1.0, 0.0, 0.0,60.0} ,&bsptree[14],&bsptree[13]},	/* b5wpw */
	{13, {0.0, 0.0, -1.0,-80.0} ,0,0},		/* b5nw */
	{14, {0.0, 0.0, -1.0,40.0} ,0,0},		/* b5pw */
	{15, {4.0, 5.0, 0.0,130.0} ,&bsptree[20],&bsptree[16]},	/* b1epr */
	{16, {0.0, 5.0, 4.0,-470.0} ,0,&bsptree[17]},	/* b1sr */
	{17, {1.0, 0.0, 0.0,70.0} ,&bsptree[19],&bsptree[18]},	/* b1epw */
	{18, {0.0, 0.0, 1.0,-80.0} ,0,0},		/* b1sw */
	{19, {0.0, 0.0, 1.0,40.0} ,0,0},		/* b1pw */
	{20, {0.0, 5.0, -4.0,10.0} ,&bsptree[24],&bsptree[21]},	/* b5npr */
	{21, {-4.0, 5.0, 0.0,-150.0} ,0,&bsptree[22]},	/* b5wr */
	{22, {0.0, 0.0, -1.0,40.0} ,0,&bsptree[23]},	/* b5npw */
	{23, {-1.0, 0.0, 0.0,0.0} ,0,0},		/* b5ww */
	{24, {0.0, 5.0, 4.0,10.0} ,0,&bsptree[25]},	/* b1spr */
	{25, {4.0, 5.0, 0.0,-110.0} ,0,&bsptree[26]},	/* b1er */
	{26, {0.0, 0.0, 1.0,40.0} ,0,&bsptree[27]},	/* b1spw */
	{27, {1.0, 0.0, 0.0,10.0} ,0,0}			/* b1ew */
	};
