#ifndef lint
static	char sccsid[] = "@(#)flight.c 1.2 86/10/07 Copyr 1986 Sun Micro";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/* 
 * this program uses the (as yet) undocumented command level interface
 * for the graphics procesor ... the user is currently advised against 
 * using the command interface until he has documentation. 
 */ 

#include <fcntl.h>
#include <pixrect/pixrect_hs.h>
#include <pixrect/memreg.h>
#include <pixrect/cg2reg.h>
#include <sunwindow/window_hs.h>
#include <suntool/gfxsw.h>
#include <math.h>
#include <stdio.h>
#include <pixrect/gp1cmds.h>
#include <sys/signal.h>
#include <sys/ioctl.h>
#include <sun/gpio.h>

#define CMAPSIZE	64

static unsigned char rmap1[CMAPSIZE], gmap1[CMAPSIZE], bmap1[CMAPSIZE];
static unsigned char rmap2[CMAPSIZE], gmap2[CMAPSIZE], bmap2[CMAPSIZE];
static caddr_t gp1_shmem;
static struct pixrect;
static struct gfxsubwindow *gfx;
static char minordev;

int gp1_rop();
int sigxcpu_catcher();

struct gp1_attr
        {
        short attrchg;
        int attrcnt, clpcnt;
        int clipid;
        int org_x, org_y;
        int statblkindx;
        short fbindx;
        float xscale, xoffset, yscale, yoffset;
        short op, color, pixplanes;
	};
  
static struct gp1_attr gp1_attr;

struct point {					/* vertices */
	float x, y, z, w;
	};

struct poly {					/* polygons */
	short color;
	short nbnds;
	short *npts;
	struct point *vtx;
	};

struct face {					/* faces */
	short start, n;
	};
struct plane_eqn {
	float a,b,c,d;	/* see J.Blinn */
	};
struct bspnode {				/* bsptree */
	short bsp_face;	/* index to face */
	struct plane_eqn bsp_eqn;
	struct bspnode *bsp_front;
	struct bspnode *bsp_back;
	};

#include "flight_dat.h"

struct viewerpos {		/* position and velocity of viewer */
	float px,py,pz;
	float wx,wy,wz;
	float vx,vy,vz;
	} viewer = {0.0,0.0,400.0,  0.0,0.0,0.0,  0.0,0.0,0.0};

struct matrix_3d {
	float m[4][4];
	};
struct matrix_3d model, invmodel;
struct matrix_3d identity = {
	1.0, 0.0, 0.0, 0.0,
	0.0, 1.0, 0.0, 0.0,
	0.0, 0.0, 1.0, 0.0,
	0.0, 0.0, 0.0, 1.0
	};
struct matrix_3d viewmtx = {
	1.0, 0.0, 0.0, 0.0,
	0.0, -1.0, 0.0, 0.0,
	0.0, 0.0, -0.4, -0.4,
	0.0, 0.0, 158.0, 160.0
	};
struct matrix_3d roty[] = {		/* rotate about y axis */
	{ {0.999390827, 0.0, -0.034899496, 0.0},	/* -2 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {0.034899496, 0.0, 0.999390827, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999847695, 0.0, -0.017452406, 0.0},	/* -1 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {0.017452406, 0.0, 0.999847695, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999961923, 0.0, -0.008726535, 0.0},	/* -0.5 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {0.008726535, 0.0, 0.999961923, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999993907, 0.0, -0.003490651, 0.0},	/* -0.2 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {0.003490651, 0.0, 0.999993907, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.0,},},				/*  0 degrees (unused) */
	{ {0.999993907, 0.0, 0.003490651, 0.0},		/* 0.2 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {-0.003490651, 0.0, 0.999993907, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999961923, 0.0, 0.008726535, 0.0},		/* 0.5 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {-0.008726535, 0.0, 0.999961923, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999847695, 0.0, 0.017452406, 0.0},		/* 1 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {-0.017452406, 0.0, 0.999847695, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999390827, 0.0, 0.034899496, 0.0},		/* 2 degrees */
	  {0.0, 1.0, 0.0, 0.0},
	  {-0.034899496, 0.0, 0.999390827, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	};
struct matrix_3d rotz[] = {		/* rotate about z axis */
	{ {0.999390827, -0.034899496, 0.0, 0.0},	/* -2 degrees */
	  {0.034899496, 0.999390827, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999847695, -0.017452406, 0.0, 0.0},	/* -1 degrees */
	  {0.017452406, 0.999847695, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999961923, -0.008726535, 0.0, 0.0},	/* -0.5 degrees */
	  {0.008726535, 0.999961923, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999993907, -0.003490651, 0.0, 0.0},	/* -0.2 degrees */
	  {0.003490651, 0.999993907, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.0,},},				/*  0 degrees (unused) */
	{ {0.999993907, 0.003490651, 0.0, 0.0},		/* 0.2 degrees */
	  {-0.003490651, 0.999993907, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999961923, 0.008726535, 0.0, 0.0},		/* 0.5 degrees */
	  {-0.008726535, 0.999961923, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999847695, 0.017452406, 0.0, 0.0},		/* 1 degrees */
	  {-0.017452406, 0.999847695, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.999390827, 0.034899496, 0.0, 0.0},		/* 2 degrees */
	  {-0.034899496, 0.999390827, 0.0, 0.0},
	  {0.0, 0.0, 1.0, 0.0},
	  {0.0, 0.0, 0.0, 1.0} }
	 };
struct matrix_3d rotx[] = {		/* rotate about x axis */
	{ {1.0, 0.0, 0.0, 0.0},				/* -2 degrees */
	  {0.0, 0.999390827, 0.034899496, 0.0},
	  {0.0, -0.034899496, 0.999390827, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {1.0, 0.0, 0.0, 0.0},				/* -1 degrees */
	  {0.0, 0.999847695, 0.017452406, 0.0},
	  {0.0, -0.017452406, 0.999847695, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {1.0, 0.0, 0.0, 0.0},				/* -0.5 degrees */
	  {0.0, 0.999961923, 0.008726535, 0.0},
	  {0.0, -0.008726535, 0.999961923, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {1.0, 0.0, 0.0, 0.0},				/* -0.2 degrees */
	  {0.0, 0.999993907, 0.003490651, 0.0},
	  {0.0, -0.003490651, 0.999993907, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {0.0,},},				/*  0 degrees (unused) */
	{ {1.0, 0.0, 0.0, 0.0},				/* 0.2 degrees */
	  {0.0, 0.999993907, -0.003490651, 0.0},
	  {0.0, 0.003490651, 0.999993907, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {1.0, 0.0, 0.0, 0.0},				/* 0.5 degrees */
	  {0.0, 0.999961923, -0.008726535, 0.0},
	  {0.0, 0.008726535, 0.999961923, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {1.0, 0.0, 0.0, 0.0},				/* 1 degrees */
	  {0.0, 0.999847695, -0.017452406, 0.0},
	  {0.0, 0.017452406, 0.999847695, 0.0},
	  {0.0, 0.0, 0.0, 1.0} },
	{ {1.0, 0.0, 0.0, 0.0},				/* 2 degrees */
	  {0.0, 0.999390827, -0.034899496, 0.0},
	  {0.0, 0.034899496, 0.999390827, 0.0},
	  {0.0, 0.0, 0.0, 1.0} }
	};

struct rect viewrect;
mpr_static( cursorpr, 0,0,1, 0);
struct cursor cursor = {0,0,0,&cursorpr};

main(argc,argv)
int argc;
char **argv;

	{
	int j,k;
	int cplns = 0x3e;	/* clip planes bits 0..5 = FNTBRL */
	int planesmask, pmask;
	struct matrix_3d matrix;
	struct inputmask mask;

	if (!getenv("WINDOW_ME")) {
		printf("this demo only runs in gp windows\n");
		exit(1);;
	}
	makemaps();
	gfx = gfxsw_init(0,0);
	if(gfx->gfx_pixwin->pw_pixrect->pr_ops->pro_rop != gp1_rop) {
		printf("this demo only runs in gp windows\n");
		exit(1);
	}
	pw_setcmsname(gfx->gfx_pixwin, "\0");
	ioctl( gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd,
	    GP1IO_GET_TRUMINORDEV, &minordev);
	signal(SIGXCPU, SIG_IGN); /* do nothing in this case */
	gp1_attr.statblkindx =
	    gp1_stblk_alloc(gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	gp1_shmem = gp1_d(gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti)->gp_shmem;
	pw_putcolormap(gfx->gfx_pixwin, 0, CMAPSIZE, rmap1, gmap1, bmap1);
	while((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word &
	    0x80);
	while(!((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->status.word &
	    0x80));
	pw_writebackground(gfx->gfx_pixwin, 0, 0, 
		gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.x,
		gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.y,
		PIX_SRC);
	model = identity; model.m[3][2] = -viewer.pz;
	model.m[3][1] = -80;
	invmodel = identity; invmodel.m[3][2] = viewer.pz;
	invmodel.m[3][1] = 80;

	input_imnull( &mask);			/* initialize input */
	win_setinputcodebit( &mask, MS_LEFT);
	win_setinputcodebit( &mask, MS_MIDDLE);
	win_setinputcodebit( &mask, MS_RIGHT);
	win_setinputcodebit( &mask, LOC_MOVE);
	win_setinputcodebit( &mask, LOC_MOVEWHILEBUTDOWN);
	win_setinputmask( gfx->gfx_windowfd, &mask, (struct inputmask *)NULL,
	    WIN_NULLLINK);
	if ( fcntl( gfx->gfx_windowfd, F_SETFL, FNDELAY) == -1)
		printf("Failed to set non-blocking I/O\n");
	win_setcursor( gfx->gfx_windowfd, &cursor);

Restart:
	gp1_stblk_init();
	planesmask = 0x3F;
	pw_putattributes(gfx->gfx_pixwin, &planesmask);
	win_getrect( gfx->gfx_windowfd, &viewrect);

	while (1) {
		pmask = flipplanes();
		pw_putattributes(gfx->gfx_pixwin, &pmask);
		pw_writebackground(gfx->gfx_pixwin, 0, 0, 
		    gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.x,
		    gfx->gfx_pixwin->pw_clipdata->pwcd_prmulti->pr_size.y,
		    PIX_SRC);
		sample_controls( &viewer, &matrix);
		gp1_pw_lock(gfx->gfx_pixwin, &gfx->gfx_rect);
		load_matrix( matrix.m);
		bsp_traverse( &viewer, bsptree, cplns, pmask);
		if(gp1_pw_unlock(gfx->gfx_pixwin))
			goto Restart;
		}
	}

sample_controls( vwp, mat)
	struct viewerpos *vwp;
	struct matrix_3d *mat;
{
	struct inputevent ie;
	static short dx, dy, lastx, lasty, roll = 0;
	struct matrix_3d m1, m2;

	/* sample the mouse movements */
	dx = dy = 0;
	while (input_readevent( gfx->gfx_windowfd, &ie) != -1) {
	    switch (ie.ie_code) {
	    	case MS_LEFT:
			viewer.vz += 1;
			break;
	        case MS_MIDDLE:
			model = identity; model.m[3][2] = -viewer.pz;
			model.m[3][1] = -80;
			invmodel = identity; invmodel.m[3][2] = viewer.pz;
			invmodel.m[3][1] = 80;
			viewer.vz = 0;
			break;
	        case MS_RIGHT:
			viewer.vz -= 1;
			break;
	        case LOC_MOVE:
			dx += ie.ie_locx - lastx; dy += ie.ie_locy - lasty;
			roll = 0;
			break;
	        case LOC_MOVEWHILEBUTDOWN:
			dx += ie.ie_locx - lastx; dy += ie.ie_locy - lasty;
			roll = 1;
			break;
		default:;
	    }
	    lastx = ie.ie_locx; lasty = ie.ie_locy;
	}
	dx = dx/2; dy = dy/2;
	dx = (dx>4)?4:((dx<-4)?-4:dx);
	dy = (dy>4)?4:((dy<-4)?-4:dy);

	/*
	 * rotate about x axis for pitch, rotate about z axis for roll
	 */
	if (dx != 0) {
		gp1_matmul_3d( gfx->gfx_pixwin, model.m, rotz[4+dx].m,
			model.m);
		gp1_matmul_3d( gfx->gfx_pixwin, rotz[4-dx].m, invmodel.m,
			invmodel.m);
		if (!roll) {
		    gp1_matmul_3d( gfx->gfx_pixwin, model.m, roty[4-dx].m,
			    model.m);
		    gp1_matmul_3d( gfx->gfx_pixwin, roty[4+dx].m, invmodel.m,
			    invmodel.m);
		}
	}
	if (dy != 0) {
		gp1_matmul_3d( gfx->gfx_pixwin, model.m, rotx[4+dy].m,
			model.m);
		gp1_matmul_3d( gfx->gfx_pixwin, rotx[4-dy].m, invmodel.m,
			invmodel.m);
	}
	/*
	 * translate by our velocity
	 */
	m1 = identity; m1.m[3][2] = -viewer.vz;
	gp1_matmul_3d( gfx->gfx_pixwin, model.m, m1.m, model.m);
	m1.m[3][2] = viewer.vz;
	gp1_matmul_3d( gfx->gfx_pixwin, m1.m, invmodel.m, invmodel.m);
	/*
	 * translate center of projection back out, and add perspective
	 */
	m1.m[3][2] = viewer.pz;
	gp1_matmul_3d( gfx->gfx_pixwin, model.m, m1.m, m2.m);
	gp1_matmul_3d( gfx->gfx_pixwin, m2.m, viewmtx.m, mat->m);

	m1.m[3][2] = -m1.m[3][2];
	gp1_matmul_3d( gfx->gfx_pixwin, m1.m, invmodel.m, m2.m);
	viewer.wx = 400.0 * m2.m[2][0] + m2.m[3][0];
	viewer.wy = 400.0 * m2.m[2][1] + m2.m[3][1];
	viewer.wz = 400.0 * m2.m[2][2] + m2.m[3][2];
}

bsp_traverse( vwp, bsp, cplns, pmask)
	struct viewerpos *vwp;
	struct bspnode *bsp;
	int cplns, pmask;
{
	float dist;

	if ( bsp == 0) return;

	dist = bsp->bsp_eqn.a * vwp->wx + bsp->bsp_eqn.b * vwp->wy +
	       bsp->bsp_eqn.c * vwp->wz + bsp->bsp_eqn.d;
	if ( dist < 0.0) {		/* if viewer is in back of face */
		bsp_traverse( vwp, bsp->bsp_front, cplns, pmask);
		bsp_traverse( vwp, bsp->bsp_back, cplns, pmask);
	} else {			/* if viewer is in front of face */
		bsp_traverse( vwp, bsp->bsp_back, cplns, pmask);
		paint_face( bsp->bsp_face, cplns, pmask);
		bsp_traverse( vwp, bsp->bsp_front, cplns, pmask);
	}
}

paint_face( face, cplns, pmask)
	int face, cplns, pmask;
{
	struct poly *poly;
	short i;

	poly = &polylist[faces[face].start];
	for(i=0; i<faces[face].n; i++) {	/* paint each polygon */
	    gp1polys(poly, 1, cplns, pmask);
	    switch (face) {	/* cludge to avoid vectors on split polys */
	    			/* we should separate face polys, face vecs */
	    case 14: gp1vecs( &b5pwfix, 1, cplns, pmask); break;
	    case 19: gp1vecs( &b1pwfix, 1, cplns, pmask); break;
	    case 22: gp1vecs( &b5npwfix, 1, cplns, pmask); break;
	    case 26: gp1vecs( &b1spwfix, 1, cplns, pmask); break;
	    default: gp1vecs( poly, 1, cplns, pmask); break;
	    }
	    poly++;
	}
}

/*			    wood,grass, pond, sail,park,wall, roof */
unsigned char red[] = { 50, 100,  80,   50,   255, 180,  200, 200};
unsigned char grn[] = { 50, 100,  200,  150,  255, 180,  200, 100};
unsigned char blu[] = { 200, 20,  0,    255,  255, 180,   50, 50};

makemaps() /* make the colormaps */
{
	int i;

	for (i=0; i<CMAPSIZE; i++) {
		rmap1[i] = red[i & 7];
		gmap1[i] = grn[i & 7];
		bmap1[i] = blu[i & 7];
	}
	for (i=0; i<CMAPSIZE; i++) {
		rmap2[i] = red[i / 8];
		gmap2[i] = grn[i / 8];
		bmap2[i] = blu[i / 8];
	}
}

load_matrix( matptr)
	float *matptr;
{
	struct point *vtx;
	unsigned int bitvec;
	register int offset;
	register short *shmptr;

	while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
		;
	shmptr = &((short *) gp1_shmem)[offset];
	*shmptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*shmptr++ = GP1_SETFBINDX | 0;
	*shmptr++ = GP1_SELECTMATRIX | 0;
	*shmptr++ = GP1_SET_MATRIX_3D | 0;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*((float *) shmptr)++ = *((float *) matptr)++;
	*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)shmptr) = bitvec;
	gp1_post( gp1_shmem, offset,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
}

gp1polys( plist, n, cplns, mask)
register struct poly plist[];
register int n;
int cplns, mask;
	{
	register struct point *vtx;
	int i,m,nbnds, totpts;
	unsigned int bitvec;
	register int offset, roomleft, nwords;
	register short *shmptr, *npts;

	while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
		;
	shmptr = &((short *) gp1_shmem)[offset];
	*shmptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*shmptr++ = GP1_SETFBINDX | 0;
	*shmptr++ = GP1_SETROP;
	*shmptr++ = PIX_SRC;
	*shmptr++ = GP1_SETPIXPLANES | mask;
	*shmptr++ = GP1_SETCLIPPLANES | (cplns & 0x3F);
	*shmptr++ = GP1_EOCL;
	gp1_post( gp1_shmem, offset,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	offset += 7;
	roomleft = 512-10; /* 7 above, 3 for EOCL & bitvec before final post */
	for(i=0; i<n; i++) {		/* paint each polygon */
		nbnds = plist[i].nbnds;		/* number of boundaries */
		totpts = 0;
		for (m=0; m<nbnds; m++)
			totpts += plist[i].npts[m];
		if ((nwords = totpts*6 + nbnds + 5) > 509)
			{
			fprintf(stderr, "gp1polys: polygon too big!\n");
			continue;
			}
		if (nwords > roomleft)
			{
			*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
			*((unsigned int *)shmptr) = bitvec;
			gp1_post(gp1_shmem, offset,
			    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
			while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec,
			    minordev,
			    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
				;
			shmptr = &((short *) gp1_shmem)[offset];
			roomleft = 509;
			}
		roomleft -= nwords;
		vtx = plist[i].vtx;
		npts = plist[i].npts;
		*shmptr++ = GP1_USEFRAME | gp1_attr.statblkindx;
		*shmptr++ = GP1_SETCOLOR | plist[i].color;
		*shmptr++ = GP1_XFPOLYGON_3D | GP1_SHADE_CONSTANT;
		*shmptr++ = nbnds;
		while (nbnds--) *shmptr++ = *npts++;
		while (totpts--) {
			*((float *) shmptr)++ = vtx->x;
			*((float *) shmptr)++ = vtx->y;
			*((float *) shmptr)++ = vtx->z;
			vtx++;
			}
		*shmptr++ = GP1_EOCL;
		gp1_post(gp1_shmem, offset,
		    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
		offset += nwords;
		}
	*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)shmptr) = bitvec;
	gp1_post(gp1_shmem, offset,
		    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	}

gp1vecs( plist, n, cplns, mask)
register struct poly plist[];
register int n;
int cplns, mask;
	{
	register struct point *vtx, *startvtx;
	int i, m, nbnds;
	unsigned int bitvec;
	register int offset, nvecs, nvecsleft;
	register short *shmptr, *savptr, *npts;

	while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
		;
	shmptr = &((short *) gp1_shmem)[offset];
	*shmptr++ = GP1_USEFRAME | gp1_attr.statblkindx;
	*shmptr++ = GP1_SETCOLOR | TOPCOL;
	*shmptr++ = GP1_SETFBINDX | 0;
	*shmptr++ = GP1_SETROP;
	*shmptr++ = PIX_SRC;
	*shmptr++ = GP1_SETPIXPLANES | mask;
	*shmptr++ = GP1_SETCLIPPLANES | (cplns & 0x3F);
	savptr = shmptr;
	shmptr += 2;
	nvecs = 0;
	nvecsleft = (512 - 12) / 12;
	for(i=0; i<n; i++) {		/* paint edges of each polygon */
		nbnds = plist[i].nbnds;
		vtx = plist[i].vtx;
		npts = plist[i].npts;
		while (nbnds--) {
		    startvtx = vtx;
		    if ((m = *npts++) > 42)	/* (512 - 6) / 12 */
			{
			fprintf(stderr, "gp1vecs: boundary too big!\n");
			m = 42;
			}
		    if (nvecsleft < m)
			{
			if (nvecs > 0)
				{
				*savptr++ = GP1_XFVEC_3D;
				*savptr = nvecs;
				}
			*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
			*((unsigned int *)shmptr) = bitvec;
			gp1_post(gp1_shmem, offset,
			    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
			while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec,
			    minordev,
	    		    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
				;
			shmptr = &((short *) gp1_shmem)[offset];
			*shmptr++ = GP1_USEFRAME | gp1_attr.statblkindx;
			savptr = shmptr;
			shmptr += 2;
			nvecs = 0;
			nvecsleft = 42;		/* (512 - 6) / 12 */
			}
		    nvecs += m;
		    nvecsleft -= m;
		    while (--m) {
			    *((float *) shmptr)++ = vtx->x;
			    *((float *) shmptr)++ = vtx->y;
			    *((float *) shmptr)++ = vtx->z;
			    vtx++;
			    *((float *) shmptr)++ = vtx->x;
			    *((float *) shmptr)++ = vtx->y;
			    *((float *) shmptr)++ = vtx->z;
			    }
		    *((float *) shmptr)++ = vtx->x;
		    *((float *) shmptr)++ = vtx->y;
		    *((float *) shmptr)++ = vtx->z;
		    vtx++;
		    *((float *) shmptr)++ = startvtx->x;
		    *((float *) shmptr)++ = startvtx->y;
		    *((float *) shmptr)++ = startvtx->z;
		    }
		}
	*savptr++ = GP1_XFVEC_3D;
	*savptr = nvecs;
	*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)shmptr) = bitvec;
	gp1_post(gp1_shmem, offset,
		    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	}

flipplanes() {
	static int flip = 0;
	int plane1 = 0x7;
	int plane2 = 0x38;

	flip = 1 - flip;
	if (flip) {
		pw_putcolormap(gfx->gfx_pixwin,0,CMAPSIZE,rmap2,gmap2,bmap2);
		while((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->
		    status.word & 0x80);
		while(!((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->
		    status.word & 0x80));
		return(plane1);
	}
	else {
		pw_putcolormap(gfx->gfx_pixwin,0,CMAPSIZE,rmap1,gmap1,bmap1);
		while((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->
		    status.word & 0x80);
		while(!((gp1_d(gfx->gfx_pixwin->pw_pixrect)->cgpr_va)->
		    status.word & 0x80));
		return(plane2);
	}
}

gp1_pw_lock(pw, r)
struct pixwin *pw;
struct rect *r;
{
	pw_lock(pw, r);
	if (pw->pw_clipdata->pwcd_clipid == gp1_attr.clipid)
		return(0);
	return(gp1_pw_updclplst(pw));
}

gp1_pw_unlock(pw)
struct pixwin *pw;
{
	int retcode;

	retcode = 0;
	pw_unlock(pw);
	if (gfx->gfx_flags & GFX_DAMAGED) {
		gfxsw_handlesigwinch(gfx);
		retcode = 1;
		}
	if (gfx->gfx_flags & GFX_RESTART) {
		gfx->gfx_flags &= ~GFX_RESTART;
		retcode = 1;
		}
	return (retcode);
}
		
gp1_pw_updclplst(pw)
struct pixwin *pw;
{
	unsigned int bitvec;
	short offset, *gp1_addr;
	register short *bufptr, *nptr;
	struct gp1pr *dmd;
	int retcode, x, y, nrect, scalevalue;
	struct pixwin_prlist *prl;

	gp1_attr.clipid = pw->pw_clipdata->pwcd_clipid;
	retcode = 0;
	dmd = gp1_d(pw->pw_pixrect);
	gp1_addr = (short *)dmd->gp_shmem;
	while ((offset = gp1_alloc(gp1_addr, 1, &bitvec, minordev,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0);
	bufptr = &gp1_addr[offset];

	dmd = gp1_d(pw->pw_clipdata->pwcd_prmulti);
	scalevalue = (int)((pw->pw_clipdata->pwcd_prmulti->pr_size.x)/2.0);
	if (scalevalue < (int)((pw->pw_clipdata->pwcd_prmulti->pr_size.y)/2.0) )
	    scalevalue = (int)((pw->pw_clipdata->pwcd_prmulti->pr_size.y)/2.0);
	*bufptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*bufptr++ = GP1_SETVWP_3D;
	*((float *) bufptr)++ = scalevalue;
	*((float *) bufptr)++ = 
		dmd->cgpr_offset.x+(pw->pw_clipdata->pwcd_prmulti->pr_size.x)/2;
	*((float *) bufptr)++ = scalevalue;
	*((float *) bufptr)++ = 
		dmd->cgpr_offset.y+(pw->pw_clipdata->pwcd_prmulti->pr_size.y)/2;
	*((float *) bufptr)++ = 0;
	*((float *) bufptr)++ = 0;

	*bufptr++ = GP1_SETCLPLST;
	nptr = bufptr++;

	if (pw->pw_clipdata->pwcd_state == PWCD_NULL)
		{
		*nptr = 1;
		*bufptr++ = 0;
		*bufptr++ = 0;
		*bufptr++ = 0;
		*bufptr++ = 0;
		}
	else {
		nrect = 0;
		dmd = gp1_d(pw->pw_clipdata->pwcd_prmulti);
		x = dmd->cgpr_offset.x;
		y = dmd->cgpr_offset.y;
		if (x != gp1_attr.org_x | y != gp1_attr.org_x)
			{
			gp1_attr.org_x = x;
			gp1_attr.org_y = y;
			retcode = 1;
			}
		for (prl = pw->pw_clipdata->pwcd_prl; prl; prl = prl->prl_next)
			{
			dmd = gp1_d(prl->prl_pixrect);
			*bufptr++ = dmd->cgpr_offset.x;
			*bufptr++ = dmd->cgpr_offset.y;
			*bufptr++ = prl->prl_pixrect->pr_size.x;
			*bufptr++ = prl->prl_pixrect->pr_size.y;
			if (++nrect == 60)
				break;
			}
			*nptr = nrect;
		}
	*bufptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)bufptr) = bitvec;
	gp1_post(gp1_addr, offset, gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	return(retcode);
}
sigxcpu_catcher() {
	/* do nothing ... continue to run */
}

int gp1_stblk_alloc(fd)
int fd;
        {
        int i;
 
        if( ioctl(fd, GP1IO_GET_STATIC_BLOCK, &i) )
                return (-1);
        else
                return(i);
        }
 
gp1_matmul_3d( pw, m1, m2, m3)
struct pixwin *pw;
float *m1, *m2, *m3;
	{
	register short *gp1_addr, *shmptr, *result;
	register float *mptr;
	unsigned int bitvec;
	register int offset, i;
	struct gp1pr *dmd;

Restart:
	dmd = gp1_d(pw->pw_pixrect);
	gp1_addr = (short *)dmd->gp_shmem;
	while ((offset = gp1_alloc(gp1_addr, 1, &bitvec,
		dmd->minordev, dmd->ioctl_fd)) == 0)
		;
	shmptr = &(gp1_addr)[offset];
	*shmptr++ = GP1_USEFRAME | gp1_attr.statblkindx;
	*shmptr++ = GP1_SET_MATRIX_3D | 4;	/* matrix #4 is m1 */
	i = 4;
	mptr = m1;
	while (i--) {
		*((float *) shmptr)++ = *mptr++;
		*((float *) shmptr)++ = *mptr++;
		*((float *) shmptr)++ = *mptr++;
		*((float *) shmptr)++ = *mptr++;
	}
	*shmptr++ = GP1_SET_MATRIX_3D | 5;	/* matrix #5 is m2 */
	i = 4;
	mptr = m2;
	while (i--) {
		*((float *) shmptr)++ = *mptr++;
		*((float *) shmptr)++ = *mptr++;
		*((float *) shmptr)++ = *mptr++;
		*((float *) shmptr)++ = *mptr++;
	}
	*shmptr++ = GP1_MATMUL_3D;		/* matrix #3 = m1 * m2 */
	*shmptr++ = 4;
	*shmptr++ = 5;
	*shmptr++ = 3;
	*shmptr++ = GP1_GETMATRIX_3D | 3;	/* matrix #3 is result */
	result = shmptr;
	*shmptr++ = 1;				/* get matrix not done */
	shmptr += 32;				/* result goes here */
	*shmptr++ = GP1_EOCL;
	gp1_post(gp1_addr, offset, dmd->ioctl_fd);
						/* wait til matmul done */
	gp1_chkloc(result, dmd->ioctl_fd);
	result++;
	i = 4;
	mptr = m3;
	while (i--) {
		*mptr++ = *((float *) result)++;
		*mptr++ = *((float *) result)++;
		*mptr++ = *((float *) result)++;
		*mptr++ = *((float *) result)++;
	}
	shmptr = &(gp1_addr)[offset];
	*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)shmptr) = bitvec;
	gp1_post(gp1_addr, offset, dmd->ioctl_fd);
	return(0);
	}

gp1_chkloc(addr, fd)
short *addr;
int fd;   
	{
	int i;

	for (i=0; i<20000; i++) {
		if (!*addr) {
			return(0);
			}
		}
	gp1_kern_gp_restart(fd, 0);
	return(-1);
	} 

gp1_stblk_init()
	{
	register short *shmptr;
	unsigned int bitvec;
	register int offset;

	while ((offset = gp1_alloc(gp1_shmem, 1, &bitvec, minordev,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd)) == 0)
		;
	shmptr = &((short *) gp1_shmem)[offset];
	*shmptr++ = GP1_USEFRAME | (gp1_attr.statblkindx & 0x7);
	*shmptr++ = GP1_SETFBINDX |
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->cg2_index;
	*shmptr++ = GP1_SETPIXPLANES | 0;
	*shmptr++ = GP1_SETROP;
	*shmptr++ = PIX_SRC;
	*shmptr++ = GP1_SETCOLOR | 0;
	*shmptr++ = GP1_SETCLIPPLANES | 0;
	*shmptr++ = GP1_SELECTMATRIX | 0;
	*shmptr++ = GP1_SETHIDDENSURF | GP1_NOHIDDENSURF;
	*shmptr++ = GP1_EOCL | GP1_FREEBLKS;
	*((unsigned int *)shmptr) = bitvec;
	gp1_post( gp1_shmem, offset,
	    gp1_d(gfx->gfx_pixwin->pw_pixrect)->ioctl_fd);
	}
