/*	@(#)vp_int.h 1.2 86/10/07 SMI	*/

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/****
 *
 * VP_INT.H - Viewport internal header
 *
 ****/
#ifndef	_VP_INT
#include "obj_int.h"
#include "vp.h"

typedef	union { char *ch; float *fl; short *sh; int *in } PTR;
typedef struct vp_hdr VPDATA;

/*
 * Internal constants
 */
#define	VP_POLYMASK	4	/* polygon coordinate bit */
#define	VP_COORDMASK	3	/* coordinate mask */
#define	VP_VISMASK	8	/* visibility off bit */
#define	VP_TEX_MAX	16	/* maximum # of textures */
#define	VP_PAT_MAX	16	/* maximum # of patterns */

/*
 * Internal viewport structure field access
 */
#define	vp_pick_idget(v)	(v->vp_pick_id)
#define	vp_cindexget(v)		(v->vp_cindex)
#define	vp_dbufget(v)		(v->vp_dbuf)
#define	vp_pickget(v)		(v->vp_pick)
#define	vp_textabget(v)		(v->vp_textab)
#define	vp_pattabget(v)		(v->vp_pattab)

#define	_VP_INT	1
#endif
