/*	@(#)vp.h 1.2 86/10/07 SMI	*/

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/****
 *
 * VP.H - Viewport header
 *
 ****/
#ifndef	_VP
#include "obj.h"

#define	Create_VP Create_GP

/*
 * VP - main viewport handle.
 */
typedef	OBJID	VP;

/*
 * X windows dependencies
 */
#ifdef	VP_WIN_X		/* X windows environment? */
#include "Xlib.h"
extern	VP	Create_XVP();	/* create X windows viewport */

#define	Create_VP Create_XVP
#define	VPWIN	Window
#define M_DRAW  GXcopy
#define M_XOR   GXxor
#define M_PAINT GXor
#define M_ERASE GXandInverted

/*
 * Sunwindows dependencies
 */
#else				/* SunWindows environment */
#ifndef	RECT_NULL
#include <sunwindow/rect.h>
#endif

#ifndef PIXWIN_NULL
#include <sunwindow/rectlist.h>
#include <sunwindow/pixwin.h>
#endif

#ifndef	PIX_SRC
#include <pixrect/pixrect.h>
#endif

extern	VP	Create_VP();	/* create SunWindows viewport */

#define	vp_win_width	vp_wdim.r_width
#define	vp_win_height	vp_wdim.r_height

#define	VPWIN	struct pixwin *
#define M_DRAW  PIX_SRC
#define M_XOR   (PIX_SRC ^ PIX_DST)
#define M_PAINT (PIX_SRC | PIX_DST)
#define M_ERASE (~PIX_SRC & PIX_DST)
#endif

/*
 * POINT structure
 * An X, Y, Z coordinate may be either floating or integer.
 * The structure below handles both. For example:
 *	p.i.x	= integer X coordinate
 *	p.f.z	= floating Z coordinate
 */
typedef union
  {
   struct
     { int   x, y, z; } i;	/* integer coordinate */
   struct
     { float x, y, z; } f;	/* floating coordinate */
  } POINT;

typedef union { int i; float f; } COORD;
typedef struct { COORD x, y, z; } XYZ;

#define	Point_F2D(p,a,b) ((p)->f.x=a,(p)->f.y=b,(p))
#define	Point_I2D(p,a,b) ((p)->i.x=a,(p)->i.y=b,(p))
#define	Point_F3D(p,a,b,c) ((p)->f.x=a,(p)->f.y=b,(p)->f.z=c,(p))
#define	Point_I3D(p,a,b,c) ((p)->i.x=a,(p)->i.y=b,(p)->i.z=c,(p))

/*
 * Viewport types
 */
#define VP_GP		0	/* GP1 viewport type */
#define VP_GP1		0
#define VP_PW		1	/* pixwin viewport type */
#define VP_PIXWIN	1
#define VP_XWIN		2	/* X viewport type */

#define	VP_TEX_RANGE	1	/* textured line range */
#define	VP_TEX_5080	2	/* textured line pixel mask (5080 format) */
#define	VP_TEX_PIXRECT	3	/* textured polygon pixrect */

#define	VP_DBUF_DISABLE	0	/* disable double buffering */
#define	VP_DBUF_ENABLE	1	/* enable double buffering */
#define	VP_DBUF_REMAP	2	/* remap colors */


/*
 * Coordinate Types.
 * TypeInt(t)	nonzero if integer coordinates (2D or 3D)
 * TypeFlt(t)	nonzero if floating coordinates (2D or 3D)
 * Type2D(t)	nonzero if 2D coordinates (int or float)
 * Type3D(t)	nonzero if 3D coordinates (int or float)
 */
#define	VP_INT2D	0	/* 2D integer */
#define	VP_INT3D	1	/* 3D integer */
#define	VP_FLT2D	2	/* 2D float */
#define	VP_FLT3D	3	/* 3D float */

#define	TypeInt(t) (!((t)&2))
#define	TypeFlt(t) ((t)&2)
#define	Type2D(t) (!((t)&1))
#define	Type3D(t) ((t)&1)

/****
 *
 * WARNING! Anything below this point is NOT FOR USER MANIPULATION!
 * The implementation of these macros and the names and usage of
 * these data structures are SUBJECT TO CHANGE WITHOUT NOTICE.
 * Pretend the following is illegible (which may be the case anyway).
 *
 ****/

/*
 * Get_VP(vp, attr)
 * Fast way to fetch some viewport attributes.
 *
 * Put_VP(vp, attr, val)
 * Fast way to set some viewport attributes.
 *
 */
#ifndef	CAT
#undef	IDENT
#define	IDENT(x)	x
#define	CAT(a,b)	IDENT(a)b
#endif

#define	vp_addr(v)	ObjAddr(v,struct vp_hdr)
#define	vp_call(v,f)	(*(vp_addr(v)->vp_func[CAT(VPF_,f)]))
#define	vp_get(v,a)	vp_call(v,Get)(v,a)
#define	Get_VP(v,a)	CAT(a,get)(vp_addr(v))

#define	VP_WINget(v)		(v->vp_win)
#define	VP_TYPEget(v)		(v->vp_type)
#define	VP_COORDget(v)		(v->vp_coord)
#define	VP_COLORget(v)		(v->vp_color)
#define	VP_ROPget(v)		(v->vp_rop)
#define	VP_FILLget(v)		(v->vp_fill)
#define	VP_VISIBLEget(v)	(v->vp_visible)
#define	VP_PATTERNget(v)	(v->vp_pattern)
#define	VP_LINE_STYLEget(v)	(v->vp_line_style)
#define	VP_LINE_WIDTHget(v)	(v->vp_line_width)
#define	VP_LINE_HEIGHTget(v)	(v->vp_line_height)
#define	VP_LINE_SIZEget(v)	(v->vp_line_size)
#define	VP_PENget(v)		(&(v->vp_pen))
#define	VP_CMAP_REDget(v)	(v->vp_cmap_red)
#define	VP_CMAP_GREENget(v)	(v->vp_cmap_green)
#define	VP_CMAP_BLUEget(v)	(v->vp_cmap_blue)
#define	VP_CMAP_SIZEget(v)	(v->vp_cmap_size)
#define	VP_DBUF_STATget(v)	(v->vp_dbuf_stat)
#define	VP_PIXPLANESget(v)	(v->vp_pixplanes)
#define	VP_PIXBITSget(v)	(v->vp_pixbits)
#define	VP_FRAMEget(v)		(v->vp_frame)
#define	VP_PICK_COUNTget(v)	(v->vp_pick_count)
#define	VP_PICK_ORGget(v)	(&(v->vp_pick_org))
#define	VP_PICK_DIMget(v)	(&(v->vp_pick_dim))
#define	VP_VIEW_ORGget(v)	(&(v->vp_view_org))
#define	VP_VIEW_DIMget(v)	(&(v->vp_view_dim))
#define	VP_WIN_WIDTHget(v)	(v->vp_win_width)
#define	VP_WIN_HEIGHTget(v)	(v->vp_win_height)

#define	VP_PICK_IDget(v)	vp_call(v,Get)(v,VP_PICK_ID)

/*
 * Viewport attributes
 */
#define	VP_WIN		0	/* window handle */
#define	VP_WIN_WIDTH	1	/* width of window in pixels */
#define	VP_WIN_HEIGHT	2	/* height of window in pixels */
#define	VP_TYPE		3	/* viewport type */
#define	VP_COORD	4	/* viewport coordinate type */
#define	VP_COLOR	5	/* current color */
#define	VP_ROP		6	/* current raster-op */
#define	VP_FILL		7	/* fill enable/disable */
#define	VP_PEN		8	/* current pen position */
#define	VP_VIEW_ORG	9	/* viewport origin */
#define	VP_VIEW_DIM	10	/* viewport dimensions */
#define	VP_CMAP_RED	11	/* -> red color map */
#define	VP_CMAP_GREEN	12	/* -> green color map */
#define	VP_CMAP_BLUE	13	/* -> blue color map */
#define	VP_CMAP_SIZE	14	/* # of entries in color map */
#define	VP_DBUF_STAT	15	/* double buffering status */
#define	VP_PIXPLANES	16	/* pixel planes mask */
#define	VP_PIXBITS	17	/* # of bits per pixel */
#define	VP_FRAME	18	/* double buffering frame number (0, 1) */
#define	VP_PICK_ID	19	/* pick identifier */
#define	VP_PICK_ORG	20	/* origin of pick area (pixels) */
#define	VP_PICK_DIM	21	/* dimensions of pick area (pixels) */
#define	VP_LINE_STYLE	22	/* index of texture pattern for lines */
#define	VP_LINE_WIDTH	23	/* width of lines (pixels) */
#define	VP_LINE_HEIGHT	24	/* width of lines (pixels) */
#define	VP_LINE_SIZE	25	/* pixel size of brush for lines */
#define	VP_PATTERN	26	/* index of pattern for polygon fill */
#define	VP_PICK_COUNT	27	/* pick count */
#define	VP_VISIBLE	28	/* visibility flag */

#define	VP_REALPLANES	29	/* (internal) */
#define	VP_LAST		29	/* index of last user opcode */

typedef	int	_vpfunc();
typedef	_vpfunc	*_vpfp;

/*
 * vp_hdr - viewport header
 */
typedef struct vp_hdr
  {
   _vpfp	*vp_func;		/* function dispatch */
   VPWIN	vp_win;			/* window */
   uchar	*vp_cindex;		/* color index table */
   short	vp_ftype;		/* function dispatch type */
   OBJID	vp_dbuf;		/* double buffering info */
   OBJID	vp_pick;		/* pick info */
   OBJID	vp_textab;		/* texture table */
   OBJID	vp_pattab;		/* pattern table */
#ifdef	VP_WIN_X
   short	vp_win_width;		/* window width */
   short	vp_win_height;		/* window height */
#else
   struct rect	vp_wdim;		/* window dimensions */
#endif

/*
 * Viewport attributes
 */
   char		vp_type;		/* viewport type */
   char		vp_coord;		/* viewport coordinate type */
   char		vp_fill;		/* fill/nofill flag */
   char		vp_visible;		/* visibility status [0 = invisible] */
   char		vp_frame;		/* frame buffer selected */
   char		vp_dbuf_stat;		/* double buffering mode */
   short	vp_color;		/* current color */
   short	vp_rop;			/* current raster-op */
   short	vp_pixplanes;		/* bit planes selected */
   short	vp_pixbits;		/* bits per pixel */
   short	vp_pick_count;		/* pick count */
   short	vp_line_width;		/* line width */
   short	vp_line_height;		/* line height */
   short	vp_line_size;		/* line size */
   short	vp_line_style;		/* line style (texture) */
   short	vp_pattern;		/* pattern (for polygon fill) */
   short	vp_cmap_size;		/* color map size */
   long		vp_pick_id;		/* pick identifier */
   uchar	*vp_cmap_red;		/* -> red color map */
   uchar	*vp_cmap_green;		/* -> green color map */
   uchar	*vp_cmap_blue;		/* -> blue color map */
   POINT	vp_pen;			/* pen position */
   POINT	vp_view_org;		/* viewport origin */
   POINT	vp_view_dim;		/* viewport dimensions */
   POINT	vp_pick_org;		/* pick area origin */
   POINT	vp_pick_dim;		/* pick area dimensions */
  };

/*
 * Viewport functions
 */
#define	VPF_Destroy	0
#define	VPF_Flush	1
#define	VPF_Print	2
#define	VPF_Get		3
#define	VPF_Set		4
#define	VPF_Draw	5
#define	VPF_Box		6
#define	VPF_Clear	7
#define	VPF_Move	8
#define	VPF_Repaint	9
#define	VPF_Xform	10
#define	VPF_MoveRel	11
#define	VPF_Oval	12
#define	VPF_Close	13
#define	VPF_DrawRel	14
#define	VPF_Wait	15
#define	VPF_Mapcolor	16
#define	VPF_Last	16

#define	Destroy_VP(vp)	vp_call(vp,Destroy)(vp)
#define	Flush_VP(vp)	vp_call(vp,Flush)(vp)
#define	Print_VP(vp)	vp_call(vp,Print)(vp)
#define	Set_VP(vp,a,v)	vp_call(vp,Set)(vp,a,v)
#define	Draw_VP(vp,p)	vp_call(vp,Draw)(vp,p)
#define	Box_VP(vp,p)	vp_call(vp,Box)(vp,p)
#define	Clear_VP(vp,c)	vp_call(vp,Clear)(vp,c)
#define	Move_VP(vp,p)	vp_call(vp,Move)(vp,p)
#define	Repaint_VP(vp)	vp_call(vp,Repaint)(vp)
#define	Xform_VP(vp,a,b) vp_call(vp,Xform)(vp,a,b)
#define	MoveRel_VP(vp,p) vp_call(vp,MoveRel)(vp,p)
#define	DrawRel_VP(vp,p) vp_call(vp,DrawRel)(vp,p)
#define	Oval_VP(vp,p)	vp_call(vp,Oval)(vp,p)
#define	Close_VP(vp)	vp_call(vp,Close)(vp)

#define	Set_Matrix	vp_matrix_set
#define	Get_Matrix	vp_matrix_get
#define	Mul_Matrix	vp_matrix_mul
#define	Xform_Matrix	vp_matrix_xform
#define	Set_Texture	vp_tex_set

/*
 * Internal viewport functions
 * WAIT_VP(vp)		wait for viewport to finish any graphics
 * MAPCOLOR_VP(vp,c)	map color C to physical color map entry
 * LOCK_VP(vp)		lock screen for grouped operations (SunWindows)
 * UNLOCK_VP(vp)	unlock screen (SunWindows)
 */
#define	WAIT_VP(vp)	vp_call(vp,Wait)(vp)
#define	MAPCOLOR_VP(vp,c) vp_call(vp,Mapcolor)(vp,c)

#ifdef	VP_WIN_X		/* X window system? */
#define	LOCK_VP(vo)		/* no explicit lock/unlock */
#define	UNLOCK_VP(vo)

#else				/* SunWindows? */
#define	LOCK_VP(vo)	pw_lock(vp_addr(vo)->vp_win, &(vp_addr(vo)->vp_wdim))
#define	UNLOCK_VP(vo)	pw_unlock(vp_addr(vo)->vp_win)
#endif
#define	_VP	1
#endif
