/*	@(#)pix.h 1.3 86/10/07 SMI	*/

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/****
 *
 * PIX.H - Picture Data Structure Macros
 *
 ****/
#ifndef	_PIX
#include "gpbuf.h"
#include "obj_int.h"

#define	PIX_CUR_MAT	3
#define	PIX_TEMP_MAT	4

#define	PIX_PARENT	0
#define	PIX_CHILD	1
#define	PIX_NEXT	2
#define	PIX_FUNC	3
#define	PIX_USER	4
#define	PIX_MATRIX	5

#define	pix_addr(p)	ObjAddr(p, PIXDATA)

typedef struct
  {
   OBJID	px_parent;	/* -> parent object */
   OBJID	px_child;	/* -> list of children */
   OBJID	px_next;	/* -> followers */
   func		*px_func;	/* image function */
   int		px_user;	/* user defined data */
   int		px_flags;	/* picture flags */
   float	*px_xrot;	/* -> rotation values */
   float	*px_yrot;
   float	*px_zrot;
   float	*px_xscale;	/* -> scale values */
   float	*px_yscale;
   float	*px_zscale;
   float	*px_xtrans;	/* -> translation values */
   float	*px_ytrans;
   float	*px_ztrans;
   float	*px_xaxis;	/* -> arbitrary rotation axis position */
   float	*px_yaxis;
   float	*px_zaxis;
   float	*px_angle;	/* -> arbitrary rotation angle */
   POINT	px_scale;	/* scale factors */
   POINT	px_trans;	/* translation factors */
   POINT	px_axis;	/* rotation axis */
   MATRIX	px_matrix;	/* transformation matrix */
  } PIXDATA;


/****
 *
 * Destroy_Pix(px)
 * Destroys a pixture data structure.
 *
 ****/
#define	Destroy_Pix(px) (Destroy_Image(pix_image(px)), FreeObj(px))

/****
 *
 * RotX_Pix(px, (float *) &xangle)
 * RotY_Pix(px, (float *) &yangle)
 * RotZ_Pix(px, (float *) &zangle)
 * Rotate around the X Y or Z axis by a variable angle.
 *
 ****/
#define	RotX_Pix(px, a) (pix_addr(px)->px_xrot = a)
#define	RotY_Pix(px, a) (pix_addr(px)->px_yrot = a)
#define	RotZ_Pix(px, a) (pix_addr(px)->px_zrot = a)

/****
 *
 * ScaleX_Pix(px, (float *) &xscale)
 * ScaleY_Pix(px, (float *) &yscale)
 * ScaleZ_Pix(px, (float *) &zscale)
 * Scale in the X Y or Z direction by a variable scale factor.
 *
 ****/
#define	ScaleX_Pix(px, s) (pix_addr(px)->px_xscale = s)
#define	ScaleY_Pix(px, s) (pix_addr(px)->px_yscale = s)
#define	ScaleZ_Pix(px, s) (pix_addr(px)->px_zscale = s)

/****
 *
 * TransX_Pix(px, (float *) &x)
 * TransY_Pix(px, (float *) &y)
 * TransZ_Pix(px, (float *) &z)
 * Translate in the X Y or Z direction by a variable amount.
 *
 ****/
#define	TransX_Pix(px, x) (pix_addr(px)->px_xtrans = x)
#define	TransY_Pix(px, y) (pix_addr(px)->px_ytrans = y)
#define	TransZ_Pix(px, z) (pix_addr(px)->px_ztrans = z)

extern	OBJID	Create_Pix();

#define	_PIX	1
#endif
