/*	@(#)gpbuf.h 1.2 86/10/07 SMI	*/

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/****
 *
 * GPBUF.H - GP buffer header
 *
 ****/
#ifndef	_GPBUF
#include "vp.h"

/*
 * clipping planes
 */
#define	VP_CLIP_YON	0x01
#define	VP_CLIP_BACK	0x01
#define	VP_CLIP_HITHER	0x02
#define	VP_CLIP_FRONT	0x02
#define	VP_CLIP_TOP	0x04
#define	VP_CLIP_BOTTOM	0x08
#define	VP_CLIP_RIGHT	0x10
#define	VP_CLIP_LEFT	0x20
#define	VP_CLIP_X	0x30
#define	VP_CLIP_Y	0x0C
#define	VP_CLIP_Z	0x03
#define	VP_CLIP_ALL	0x3F

#define	GPB_CLIP_YON	VP_CLIP_YON
#define	GPB_CLIP_BACK	VP_CLIP_BACK
#define	GPB_CLIP_HITHER	VP_CLIP_HITHER
#define	GPB_CLIP_FRONT	VP_CLIP_FRONT
#define	GPB_CLIP_TOP	VP_CLIP_TOP
#define	GPB_CLIP_BOTTOM	VP_CLIP_BOTTOM
#define	GPB_CLIP_RIGHT	VP_CLIP_RIGHT
#define	GPB_CLIP_LEFT	VP_CLIP_LEFT
#define	GPB_CLIP_X	VP_CLIP_X
#define	GPB_CLIP_Y	VP_CLIP_Y
#define	GPB_CLIP_Z	VP_CLIP_Z
#define	GPB_CLIP_ALL	VP_CLIP_ALL

/*
 * general types
 */
typedef	float	MATRIX[4][4];
typedef	OBJID	GPBUF;

#define	Vertex(c,s) (((c)<<16)|(s))
#define	VertexColor(v) ((uchar) ((v)>>16))
#define	VertexShade(v) ((ushort) ((v)&0xFFFF))

/*
 * Attributes
 */
#define	VP_SHADE_GOURAUD 2
#define	VP_AUTO_SCALE	(VP_LAST+1)
#define	VP_SCALE_ALL	1
#define	VP_SCALE_SQUARE	2
#define	VP_SIZE		(VP_LAST+2)
#define	VP_CLIPPLANES	(VP_LAST+3)
#define	VP_MATRIX	(VP_LAST+4)
#define	VP_HIDDENSURF	(VP_LAST+5)
#define	VP_WIN_ORG	(VP_LAST+6)
#define	VP_WIN_DIM	(VP_LAST+7)
#define	VP_CLIP_ORG	(VP_LAST+8)
#define	VP_CLIP_DIM	(VP_LAST+9)
#define	VP_VIS_ORG	(VP_LAST+10)
#define	VP_VIS_DIM	(VP_LAST+11)
#define	VP_VERTEX_COLOR	(VP_LAST+12)
#define	VP_VERTEX_SHADE	(VP_LAST+13)

#define	GPB_SHADE_GOURAUD 2
#define	GPB_AUTO_SCALE	VP_AUTO_SCALE
#define	GPB_SCALE_ALL	1
#define	GPB_SCALE_SQUARE 2
#define	GPB_SIZE	VP_SIZE
#define	GPB_CLIPPLANES	VP_CLIPPLANES
#define	GPB_MATRIX	VP_MATRIX
#define	GPB_HIDDENSURF	VP_HIDDENSURF
#define	GPB_WIN_ORG	VP_WIN_ORG
#define	GPB_WIN_DIM	VP_WIN_DIM
#define	GPB_CLIP_ORG	VP_CLIP_ORG
#define	GPB_CLIP_DIM	VP_CLIP_DIM
#define	GPB_VIS_ORG	VP_VIS_ORG
#define	GPB_VIS_DIM	VP_VIS_DIM
#define	GPB_VERTEX_COLOR VP_VERTEX_COLOR
#define	GPB_VERTEX_SHADE VP_VERTEX_SHADE

#define	gpb_get(g) ((struct _gpbuf *) (g))->gpb_attr

#define	VP_AUTO_SCALEget(g)	gpb_get(g).gpa_AUTO_SCALE
#define	VP_SIZEget(g)		gpb_get(g).gpa_SIZE
#define	VP_CLIPPLANESget(g)	gpb_get(g).gpa_CLIPPLANES
#define	VP_MATRIXget(g)	gpb_get(g).gpa_MATRIX
#define	VP_HIDDENSURFget(g)	gpb_get(g).gpa_HIDDENSURF
#define	VP_WIN_ORGget(g)	&gpb_get(g).gpa_WIN_ORG
#define	VP_WIN_DIMget(g)	&gpb_get(g).gpa_WIN_DIM
#define	VP_CLIP_ORGget(g)	&gpb_get(g).gpa_CLIP_ORG
#define	VP_CLIP_DIMget(g)	&gpb_get(g).gpa_CLIP_DIM
#define	VP_VIS_ORGget(g)	((POINT *) vp_call(g,Get)(g, VP_VIS_ORG))
#define	VP_VIS_DIMget(g)	((POINT *) vp_call(g,Get)(g, VP_VIS_DIM))
#define	VP_VERTEX_COLORget(g)	&gpb_get(g).gpa_VERTEX_COLOR

#define	GPB_AUTO_SCALEget(g)	gpb_get(g).gpa_AUTO_SCALE
#define	GPB_SIZEget(g)		gpb_get(g).gpa_SIZE
#define	GPB_CLIPPLANESget(g)	gpb_get(g).gpa_CLIPPLANES
#define	GPB_MATRIXget(g)	gpb_get(g).gpa_MATRIX
#define	GPB_HIDDENSURFget(g)	gpb_get(g).gpa_HIDDENSURF
#define	GPB_WIN_ORGget(g)	&gpb_get(g).gpa_WIN_ORG
#define	GPB_WIN_DIMget(g)	&gpb_get(g).gpa_WIN_DIM
#define	GPB_CLIP_ORGget(g)	&gpb_get(g).gpa_CLIP_ORG
#define	GPB_CLIP_DIMget(g)	&gpb_get(g).gpa_CLIP_DIM
#define	GPB_VIS_ORGget(g)	((POINT *) vp_call(g,Get)(g, VP_VIS_ORG))
#define	GPB_VIS_DIMget(g)	((POINT *) vp_call(g,Get)(g, VP_VIS_DIM))
#define	GPB_VERTEX_COLORget(g)	&gpb_get(g).gpa_VERTEX_COLOR
#define	GPB_VERTEX_SHADEget(g)	&gpb_get(g).gpa_VERTEX_SHADE

/*
 * GPATTR describes attributes associated with GP which are not common
 */
typedef struct _gpa
  {
   char		gpa_AUTO_SCALE;	/* autoscale flag */
   char		gpa_SIZE;	/* block size of GP buffer */
   short	gpa_CLIPPLANES;	/* clip planes */
   short	gpa_MATRIX;	/* matrix selected */
   short	gpa_HIDDENSURF;	/* hidden surface */
   int		gpa_VERTEX_COLOR; /* color of vertex for GOURAUD shading */
   short	gpa_VERTEX_SHADE; /* shade of vertex for GOURAUD shading */
   POINT	gpa_WIN_ORG;	/* origin of visible window area */
   POINT	gpa_WIN_DIM;	/* dimensions of visible window area */
   POINT	gpa_CLIP_ORG;	/* origin of clip area */
   POINT	gpa_CLIP_DIM;	/* dimensions of clip area */
  };

/*
 * GPBUF contains all the information needed to talk to the GP, build
 * vector lists, allocate shared memory, etc. This is the handle used
 * to communicate with xxx_GP routines.
 */
typedef struct _gpbuf
  {
   struct vp_hdr gpb_vp;	/* viewport header */
   struct _gpa	gpb_attr;	/* attributes */
  };

#define	_GPBUF	1
#endif
