#ifndef lint
static	char sccsid[] = "@(#)dev_gp1_vec.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


#include "dev_gp1_internal.h"


void
Dev_gp1_move_2df(gp1, pt)
register	GP1		*gp1;
register	Point2df	*pt;
{   
    
    if (gp1->list_type != GP1_VEC_LIST_2DF) {
	MAKE_ROOM(gp1, (2*sizeof(short) + 2*sizeof(float)));
	gp1->list_type = GP1_VEC_LIST_2DF;
	*(gp1->cur_ptr)++ = GP1_XF_LINE_FLT_2D;
    }
    else if (IS_NO_ROOM(gp1, (sizeof(short) + 2*sizeof(float)))) {
	Dev_gp1_flush(gp1, TRUE);
	gp1->list_type = GP1_VEC_LIST_2DF;
	*(gp1->cur_ptr)++ = GP1_XF_LINE_FLT_2D;
	gp1->bytes_left -= (2*sizeof(short) + 2*sizeof(float));
    }
    else {
	gp1->bytes_left -= (sizeof(short) + 2*sizeof(float));
	*(gp1->cur_ptr - 5) &= ~GP1_TERMINATE;	
    }
    *(gp1->cur_ptr)++ = GP1_TERMINATE | GP1_MOVE;
    SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->x));
    SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->y));
}




void
Dev_gp1_draw_2df(gp1, pt)
register	GP1		*gp1;
register	Point2df	*pt;
{   
    register	short		*ptr;
    		Point2df	tmp_pt;
    
    if (gp1->list_type == GP1_VEC_LIST_2DF) {
	if (IS_NO_ROOM(gp1, (sizeof(short) + 2*sizeof(float)))) {
	    ptr = gp1->cur_ptr - 4;
	    FLOAT_GETS_SHORTS(&tmp_pt.x, ptr);
	    FLOAT_GETS_SHORTS(&tmp_pt.y, ptr);
	    Dev_gp1_flush(gp1, TRUE);
	    Dev_gp1_move_2df(gp1, &tmp_pt);
	}
	
	gp1->bytes_left -= (sizeof(short) + 2*sizeof(float));
	
	*(gp1->cur_ptr - 5) &= ~GP1_TERMINATE;	/* change the last control
						 * field to NOT be a terminate.
						 * 5 => 5 shorts => 2 floats
						 * and 1 short for the control
						 * word.
						 */
	*(gp1->cur_ptr)++ = GP1_TERMINATE | GP1_DRAW;
	
	SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->x));
	SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->y));
    }
}


void
Dev_gp1_move_3df(gp1, pt)
register	GP1		*gp1;
register	Point3df	*pt;
{   
    
    if (gp1->list_type != GP1_VEC_LIST_3DF) {
	MAKE_ROOM(gp1, (2*sizeof(short) + 3*sizeof(float)));
	gp1->list_type = GP1_VEC_LIST_3DF;
	*(gp1->cur_ptr)++ = GP1_XF_LINE_FLT_3D;
    }
    else if (IS_NO_ROOM(gp1, (sizeof(short) + 3*sizeof(float)))) {
	Dev_gp1_flush(gp1, TRUE);
	gp1->list_type = GP1_VEC_LIST_3DF;
	*(gp1->cur_ptr)++ = GP1_XF_LINE_FLT_3D;
	gp1->bytes_left -= (2*sizeof(short) + 3*sizeof(float));
    }
    else {
	gp1->bytes_left -= (sizeof(short) + 3*sizeof(float));
	*(gp1->cur_ptr - 7) &= ~GP1_TERMINATE;	
    }
    *(gp1->cur_ptr)++ = GP1_TERMINATE | GP1_MOVE;
    SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->x));
    SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->y));
    SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->z));
}




void
Dev_gp1_draw_3df(gp1, pt)
register	GP1		*gp1;
register	Point3df	*pt;
{   
    register	short		*ptr;
    		Point3df	tmp_pt;
    
    if (gp1->list_type == GP1_VEC_LIST_3DF) {
	if (IS_NO_ROOM(gp1, (sizeof(short) + 3*sizeof(float)))) {
	    ptr = gp1->cur_ptr - 6;
	    FLOAT_GETS_SHORTS(&tmp_pt.x, ptr);
	    FLOAT_GETS_SHORTS(&tmp_pt.y, ptr);
	    FLOAT_GETS_SHORTS(&tmp_pt.z, ptr);
	    Dev_gp1_flush(gp1, TRUE);
	    Dev_gp1_move_3df(gp1, &tmp_pt);
	}
	
	gp1->bytes_left -= (sizeof(short) + 3*sizeof(float));
	
	*(gp1->cur_ptr - 7) &= ~GP1_TERMINATE;	/* change the last control
						 * field to NOT be a terminate.
						 * 7 => 7 shorts => 3 floats
						 * and 1 short for the control
						 * word.
						 */
	*(gp1->cur_ptr)++ = GP1_TERMINATE | GP1_DRAW;
	
	SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->x));
	SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->y));
	SHORTS_GET_FLOAT(gp1->cur_ptr, &(pt->z));
    }
}



void
Dev_gp1_set_line_texture(gp1, pat, offset, ops)
GP1				*gp1;
short				pat[];
short				offset;
struct pr_texture_options	ops;
{   
    register	int	total_size;
    register	short	*ptr;
    
    total_size = 4 * sizeof(short);
    for (ptr = pat; *ptr != 0; ptr++)
	total_size += sizeof(short);
    
    MAKE_ROOM(gp1, total_size);
    
    gp1->list_type = GP1_NO_LIST;    
    *(gp1->cur_ptr)++ = GP1_SET_LINE_TEX;
    
    for (ptr = pat; *ptr != 0; ptr++)
	*(gp1->cur_ptr)++ = *ptr;
	
    *(gp1->cur_ptr)++ = 0;
    *(gp1->cur_ptr)++ = offset;
    *(gp1->cur_ptr)++ =  *((short *) &ops);    
}




void
Dev_gp1_set_line_width(gp1, width)
register	GP1	*gp1;
 		short	width;
{   
    MAKE_ROOM(gp1, 3 * sizeof(short));
    
    gp1->list_type = GP1_NO_LIST;    
    *(gp1->cur_ptr)++ = GP1_SET_LINE_WIDTH;
    *(gp1->cur_ptr)++ = width;
    *(gp1->cur_ptr)++ = (short) 0;
}
