#ifndef lint
static	char sccsid[] = "@(#)dev_gp1_print.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


#include "dev_gp1_internal.h"

static	void	print_poly3d();
static	void	print_poly2d();


/****
 *
 * print_gp(gpb)
 *	
 ****/
 
void
Dev_gp1_print(gp1)
register	GP1	*gp1;
{
    register	short		*ptr;
    register	int		n;
    register	unsigned short	op;
    register	unsigned char	arg;
    register 	int 		i, nb, nv, s;
    		int		ival;
		float		fval0, fval1, fval2, fval3, fval4, 
				fval5, fval6, fval7;
		int		ival0, ival1, ival2, ival3, ival4, 
				ival5, ival6, ival7;
		short		*short_ptr;
    
    printf("GP1:\nshared memory:\t%x\n", gp1->shmem);
    printf("static block:\t%d\n", gp1->static_block_index);
    printf("texture block:\t%d\n", gp1->texture_block_index);
    printf("minor device number:\t%d\n", gp1->minor_devno);
    printf("cmd buffer offset:\t%d\n\n", gp1->cmd_buff_offset);
    
    ptr = &(gp1->shmem[gp1->cmd_buff_offset]);
    printf("start of cmd buffer:\t0x%x\n\n", ptr);
    
    while (ptr < gp1->cur_ptr) {
	op = (*ptr) & 0xff00;		/* op is hi-order 8 bits */
	arg = (*ptr) & 0xff;		/* optional arg is low-order byte */
	ptr++;
	switch (op) {
	    
	  case GP1_EOCL:
	    printf("GP1_EOCL");
	    
	    /*
	     * EOCL | [ FREEBLKS ]
	     * (int) bit vector of blocks
	     */
	    if (arg) {
		printf("\t| GP1_FREEBLKS\n");
		INT_GETS_SHORTS(&ival, ptr);
		printf("\tbit vec = 0x%x\n", ival);
	    }
	    else {
		printf("\n");
	    }
	    break;
	    
	  case GP1_USE_CONTEXT:
	    printf("GP1_USE_CONTEXT");
	    printf("\t| %d\n", arg);
	    break;
	    
	  case GP1_SET_FB_NUM:
	    printf("GP1_SET_FB_NUM");
	    printf("\t| %d\n", arg);
	    break;
	    
	  case GP1_SET_COLOR:
	    printf("GP1_SET_COLOR");
	    printf("\t| %d\n", arg);
	    break;
	    
	  case GP1_SET_FB_PLANES:
	    printf("GP1_SET_FB_PLANES");
	    printf("\t| 0x%x\n", arg);
	    break;
	    
	  case GP1_SET_CLIP_PLANES:
	    printf("GP1_SET_CLIP_PLANES");
	    printf("\t| 0x%x\n", arg);
	    break;
	  
	  case GP1_SET_MAT_NUM:
	    printf("GP1_SET_MAT_NUM");
	    printf("\t| %d\n", arg);
	    break;

	  case GP1_SET_ROP:
	    printf("GP1_SET_ROP");
	    printf("\t%4.4x\n", (unsigned short) *ptr++);
	    break;

	  case GP1_PR_ROP_NF:
	    printf("GP1_PR_ROP_NF");
	    
 	    /*
	     * PRROPNF | pixel planes mask
	     * (short) frame buffer index
	     * (short) raster op / color
	     * clip rectangle (in device coordinates)
 	     * (short) x origin of upper left corner
 	     * (short) y origin of upper left corner
 	     * (short) width in pixels
             *	(short) height in pixels
	     * 
             * destination in rectangle (with respect to clip rectangle)
 	     * (short) x origin of upper left corner
 	     * (short) y origin of upper left corner
 	     * (short) width in pixels
             * (short) height in pixels
 	     */
	    printf(" PIXP = 0%x FBI = %d, ROP/COLOR = 0%x\n",
		   arg, *ptr, *(ptr + 1));
	    ptr += 2;
	    printf("\tCLIP: %d, %d  %d x %d\n", *ptr, *(ptr + 1),
		   *(ptr + 2), *(ptr + 3));
	    ptr += 4;
	    printf("\tDEST: %d, %d  %d x %d\n", *ptr, *(ptr + 1),
		   *(ptr + 2), *(ptr + 3));
	    ptr += 4;
	    break;
	
	  case GP1_MUL_MAT_2D:
	    printf("GP1_MUL_MAT_2D");
	    printf("\t%d =  %d * %d\n", *(ptr + 2), *ptr, *(ptr + 1));
	    ptr += 3;
	    break;
	    
	  case GP1_MUL_MAT_3D:	    
	    printf("GP1_MUL_MAT_3D");
	    printf("\t%d =  %d * %d\n", *(ptr + 2), *ptr, *(ptr + 1));
	    ptr += 3;
	    break;

	  case GP1_SET_MAT_2D:
	    printf("GP1_SET_MAT_2D");
	    
 	    /*
 	     * SET_MATRIX_2D | matrix
 	     * (float) Mat[1,1]
 	     * (float) Mat[1,2]
 	     * (float) Mat[2,1]
 	     *	...
 	     * (float) Mat[3,2]
 	     */
	    n = 0;
	    printf("\t| %d\n",arg);
	    
mat2d:	      
	    FLOAT_GETS_SHORTS(&fval0, ptr);
	    FLOAT_GETS_SHORTS(&fval1, ptr);
	    FLOAT_GETS_SHORTS(&fval2, ptr);
	    FLOAT_GETS_SHORTS(&fval3, ptr);
	    FLOAT_GETS_SHORTS(&fval4, ptr);
	    FLOAT_GETS_SHORTS(&fval5, ptr);
	    printf("\t%f\t%f\n\t%f\t%f\n\t%f\t%f\n",
		   fval0, fval1, fval2, fval3, fval4, fval5);
	    break;

	  case GP1_SET_MAT_3D:
	    printf("GP1_SET_MAT_3D");
	    
     	    /*
 	     * SET_MATRIX_3D | matrix
 	     * (float) Mat[1,1]
 	     * (float) Mat[1,2]
 	     *	...
 	     * (float) Mat[4,4]
 	     */
	    n = 0;
	    printf(" | %d\n", arg);
mat3d:	    while (++n <= 4) {/* 4 x 4 matrix */
		FLOAT_GETS_SHORTS(&fval0, ptr);
		FLOAT_GETS_SHORTS(&fval1, ptr);
		FLOAT_GETS_SHORTS(&fval2, ptr);
		FLOAT_GETS_SHORTS(&fval3, ptr);		
		printf("\t%f\t%f\t%f\t%f\n",
		       fval0, fval1, fval2, fval3);
	    }
	    break;

	  case GP1_GET_MAT_2D:
	    printf("GP1_GET_MAT_2D");
	    
 	    /*
 	     * GETMATRIX_2D | matrix
 	     * (short) ready flag
 	     * (float) Mat[1,1]
 	     * ...
 	     * (float) Mat[3, 2]
 	     */
	    n = 0;
	    printf("\t| %d, ready flag = %d\n", arg, *ptr);
	    ptr++;
	    goto mat2d;

	  case GP1_GET_MAT_3D:
	    printf("GP1_GET_MAT_3D");
	    
 	    /*
 	     * GETMATRIX_3D | matrix
 	     * (short) ready flag
 	     * (float) Mat[1,1]
 	     * ...
 	     * (float) Mat[4,4]
 	     */
	    n = 0;
	    printf(" | %d, ready flag = %d\n", arg, *ptr);
	    ptr++;
	    goto mat3d;

	  case GP1_SET_VWP_2D:
	    printf("GP1_SET_VWP_2D");
	    
 	    /*
 	     * SETVPW_2D
 	     * (float) X scale factor
 	     * (float) X offset
 	     * (float) Y scale factor
 	     * (float) Y offset
 	     */
	    FLOAT_GETS_SHORTS(&fval0, ptr);
	    FLOAT_GETS_SHORTS(&fval1, ptr);
	    FLOAT_GETS_SHORTS(&fval2, ptr);
	    FLOAT_GETS_SHORTS(&fval3, ptr);		
	    printf("\t%f\t%f\t%f\t%f\n",
		   fval0, fval1, fval2, fval3);
	    break;

	  case GP1_SET_VWP_3D:
	    printf("GP1_SET_VWP_3D");
	    
 	    /*
 	     * SETVPW_3D
 	     * (float) X scale factor
 	     * (float) X offset
 	     * (float) Y scale factor
 	     * (float) Y offset
 	     * (float) Z scale factor
 	     * (float) Z offset
 	     */
	    FLOAT_GETS_SHORTS(&fval0, ptr);
	    FLOAT_GETS_SHORTS(&fval1, ptr);
	    FLOAT_GETS_SHORTS(&fval2, ptr);
	    FLOAT_GETS_SHORTS(&fval3, ptr);		
	    FLOAT_GETS_SHORTS(&fval4, ptr);
	    FLOAT_GETS_SHORTS(&fval5, ptr);		
	    printf("\t(%f,%f)\t(%f,%f)\t(%f,%f)\n",
		   fval0, fval1, fval2, fval3, fval4, fval5);
	    break;

	  case GP1_XFVEC_3D:
	    printf("GP1_XFVEC_3D");
	    
 	    /*
 	     * XFVEC_3D
 	     * (short) number of vectors (each vector is 2 endpoints)
 	     * (float) X coordinate of endpoint 1 |
 	     * (float) Y coordinate of endpoint 1 |
 	     * (float) Z coordinate of endpoint 1 |------- vector 1
 	     * (float) X coordinate of endpoint 2 |
 	     * (float) Y coordinate of endpoint 2 |
 	     * (float) Z coordinate of endpoint 2 |
 	     *	...
 	     * (float) X coordinate of endpoint 2n - 1 |
 	     * (float) Y coordinate of endpoint 2n - 1 |
 	     * (float) Z coordinate of endpoint 2n - 1 |------- vector n
 	     * (float) X coordinate of endpoint 2n     |
 	     * (float) Y coordinate of endpoint 2n     |
 	     * (float) Z coordinate of endpoint 2n     |
 	     */
	    printf("\t%d vectors\n", n = *ptr++);
	    i = 0;
	    while (--n >= 0) { 		/* print vector endpoints */
		FLOAT_GETS_SHORTS(&fval0, ptr);
		FLOAT_GETS_SHORTS(&fval1, ptr);
		FLOAT_GETS_SHORTS(&fval2, ptr);
		FLOAT_GETS_SHORTS(&fval3, ptr);		
		FLOAT_GETS_SHORTS(&fval4, ptr);
		FLOAT_GETS_SHORTS(&fval5, ptr);				
		printf("%d\t%f\t%f\t%f\n\t%f\t%f\t%f\n", ++i,
		       fval0, fval1, fval2, fval3, fval4, fval5);
	    }
	    break;
	    
	  case GP1_XFVEC_2D:
	    printf("GP1_XFVEC_2D");
	    
 	    /*
 	     * XFVEC_2D
 	     * (short) number of vectors (each vector is 2 endpoints)
 	     * (float) X coordinate of endpoint 1 |
 	     * (float) Y coordinate of endpoint 1 |------ vector 1
 	     * (float) X coordinate of endpoint 2 |
 	     * (float) Y coordinate of endpoint 2 |
 	     *	...
 	     * (float) X coordinate of endpoint 2n - 1 |
 	     * (float) Y coordinate of endpoint 2n - 1 |------- vector n
 	     * (float) X coordinate of endpoint 2n     |
 	     * (float) Y coordinate of endpoint 2n     |
 	     */
	     printf("\t%d vectors\n", n = *ptr++);
	     i = 0;
	     while (--n >= 0) {		/* print vector endpoints */
		 FLOAT_GETS_SHORTS(&fval0, ptr);
		 FLOAT_GETS_SHORTS(&fval1, ptr);
		 FLOAT_GETS_SHORTS(&fval2, ptr);
		 FLOAT_GETS_SHORTS(&fval3, ptr);		
		 printf("%d\t(%f, %f)\t(%f, %f)\n", ++i,
			fval0, fval1, fval2, fval3);
	     }
	     break;
	     
	   case GP1_CORENDCVEC_3D:		/* vector list */
	     printf("GP1_CORENDCVEC_3D");
	     
 	    /*
 	     * XFVEC_3D
 	     * (short) number of vectors (each vector is 2 endpoints)
 	     * (int) X coordinate of endpoint 1 |
 	     * (int) Y coordinate of endpoint 1 |
 	     * (int) Z coordinate of endpoint 1 |------- vector 1
 	     * (int) X coordinate of endpoint 2 |
 	     * (int) Y coordinate of endpoint 2 |
 	     * (int) Z coordinate of endpoint 2 |
 	     *	...
 	     * (int) X coordinate of endpoint 2n - 1 |
 	     * (int) Y coordinate of endpoint 2n - 1 |
 	     * (int) Z coordinate of endpoint 2n - 1 |------- vector n
 	     * (int) X coordinate of endpoint 2n     |
 	     * (int) Y coordinate of endpoint 2n     |
 	     * (int) Z coordinate of endpoint 2n     |
 	     */
	    printf("\t%d vectors\n", n = *ptr++);
	    i = 0;
	    while (--n >= 0) {	/* print vector endpoints */
		INT_GETS_SHORTS(&ival0, ptr);
		INT_GETS_SHORTS(&ival1, ptr);
		INT_GETS_SHORTS(&ival2, ptr);
		INT_GETS_SHORTS(&ival3, ptr);
		INT_GETS_SHORTS(&ival4, ptr);
		INT_GETS_SHORTS(&ival5, ptr);
		printf("%d\t%d\t%d\t%d\n\t%d\t%d\t%d\n", ++i,
		       ival0, ival1, ival2, ival3, ival4, ival5);
	    }
	    break;
	    
	  case GP1_PROC_LINE_FLT_3D:
	    printf("GP1_PROC_LINE_FLT_3D");
	    
	    printf("\t%d vectors\n", n = *ptr++);
	    i = 0;
	    while (--n >= 0) {	
		if (*(ptr + 13) != 0) {
		    ptr++; /* skip over clip indicator */
		    FLOAT_GETS_SHORTS(&fval0, ptr);
		    FLOAT_GETS_SHORTS(&fval1, ptr);
		    FLOAT_GETS_SHORTS(&fval2, ptr);
		    FLOAT_GETS_SHORTS(&fval3, ptr);		
		    FLOAT_GETS_SHORTS(&fval4, ptr);
		    FLOAT_GETS_SHORTS(&fval5, ptr);
		    printf("%d\t%f\t%f\t%f\n\t%f\t%f\t%f\n", ++i,
			   fval0, fval1, fval2, fval3, fval4, fval5);
		    ptr++; /* skip over ready flag */
		    
		}
		else {
		    printf("%d (%4.4x)", ++i, (unsigned int) *ptr++); 
		    INT_GETS_SHORTS(&ival0, ptr);
		    INT_GETS_SHORTS(&ival1, ptr);
		    INT_GETS_SHORTS(&ival2, ptr);
		    INT_GETS_SHORTS(&ival3, ptr);
		    INT_GETS_SHORTS(&ival4, ptr);
		    INT_GETS_SHORTS(&ival5, ptr);
		    printf("\t%d\t%d\t%d\n\t\t%d\t%d\t%d\n",
			   ival0, ival1, ival2, ival3, ival4, ival5);
		    ptr++; /* skip over ready flag */
		}
	    } /* end while */
	    break;

	  case GP1_PROC_LINE_FLT_2D:
	    printf("GP1_PROC_LINE_FLT_2D");
	    
	    printf("\t%d vectors\n", n = *ptr++);
	    i = 0;
	    while (--n >= 0) {	
		if (*(ptr + 9) != 0) {
		    ptr++; /* skip over clip indicator */
		    FLOAT_GETS_SHORTS(&fval0, ptr);
		    FLOAT_GETS_SHORTS(&fval1, ptr);
		    FLOAT_GETS_SHORTS(&fval2, ptr);
		    FLOAT_GETS_SHORTS(&fval3, ptr);		
		    printf("%d\t%f\t%f\n\t%f\t%f\n", ++i,
			   fval0, fval1, fval2, fval3);
		    ptr++; /* skip over ready flag */
		    
		}
		else {
		    printf("%d (%4.4x)", ++i, (unsigned int) *ptr++); 
		    INT_GETS_SHORTS(&ival0, ptr);
		    INT_GETS_SHORTS(&ival1, ptr);
		    INT_GETS_SHORTS(&ival2, ptr);
		    INT_GETS_SHORTS(&ival3, ptr);
		    printf("\t%d\t%d\n\t\t%d\t%d\n",
			   ival0, ival1, ival2, ival3);
		    ptr++; /* skip over ready flag */
		}
	    } /* end while */
	    break;

	  case GP1_CGIVEC:			/* vector list */
	    printf("GP1_CGIVEC");
	    
 	    /*
 	     * (short) number of vectors (each vector is 2 endpoints)
 	     * (int) X coordinate of endpoint 1 |
 	     * (int) Y coordinate of endpoint 1 |------ vector 1
 	     * (int) X coordinate of endpoint 2 |
 	     * (int) Y coordinate of endpoint 2 |
 	     *	...
 	     * (int) X coordinate of endpoint 2n - 1 |
 	     * (int) Y coordinate of endpoint 2n - 1 |------- vector n
 	     * (int) X coordinate of endpoint 2n     |
 	     * (int) Y coordinate of endpoint 2n     |
 	     */
	    printf("\t%d vectors\n", n = *ptr++);
	    i = 0;
	    while (--n >= 0) {	/* print vector endpoints */
		INT_GETS_SHORTS(&ival0, ptr);
		INT_GETS_SHORTS(&ival1, ptr);
		INT_GETS_SHORTS(&ival2, ptr);
		INT_GETS_SHORTS(&ival3, ptr);
		printf("%d\t%d\t%d\t%d\n\t%d\n", ++i,
		       ival0, ival1, ival2, ival3);
	    }
	    break;
	    
	  case GP1_XF_PGON_INT_3D:		/* 3D polygon */
	    printf("GP1_XF_PGON_INT_3D");
	    
 	    /*
	     * CORENDCPOLY_3D | [ SHADE_CONSTANT or SHADE_GOURAUD ]
 	     * (short) number of polygons
 	     * (short) number of vectors for polygon 1
 	     * (short) number of vectors for polygon 2
 	     *	...
 	     * (int) X coordinate of vector 1 |
 	     * (int) Y coordinate of vector 1 |
 	     * (int) Z coordinate of vector 1 |
 	     * (short) color | G shaded only  |
 	     * (short) 0     |		  |
 	     *	...			  |---- polygon 1
 	     * (int) X coordinate of vector n |
 	     * (int) Y coordinate of vector n |
 	     * (int) Z coordinate of vector n |
 	     * (short) color | G shaded only  |
 	     * (short) 0     |		  |
 	     *	...
 	     * (int) X coordinate of vector 1 |
 	     * (int) Y coordinate of vector 1 |
 	     * (int) Z coordinate of vector 1 |
 	     * (short) color | G shaded only  |
 	     * (short) 0     |		  |
 	     *	...			  |---- polygon 2
 	     * (int) X coordinate of vector n |
 	     * (int) Y coordinate of vector n |
 	     * (int) Z coordinate of vector n |
 	     * (short) color | G shaded only  |
 	     * (short) 0     |		  |
 	     */
	    printf("\t%s, %d bound(s)\n",  arg ?
		   "SHADE_GOURAUD" : "SHADE_CONSTANT", nb = *ptr);
	    ++ptr;
	    i = 0; nv = 0;
	    while (--nb >= 0) {		/* for each bound */
		printf("Bound %d, %d vectors\n", ++i, *ptr);
		nv += *ptr++;
	    }
	    i = 0;
	    while (--nv >= 0) {		/* for each vector */
		INT_GETS_SHORTS(&ival0, ptr);
		INT_GETS_SHORTS(&ival1, ptr);
		INT_GETS_SHORTS(&ival2, ptr);		
		printf("%d\t%d\t%d\t%d", ++i,
		       ival0, ival1, ival2);
		 if (arg) {		/* shaded? get color */
		     printf("\t%d\n", *ptr++);
		     ptr++;			/* skip the 0 */
		 }
		 else 
		     printf("\n");
	     }
	    break;

	  case GP1_XF_PGON_FLT_3D:		/* 3D polygon */
	    printf("GP1_XF_PGON_FLT_3D");
	    
	    short_ptr = ptr;
	    print_poly3d(&short_ptr, arg, TRUE);
	    ptr = short_ptr;
	    break;
	    
	  case GP1_PROC_PGON_FLT_3D:	    
	    printf("GP1_PROC_PGON_FLT_3D");
	    
	    short_ptr = ptr;	    
	    print_poly3d(&short_ptr, arg, TRUE);
	    ptr = short_ptr;
	    if (*ptr != 0) {
		printf("\tmax shorts = %d\n", *ptr++);
		ptr++;		/* skip over the EOCL */
	    }
	    else {	/* poly is xformed */
		ptr += 2;	/* skip over max_shorts and EOCL */
		printf("transformed, clipped polygon:\n");
		short_ptr = ptr;	    		
		print_poly3d(&short_ptr, arg, FALSE);
		ptr = short_ptr;
	    }
	    break;
	    
	    
	  case GP1_XF_PGON_FLT_2D:		/* 2D polygon */
	    printf("GP1_XF_PGON_FLT_2D");
	    if (arg == GP1_SHADE_TEX)
		printf("\t(Textured)");
	    short_ptr = ptr;
	    print_poly2d(&short_ptr, TRUE);
	    ptr = short_ptr;
	    break;
	    
	  case GP1_PROC_PGON_FLT_2D:	    
	    printf("GP1_PROC_PGON_FLT_2D");
	    
	    if (arg == GP1_SHADE_TEX)
		printf("\t(Textured)");
	    short_ptr = ptr;	   	    
	    print_poly2d(&short_ptr, TRUE);
	    ptr = short_ptr;
	    if (*ptr != 0) {
		printf("\tmax shorts = %d\n", *ptr++);
		ptr++;		/* skip over the EOCL */
	    }
	    else {	/* poly is xformed */
		ptr += 2;	/* skip over max_shorts and EOCL */
		printf("transformed, clipped polygon:\n");
		short_ptr = ptr;	    		
		print_poly2d(&short_ptr, FALSE);
		ptr = short_ptr;
	    }
	    break;
	    
	    
	  case GP1_SET_CLIP_LIST:		/* clip list */
	    printf("GP1_SET_CLIP_LIST");
	    
	    i = 0;
	    n = *ptr++;			/* how many rectangles */
	    printf("\n");
	    while (--n >= 0) {
		printf("%d\t%d,%d  %d,%d\n", ++i, *ptr, *(ptr + 1),
		       *(ptr + 2), *(ptr + 3));
		ptr += 4;
	    }
	    break;
	    
	  case GP1_SET_HIDDEN_SURF:
	    printf("GP1_SET_HIDDEN_SURF");
	    if (arg == GP1_NOHIDDENSURF)
		printf("\tGP1_NOHIDDENSURF\n");
	    else if (arg == GP1_ZBHIDDENSURF)
		printf("\tGP1_ZBHIDDENSURF\n");
	    break;
	    
	  case GP1_SET_PGON_TEX_BLK:
	    printf("GP1_SET_PGON_TEX_BLK\t texture block = %d\n", arg);
	    break;
	    
	  case GP1_SET_PGON_TEX:
	    {   
		short	depth, width, height, num_words;
		
		printf("GP1_SET_PGON_TEX");
	        /* polygon texture fill */
		
		depth = *ptr++;
		width = *ptr++;
		height = *ptr++;
		if (depth == 1)
		    num_words = ((width + 15) >> 4) * height;
		else /* depth == 8 */
		    num_words = ((width + 1) >> 1) * height;
		printf("\t depth = %2d; (%3d, %3d) => %d words\n", 
		       depth, width, height, num_words);
		
		for (i = 0; i < num_words; i++) {
		    printf("0x%4.4x  ", *ptr++);
		    if ((i % 8) == 7)
			printf("\n");
		}
		printf("\n");
	    }
	    break;
	    
	  case GP1_SET_PGON_TEX_ORG_SCR:
	    printf("GP1_SET_PGON_TEX_ORG_SCR");
	    ival0 = *ptr++;
	    ival1 = *ptr++;
	    printf("\t(%3d, %3d)\n", ival0, ival1);
	    break;
	   
	  case GP1_SET_PGON_TEX_ORG_XF_2D:
	    printf("GP1_SET_PGON_TEX_ORG_XF_2D");
	    FLOAT_GETS_SHORTS(&fval0, ptr);
	    FLOAT_GETS_SHORTS(&fval1, ptr);		
	    printf("\t(%f, %f)\n", fval0, fval1);
	    break;	    
	    
	  case GP1_SET_PGON_TEX_ORG_XF_3D:
	    printf("GP1_SET_PGON_TEX_ORG_XF_3D");
	    FLOAT_GETS_SHORTS(&fval0, ptr);
	    FLOAT_GETS_SHORTS(&fval1, ptr);		
	    FLOAT_GETS_SHORTS(&fval2, ptr);		
	    printf("\t(%f, %f, %f)\n", fval0, fval1, fval2);
	    break;	    
	    
	  case GP1_SET_LINE_TEX:
	    printf("GP1_SET_LINE_TEX\n");
	    printf("\tpattern:\n");
	    for (i = 0; *ptr != 0; ptr++, i++)
		printf("\t[%2d] = %d\n", i, (unsigned int)*ptr);
	    printf("\t[%2d] = NULL - end of pattern\n", i);
	    ptr++;
	    printf("\toffset:  %d\n", *ptr++);
	    printf("\toptions: 0x%4.4x\n", *ptr++);
	    break;
	    
	  case GP1_SET_LINE_WIDTH:
	    printf("GP1_SET_LINE_WIDTH");
	    printf("\twidth = %d", *ptr++);
	    printf("\toptions = %d\n", *ptr++);
	    break;

	  case GP1_XF_LINE_FLT_2D:
	    printf("GP1_XF_LINE_FLT_2D:\n");
	    do {
		short_ptr = ptr++;
		FLOAT_GETS_SHORTS(&fval0, ptr);
		FLOAT_GETS_SHORTS(&fval1, ptr);	
		printf("\t%s\t(%f, %f)\n", 
		       (*short_ptr & 0x1 ? "Move" : "Draw"), 
		       fval0, fval1);
	    } while ((*short_ptr & 0x8000) == 0);
	    break;
	  
	  case GP1_XF_LINE_FLT_3D:
	    printf("GP1_XF_LINE_FLT_3D:\n");
	    do {
		short_ptr = ptr++;
		FLOAT_GETS_SHORTS(&fval0, ptr);
		FLOAT_GETS_SHORTS(&fval1, ptr);	
		FLOAT_GETS_SHORTS(&fval2, ptr);	
		printf("\t%s\t(%f, %f, %f)\n", 
		       (*short_ptr & 0x1 ? "Move" : "Draw"), 
		       fval0, fval1, fval2);
	    } while ((*short_ptr & 0x8000) == 0);
	    break;
	  
	  default:
	    printf("Unknown op (%d) with arg (%d)\n", (op >> 8), arg);
	    break;
	    
       }/* end switch */
    } /* end while */
}



/* 
 * Print out a polygon; *ptr_ptr should point to the number of
 * bounds in the polygon.
 */

            /*
 	     * XFPOLYGON_3D | [ SHADE_CONSTANT or SHADE_GOURAUD ]
 	     * (short) number of boundries
 	     * (short) number of vectors for boundry 1
 	     * (short) number of vectors for boundry 2
 	     *	...
 	     * (float) X coordinate of vector 1 |
 	     * (float) Y coordinate of vector 1 |
 	     * (float) Z coordinate of vector 1 |
 	     * [(int)   color] shaded only      |
 	     *	...			    |---- end boundry 1
 	     * (float) X coordinate of vector n |
 	     * (float) Y coordinate of vector n |
 	     * (float) Z coordinate of vector n |
 	     * (short) color | G shaded only    |
 	     * (short) 0     |		    |
 	     *	...
 	     * (float) X coordinate of vector 1 |
 	     * (float) Y coordinate of vector 1 |
 	     * (float) Z coordinate of vector 1 |
 	     * (short) color | G shaded only    |
 	     * (short) 0     |		    |
 	     *	...			    |---- end boundry 2
 	     * (float) X coordinate of vector n |
 	     * (float) Y coordinate of vector n |
 	     * (float) Z coordinate of vector n |
 	     * (short) color | G shaded only    |
 	     * (short) 0     |		    |
 	     */
     
     
static
void
print_poly3d(ptr_ptr, shade_type, is_float)
short	**ptr_ptr;
unsigned char	shade_type;
int	is_float;
{   
    register	short	*ptr;
    register	int	nb, nv, i;
    		float	fval0, fval1, fval2;
		int	ival0, ival1, ival2;
    
    ptr = *ptr_ptr;
    switch (shade_type) {
      case GP1_SHADE_CONSTANT:
	printf("\tGP1_SHADE_CONSTANT");
	break;
      case GP1_SHADE_GOURAUD:
	printf("\tGP1_SHADE_GOURAUD");
	break;
      case GP1_SHADE_TEX:
	printf("\tGP1_SHADE_TEX");
	break;
    }
    printf(", %d bound(s)\n", (nb = *ptr));
    ++ptr;
    i = 0;
    nv = 0;
    while (--nb >= 0) {		/* for each bound */
	printf("Bound %d, %d vertices\n", ++i, *ptr);
	nv += *ptr++;
    }
    i = 0;
    if (is_float) {
	while (--nv >= 0) {	/* for each vertex */
	    FLOAT_GETS_SHORTS(&fval0, ptr);
	    FLOAT_GETS_SHORTS(&fval1, ptr);
	    FLOAT_GETS_SHORTS(&fval2, ptr);		
	    printf("%d\t%f\t%f\t%f", ++i,
		   fval0, fval1, fval2);
	    if (shade_type == GP1_SHADE_GOURAUD) {	/* shaded? get color */
		INT_GETS_SHORTS(&ival0, ptr);
		printf("\t%x\n", ival0);
	    }
	    else 
		printf("\n");
	}
    }
    else {
	while (--nv >= 0) {	/* for each vertex */
	    INT_GETS_SHORTS(&ival0, ptr);
	    INT_GETS_SHORTS(&ival1, ptr);
	    INT_GETS_SHORTS(&ival2, ptr);		
	    printf("%d\t%d\t%d\t%d", ++i,
		   ival0, ival1, ival2);
	    if (shade_type == GP1_SHADE_GOURAUD) {	/* shaded? get color */
		INT_GETS_SHORTS(&ival0, ptr);
		printf("\t%x\n", ival0);
	    }
	    else 
		printf("\n");
	}
	
    }
    *ptr_ptr = ptr;
}


static
void
print_poly2d(ptr_ptr, is_float)
short	**ptr_ptr;
int	is_float;
{   
    register	short	*ptr;
    register	int	nb, nv, i;
    		float	fval0, fval1;
    		int	ival0, ival1;
 
    ptr = *ptr_ptr;
		
    printf("\t%d bound(s)\n", nb = *ptr++);
    i = 0; 
    nv = 0;
    while (--nb >= 0) {		/* for each bound */
	printf("Bound %d, %d vertices\n", ++i, *ptr);
	nv += *ptr++;
    }
    i = 0;
    if (is_float) {
	while (--nv >= 0) {		/* for each vector */
	    FLOAT_GETS_SHORTS(&fval0, ptr);
	    FLOAT_GETS_SHORTS(&fval1, ptr);		
	    printf("%d\t%f\t%f\n", ++i, 
		   fval0, fval1);
	}
    }
    else {
	while (--nv >= 0) {		/* for each vector */
	    INT_GETS_SHORTS(&ival0, ptr);
	    INT_GETS_SHORTS(&ival1, ptr);		
	    printf("%d\t%d\t%d\n", ++i, 
		   ival0, ival1);
	}
    }
        
    *ptr_ptr = ptr;
}
