#ifndef lint
static	char sccsid[] = "@(#)dev_gp1_poly.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


#include "dev_gp1_internal.h"

int
Dev_gp1_polygon_3df(gp1, n_bounds, bounds, pts, shade)
		GP1		*gp1;
 		int		n_bounds;
		int		*bounds;
register	Point3df	*pts;
 		int		shade;
{   
    register	int		total_size;
    register	int		i;
    register	int		total_vertices;
    register	short		*ptr;
    
    total_size = 2 * sizeof(short) + n_bounds * sizeof(short);
    for (i = 0; i < n_bounds; i++)
	total_size += bounds[i] * 3 * sizeof(float);
    if (total_size > (GP1_BYTES_PER_BLOCK * gp1->n_buffers - 8))
	return(-1);	/* cannot fit polygon in cmd buffers */
    
    MAKE_ROOM(gp1, total_size);
    gp1->list_type = GP1_NO_LIST;
    
    ptr = gp1->cur_ptr;
    
    *ptr++ = GP1_XF_PGON_FLT_3D | (shade & 0x7);
    *ptr++ = n_bounds;
    total_vertices = 0;
    for (i = 0; i < n_bounds; i++)	/* store number of pts in each bound */
	total_vertices += (*ptr++ = bounds[i]);
    
    for (i = 0; i < total_vertices; i++) {
	SHORTS_GET_FLOAT(ptr, &(pts->x));
	SHORTS_GET_FLOAT(ptr, &(pts->y));
	SHORTS_GET_FLOAT(ptr, &(pts->z));
	pts++;
    }
    gp1->cur_ptr = ptr;
    
    return(0);
}


int
Dev_gp1_polygon_2df(gp1, n_bounds, bounds, pts, shade)
		GP1		*gp1;
 		int		n_bounds;
		int		*bounds;
register	Point2df	*pts;
 		int		shade;
{   
    register	int		total_size;
    register	int		i;
    register	int		total_vertices;
    register	short		*ptr;
    
    total_size = 2 * sizeof(short) + n_bounds * sizeof(short);
    for (i = 0; i < n_bounds; i++)
	total_size += bounds[i] * 2 * sizeof(float);
    if (total_size > (GP1_BYTES_PER_BLOCK * gp1->n_buffers - 8))
	return(-1);	/* cannot fit polygon in cmd buffers */
    
    MAKE_ROOM(gp1, total_size);
    gp1->list_type = GP1_NO_LIST;
    
    ptr = gp1->cur_ptr;
    
    *ptr++ = GP1_XF_PGON_FLT_2D | (shade & 0x7);
    *ptr++ = n_bounds;
    total_vertices = 0;
    for (i = 0; i < n_bounds; i++)	/* store number of pts in each bound */
	total_vertices += (*ptr++ = bounds[i]);
    
    for (i = 0; i < total_vertices; i++) {
	SHORTS_GET_FLOAT(ptr, &(pts->x));
	SHORTS_GET_FLOAT(ptr, &(pts->y));
	pts++;
    }
    gp1->cur_ptr = ptr;
    
    return(0);
}


void
Dev_gp1_set_texture_org_screen(gp1, x, y)
GP1	*gp1;
int	x, y;
{   
    register	short		*ptr;
    
    MAKE_ROOM(gp1, 3 * sizeof(short));
    gp1->list_type = GP1_NO_LIST;
    ptr = gp1->cur_ptr;
    
    *ptr++ = GP1_SET_PGON_TEX_ORG_SCR;
    *ptr++ = (short)x;
    *ptr++ = (short)y;
    gp1->cur_ptr = ptr;
}


void
Dev_gp1_set_texture_org_2df(gp1, pt)
GP1		*gp1;
Point2df	*pt;
{   
    register	short		*ptr;
    
    MAKE_ROOM(gp1, sizeof(short) + 2 * sizeof(float));
    gp1->list_type = GP1_NO_LIST;
    ptr = gp1->cur_ptr;
    
    *ptr++ = GP1_SET_PGON_TEX_ORG_XF_2D;
    SHORTS_GET_FLOAT(ptr, &(pt->x));
    SHORTS_GET_FLOAT(ptr, &(pt->y));
    gp1->cur_ptr = ptr;
}

void
Dev_gp1_set_texture_org_3df(gp1, pt)
GP1		*gp1;
Point3df	*pt;
{   
    register	short		*ptr;
    
    MAKE_ROOM(gp1, sizeof(short) + 3 * sizeof(float));
    
    gp1->list_type = GP1_NO_LIST;
    ptr = gp1->cur_ptr;
    
    *ptr++ = GP1_SET_PGON_TEX_ORG_XF_3D;
    SHORTS_GET_FLOAT(ptr, &(pt->x));
    SHORTS_GET_FLOAT(ptr, &(pt->y));
    SHORTS_GET_FLOAT(ptr, &(pt->z));
    gp1->cur_ptr = ptr;
}



int
Dev_gp1_set_polygon_texture(gp1, pr)
 	 	GP1		*gp1;
register	Pixrect		*pr;
{   
    register	short		*ptr;
    register	int		total_bytes;
    		short		*Dev_gp1_load_texture();
    
    if (pr->pr_depth == 1)
	total_bytes = (((pr->pr_size.x + 15) >> 4) << 1) * pr->pr_size.y;
    else    
	total_bytes = (((pr->pr_size.x + 1) >> 1) << 1) * pr->pr_size.y;
    
    if (total_bytes > GP1_BYTES_PER_BLOCK)
	return(-1);	/* cannot fit texture in texture block */
    
    MAKE_ROOM(gp1, total_bytes);
    gp1->list_type = GP1_NO_LIST;
    
    ptr = gp1->cur_ptr;
    
    *ptr++ = GP1_SET_PGON_TEX;
    gp1->cur_ptr = Dev_gp1_load_texture(pr,  ptr);
    
    return(0);
}
    
    
