#ifndef lint
static	char sccsid[] = "@(#)dev_gp1_mat.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/*
 * This file contains routines for setting and retrieving 3d and 2d
 * matrices.  And for selecting the current matrix.
 */

#include "dev_gp1_internal.h"

static	void	get_mat();


void
Dev_gp1_set_matrix_3d(gp1, index, mat)
register	GP1		*gp1;
 		int		index;
		Matrix3df	mat;
{
    gp1->list_type = GP1_NO_LIST;	/* close any list in process */
    MAKE_ROOM(gp1, (sizeof(short) + sizeof(Matrix3df)));
    
    *(gp1->cur_ptr)++ = GP1_SET_MATRIX_3D | (index & 0xff);    
    bcopy((char *)mat, (char *)gp1->cur_ptr, sizeof(Matrix3df));
    gp1->cur_ptr += sizeof(Matrix3df) / sizeof(short);
}




void
Dev_gp1_set_matrix_2d(gp1, index, mat)
register	GP1		*gp1;
 		int		index;
 		Matrix2df	mat;
{
    gp1->list_type = GP1_NO_LIST;	/* close any list in process */
    MAKE_ROOM(gp1, (sizeof(short) + sizeof(Matrix2df)));
    
    *(gp1->cur_ptr)++ = GP1_SET_MATRIX_2D | (index & 0xff);    
    bcopy((char *)mat, (char *)gp1->cur_ptr, sizeof(Matrix2df));
    gp1->cur_ptr +=  sizeof(Matrix2df) / sizeof(short);
}



void
Dev_gp1_select_matrix(gp1, index)
register	GP1		*gp1;
 		int		index;
{   
    gp1->list_type = GP1_NO_LIST;	/* close any list in process */
    MAKE_ROOM(gp1, sizeof(short));
    
    *(gp1->cur_ptr)++ = GP1_SET_MAT_NUM | (index & 0xff);    
}



void
Dev_gp1_matrix_mul_2d(gp1, result, a, b)
register	GP1	*gp1;
 		int	result, a, b;
{   
    gp1->list_type = GP1_NO_LIST;	/* close any list in process */
    MAKE_ROOM(gp1, 4 * sizeof(short));
    
    *(gp1->cur_ptr)++ = GP1_MATMUL_2D;
    *(gp1->cur_ptr)++ = a;
    *(gp1->cur_ptr)++ = b;
    *(gp1->cur_ptr)++ = result;
}
    

void
Dev_gp1_matrix_mul_3d(gp1, result, a, b)
register	GP1	*gp1;
 		int	result, a, b;
{   
    gp1->list_type = GP1_NO_LIST;	/* close any list in process */
    MAKE_ROOM(gp1, 4 * sizeof(short));
    
    *(gp1->cur_ptr)++ = GP1_MATMUL_3D;
    *(gp1->cur_ptr)++ = a;
    *(gp1->cur_ptr)++ = b;
    *(gp1->cur_ptr)++ = result;
}



void
Dev_gp1_get_matrix_2d(gp1, index, mat)
register	GP1		*gp1;
 		int		index;
 		Matrix2df	mat;
{   
    
    gp1->list_type = GP1_NO_LIST;	/* close any list in process */
    MAKE_ROOM(gp1, (2 * sizeof(short) + sizeof(Matrix2df)));
    
    *(gp1->cur_ptr)++ = GP1_GETMATRIX_2D | (index & 0xff);    
    
    get_mat(gp1, sizeof(Matrix2df), mat);
}

void
Dev_gp1_get_matrix_3d(gp1, index, mat)
register	GP1		*gp1;
 		int		index;
 		Matrix3df	mat;
{   
    
    gp1->list_type = GP1_NO_LIST;	/* close any list in process */
    MAKE_ROOM(gp1, (2 * sizeof(short) + sizeof(Matrix3df)));
    
    *(gp1->cur_ptr)++ = GP1_GETMATRIX_3D | (index & 0xff);
    
    get_mat(gp1, sizeof(Matrix3df), mat);
}



static
void
get_mat(gp1, mat_size, mat)
register	GP1	*gp1;
 		int	mat_size;	/* in bytes */
		float	*mat;
{
    register	short		*ready_flag;
    register	short		*result;
     		Rect		win_size;
    register	int		new_clip_id;
    
    ready_flag = (gp1->cur_ptr)++;
    *ready_flag = 0xFF;			/* read flag starts off with a
					 * non-zero value. 
					 */
    result = gp1->cur_ptr;
    ((char *)gp1->cur_ptr) += mat_size; /* leave room for the result */
    
    /* flush the buffers but don't free the blocks */
    Dev_gp1_flush(gp1, FALSE);
    
    /* 
     * This routine returns -1 if it fails. this info should be 
     * incorporated some how...
     */
    gp1_wait0(ready_flag, gp1->fd); /* wait for gp1 to process cmds */
    
    bcopy((char *)result, (char *)mat, mat_size);
}

