#ifndef lint
static	char sccsid[] = "@(#)dev_gp1_ldtex.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


#include <pixrect/pixrect_hs.h>
#include <pixrect/gp1cmds.h>
#include <stdio.h>

/* 
 * Given a memory pixrect and a pointer to the GP1's shared memory,
 * stuff the contents of the pixrect into the shared memory. The pixrect
 * represents a texture that will be used to fill a polygon.
 * 
 * It is up to the caller to make sure the pixrect will fit on the
 * GP1 and that the pixrect is ONLY 1 or 8 bits deep.
 */

short *
Dev_gp1_load_texture(pr, ptr)
 		Pixrect		*pr;		/* memory pixrect */
register	short		*ptr; 		/* shared memory pointer */
{   
    register	short		*data;		/* data from the pixrect */
    register	short		*row_start;	/* start of a row in the
						 * pixrect.
						 */
    register	int		line_shorts;	/* number of shorts from 
						 * (x, y) to (x, y+1).
						 */
    register	int		row_shorts;	/* number of shorts 
						 * (16 bit words) on a row
						 * of the pixrect.
						 */
    		struct mpr_data	*mprd;		/* memory pixrect data */
		Pixrect		*new_pr;
    register	int		i, row;
	
		
    if (MP_NOTMPR(pr) || (mpr_d(pr)->md_offset.x != 0)) {
	/* 
	 * There is an X offset, or the pixrect is not a memory pixrect.
	 * In either case, I do not want to deal with it. So, create
	 * a new memory pixrect which is easier to deal with.
	 */
	new_pr = mem_create(pr->pr_size.x, pr->pr_size.y, pr->pr_depth);
	pr_rop(new_pr, 0, 0, pr->pr_size.x, pr->pr_size.y,
	       PIX_SRC, 
	       pr, 0, 0);
	pr = new_pr;
    }
    else
	new_pr = NULL;



    mprd = mpr_d(pr);
    line_shorts = mprd->md_linebytes >> 1;
    
    if (mprd->md_offset.y == 0) 
	row_start = mprd->md_image;
    else 
	row_start = mprd->md_image + (line_shorts * mprd->md_offset.y);
    
    if (pr->pr_depth == 1)
	row_shorts = (pr->pr_size.x + 15) >> 4;
    else    
	row_shorts = (pr->pr_size.x + 1) >> 1;
    
    *ptr++ = (short)pr->pr_depth;
    *ptr++ = (short)pr->pr_size.x;
    *ptr++ = (short)pr->pr_size.y;
    
    if (row_shorts != line_shorts) {
	for (row = 0; row < pr->pr_size.y; row++) {
	    data = row_start;
	    for (i = 0; i < row_shorts; i++)
		*ptr++ = *data++;
	    
	    row_start += line_shorts;
	}
    }
    else {
	i = pr->pr_size.y * line_shorts;
	data = row_start;
	while (i--)
	    *ptr++ = *data++;
    }
    
    if (new_pr)
	pr_destroy(new_pr);
    
    return(ptr);
}
    
