#ifndef lint
static	char sccsid[] = "@(#)dev_gp1_atts.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


#include "dev_gp1_internal.h"

/* 
 * These functions set the value of attributes in the static block
 * (or frame). The format of most of the functions is the op_code is in the
 * hi order byte and the value of the attribue is in the low order byte.
 * 
 * Each function makes room for a short in the current buffer and stuffs
 * the op_code and attribute value into the short. Also, we must 
 * indicate that there is no longer a vector list being constructed.
 * 
 * All these functions are also availible as macros.
 */
 
void 
Dev_gp1_set_color(gp1, color)
register	GP1	*gp1;
 		int	color;
{  
    MAKE_ROOM(gp1, sizeof(short));
    
    gp1->list_type = GP1_NO_LIST;
    *(gp1->cur_ptr)++ = GP1_SETCOLOR | (color & 0xff);
}


void
Dev_gp1_set_write_mask(gp1, mask)
register	GP1	*gp1;
 		int	mask;
{  
    MAKE_ROOM(gp1, sizeof(short));
    
    gp1->list_type = GP1_NO_LIST;    
    *(gp1->cur_ptr)++ = GP1_SETPIXPLANES | (mask & 0xff);
}


void
Dev_gp1_set_clip_planes(gp1, mask)
register	GP1	*gp1;
 		int	mask;
{   
    MAKE_ROOM(gp1, sizeof(short));
    
    gp1->list_type = GP1_NO_LIST;    
    *(gp1->cur_ptr)++ = GP1_SETCLIPPLANES | (mask & 0xff);
}


void
Dev_gp1_set_hidden_surf(gp1, type)
register	GP1	*gp1;
 		int	type;
{   
    MAKE_ROOM(gp1, sizeof(short));
    
    gp1->list_type = GP1_NO_LIST;    
    *(gp1->cur_ptr)++ = GP1_SETHIDDENSURF | (type & 0xff);
}



void
Dev_gp1_set_rop_mode(gp1, mode)
register	GP1	*gp1;
 		int	mode;
{   
    MAKE_ROOM(gp1, sizeof(short));
    
    gp1->list_type = GP1_NO_LIST;    
    *(gp1->cur_ptr)++ = GP1_SET_ROP;
    *(gp1->cur_ptr)++ = (short) mode;
}



void
Dev_gp1_set_z_buffer_depth(gp1, depth, x, y, width, height)
register	GP1	*gp1;
 		int	depth;		/* depth value to load in buffer */
 		int	x, y;		/* origin of rectangle */
		int	width, height;	/* size of rectangle */
{   
    MAKE_ROOM(gp1, 6 * sizeof(short));
    
    gp1->list_type = GP1_NO_LIST;    
    *(gp1->cur_ptr)++ = GP1_SET_ZBUF;
    *(gp1->cur_ptr)++ = (unsigned short) depth;
    *(gp1->cur_ptr)++ = (unsigned short) x;
    *(gp1->cur_ptr)++ = (unsigned short) y;
    *(gp1->cur_ptr)++ = (unsigned short) width;
    *(gp1->cur_ptr)++ = (unsigned short) height;
}

