#ifndef lint
static	char sccsid[] = "@(#)demo_util.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include "dev_gp1_internal.h"
#include "demo_util.h"


static	GP1_handle	our_gp1;
static	Pixwin		*our_pw;


GP1_handle
init_gp1(pw)
Pixwin	*pw;
{   
    GP1_handle	gp1;
    int		error;
    
    gp1 = Dev_gp1_create(pw, 2, &error);
    
    if (gp1 == NULL)
	return((GP1_handle)NULL);
    
    compute_viewport(gp1, pw, GP1_TEST_2D_VP);
    
    our_gp1 = gp1;
    our_pw = pw;
    
    return(gp1);
}



/* 
 * Compute the viewport mapping by getting the current position 
 * and size of the window (i.e. canvas). We map the center of
 * the clipping space (0, 0) to the center of the window and map
 * the bounds of the clipping space (-1 and 1) to the size of the window.
 * Note: do calculations in floating point so that we can scale to 
 * whole window.
 */

void
compute_viewport(gp1, pw, which)
GP1_handle	gp1;
Pixwin		*pw;
int		which;
{   
    Rect		size;
    Point2df		scale, offset;
    int			fd, x, y;
    float		width, height;
    
    fd = pw->pw_clipdata->pwcd_windowfd;
    win_getsize(fd, &size);
    win_getscreenposition(fd, &x, &y);	/* this is an undocumented call... */
    
    width = (float)(size.r_width - 1) / 2.0;
    height = (float)(size.r_height - 1) / 2.0;
    
    offset.x = (float)x + width;
    offset.y = (float)y + height;
    
    scale.x = width;
    scale.y = -height;
    
    Dev_gp1_setvp_2d(gp1, &scale, &offset);
    Dev_gp1_flush(gp1, 1);
    
}



/* 
* This function is called by the canvas package when the canvas
* changes size. All we need to is re-compute the viewport mapping.
*/

void
resize_func()
{   
    Dev_gp1_win_change(our_gp1);		/* need to call this first */
    compute_viewport(our_gp1, our_pw, GP1_TEST_2D_VP);
}

