#ifndef lint
static	char sccsid[] = "@(#)box_dev_gp1.ex.c 1.2 86/10/07 SMI";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


/*
 *
 * GP Example #3
 * This example creates a canvas and scales a box dynamically
 * using matrix transformations. Scaled boxes are XOR-ed onto the
 * screen. It uses the DEV_GP1 package for drawing.
 *
 * The coordinate space is 3D floating point with (-1, -1) in the
 * lower left of the canvase and (1, 1) in the upper right.
 * 
 */

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include "dev_gp1_internal.h"

static	int		done;		/* set if user quits */
static	Pixwin		*canvas_pw;
static	GP1_handle	gp1;		/* handle to DEV_GP1 */

static	Notify_value	quit_func();
static	void		resize_func();
 	GP1_handle	init_gp1();

main(argc, argv)
int	argc;
char	*argv[];
{
    Frame	frame;			/* window frame */
    Canvas	canvas;			/* graphics canvas */
    float	scale;			/* scale factor */

    frame = window_create(NULL, FRAME, 
			  FRAME_ARGC_PTR_ARGV, &argc, argv,
			  0);
    canvas = window_create(frame, CANVAS,
			   CANVAS_RETAINED,	FALSE,
			   CANVAS_RESIZE_PROC,	resize_func, 
			   0);
    if ((frame == NULL) || (canvas == NULL)) {
	fprintf(stderr, "can't create window.\n");
	exit(-1);
    }
    
    canvas_pw = canvas_pixwin(canvas);
    gp1 = init_gp1(canvas_pw);
    if (gp1 == NULL) {
	fprintf(stderr, "can't create gp1.\n");
	exit(-1);
    }
    
    window_set(frame, WIN_SHOW, TRUE, 0);	/* need to explicitly 
						 * turn on the window as this
						 * is usually done by 
						 * window_main_loop.
						 */
    (void) notify_interpose_destroy_func(frame, quit_func);

    scale  = 1.0;
    done = FALSE;
    (void) notify_dispatch();    /* allows frame and canvas to be displayed */
    while (!done) { 
	load_scale_matrix(gp1, scale);
	draw_box_polyline(gp1);
	scale -= 0.01;
	if (scale <= -1.0) {   
	    scale = 1.0;
	    Dev_gp1_clear(gp1, 0);
	}
	Dev_gp1_flush(gp1, 1);
	/* 
	 * call notifer to dispatch any events.
	 */
	(void) notify_dispatch();
    }
    
    exit(0);
}



/* 
 * Create an instance of DEV_GP1. Set up the viewport mapping from
 * the clipping coordinate system to the canvas on the screen. The
 * set the raster-op mode to XOR. Note: we use the default values
 * for clipping (off), color (1), and transformation matrix (matrix 0).
 */

GP1_handle
init_gp1(pw)
Pixwin	*pw;
{   
    GP1_handle	gp1;
    int		error;
    
    gp1 = Dev_gp1_create(pw, 2, &error);
    
    if (gp1 == NULL)
	return((GP1_handle)NULL);
    
    compute_viewport(gp1, pw);
    
    Dev_gp1_set_rop_mode(gp1, (PIX_SRC ^ PIX_DST));

    return(gp1);
}



/* 
 * Compute the viewport mapping by getting the current position 
 * and size of the window (i.e. canvas). We map the center of
 * the clipping space (0, 0) to the center of the window and map
 * the bounds of the clipping space (-1 and 1) to the size of the window.
 * Note: do calculations in floating point so that we can scale to 
 * whole window.
 */

compute_viewport(gp1, pw)
GP1_handle	gp1;
Pixwin		*pw;
{   
    Rect		size;
    Point2df		scale, offset;
    int			fd, x, y;
    float		width, height;
    
    fd = pw->pw_clipdata->pwcd_windowfd;
    win_getsize(fd, &size);
    win_getscreenposition(fd, &x, &y);	/* this is an undocumented call... */
    
    width = (float)(size.r_width - 1) / 2.0;
    height = (float)(size.r_height - 1) / 2.0;
    
    offset.x = (float)x + width;
    offset.y = (float)y + height;
    
    scale.x = width;
    scale.y = -height;
    
    Dev_gp1_setvp_2d(gp1, &scale, &offset);
    Dev_gp1_flush(gp1, 1);
    
}



/* 
 * This function is called by the canvas package when the canvas
 * changes size. All we need to is re-compute the viewport mapping.
 */

static
void
resize_func()
{  
    Dev_gp1_win_change(gp1);		/* need to call this first */
    compute_viewport(gp1, canvas_pw);
}




/*
 *
 * quit_func()
 * Come here when "quit" is selected from the main menu.
 * We set a flag for the display loop so we can exit gracefully.
 *
 */

static 
Notify_value
quit_func(frame, status)
Frame		frame;
Destroy_status	status;
{
    if (status != DESTROY_CHECKING) {
	done = TRUE;	
	(void) notify_stop();
    }
    return (notify_next_destroy_func(frame, status));
}



static	Matrix2df	scale_mat = {
    {   1.0, 0.0 }, 
    {   0.0, 1.0 }, 
    {   0.0, 0.0 }
};

/* 
 * Take the scale factor and generate a 2d scale matrix. Since we
 * know all the points are in the range [-1, 1], we can just apply
 * the scale matrix directly to them.
 */

load_scale_matrix(gp1, scale)
GP1_handle	gp1;
float		scale;
{
    scale_mat[0][0] = scale_mat[1][1] = scale;
    Dev_gp1_set_matrix_2d(gp1, 0, scale_mat);
}



/* 
 * Draw a box with corners (-1, 1), (0, 1), (0, 0), and (-1, 0).
 * 
 */

draw_box_polyline(gp1)
GP1_handle	gp1;
{   
    Point2df	pt1;
    
    pt1.x = -1.0;
    pt1.y =  1.0;
    Dev_gp1_move_2df(gp1, &pt1);

    pt1.x =  0.0;
    pt1.y =  1.0;
    Dev_gp1_draw_2df(gp1, &pt1);

    pt1.x =  0.0;
    pt1.y =  0.0;
    Dev_gp1_draw_2df(gp1, &pt1);

    pt1.x = -1.0;
    pt1.y =  0.0;
    Dev_gp1_draw_2df(gp1, &pt1);

    pt1.x = -1.0;
    pt1.y =  1.0;
    Dev_gp1_draw_2df(gp1, &pt1);
}
