/* @(#)p4reg.h 1.1 87/08/20 SMI */

/*
 * Copyright 1987 by Sun Microsystems, Inc.
 */

#ifndef	p4reg_DEFINED
#define	p4reg_DEFINED

/*
 * P4 frame buffer hardware definitions.
 */

/* P4 register bit definitions */
#define	P4_REG_VIDEO		32	/* video enable */
#define	P4_REG_INT		4	/* interrupt detect */
#define	P4_REG_INTCLR		4	/* interrupt clear */
#define	P4_REG_INTEN		2	/* interrupt enable */

/* frame buffer type mask (allows 16 types, 16 resolutions) */
#define	P4_ID_MASK		0xf0

/* base frame buffer type codes */
#define	P4_ID_BW		0	/* memory monochrome */
#define	P4_ID_COLOR8P1		64	/* memory 8 bit color + overlay */

/* resolution codes -- added to base types above */
#define	P4_ID_640X480		5
#define	P4_ID_1152X900		1
#define	P4_ID_1024X1024		2
#define	P4_ID_1280X1024		3
#define	P4_ID_1600X1280		0
#define	P4_ID_1440X1440		4

#define	P4_ID_RESCODES		6

/* offset from P4 register to monochrome memory plane */
#define	P4_BW_OFF		0x100000

/* offsets from P4 register to color f.b. pieces */
#define P4_COLOR_OFF_OVERLAY	0x00100000
#define P4_COLOR_OFF_ENABLE	0x00300000
#define P4_COLOR_OFF_COLOR	0x00500000
#define P4_COLOR_OFF_CMAP	0xfff00000

#endif	!p4reg_DEFINED
